/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmResource;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.orm.resource.OrmArtifactEdit;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class OrmXmlJpaFileContentProvider
implements IJpaFileContentProvider {
    private static final OrmXmlJpaFileContentProvider INSTANCE = new OrmXmlJpaFileContentProvider();

    public static IJpaFileContentProvider instance() {
        return INSTANCE;
    }

    private OrmXmlJpaFileContentProvider() {
    }

    public IJpaRootContentNode buildRootContent(IJpaFile jpaFile) {
        IFile resourceFile = jpaFile.getFile();
        OrmArtifactEdit oae = OrmArtifactEdit.getArtifactEditForRead(resourceFile.getProject());
        OrmResource resource = oae.getOrmResource(resourceFile);
        oae.addListener(this.buildReloadListener(resource));
        XmlRootContentNode root = OrmFactory.eINSTANCE.createXmlRootContentNode();
        root.setArtifactEdit(oae);
        root.setEntityMappings(resource.getEntityMappings());
        resource.eAdapters().add((Object)this.buildRootNodeListener(resourceFile, root));
        jpaFile.setContent(root);
        return root;
    }

    private Adapter buildRootNodeListener(IFile resourceFile, XmlRootContentNode root) {
        return new RootAdapter(resourceFile, root);
    }

    private EditModelListener buildReloadListener(OrmResource resource) {
        return new ReloadListener(resource);
    }

    public String contentType() {
        return "org.eclipse.jpt.core.content.orm";
    }

    private class ReloadListener
    implements EditModelListener {
        final OrmResource resource;

        ReloadListener(OrmResource resource) {
            this.resource = resource;
        }

        public void editModelChanged(EditModelEvent anEvent) {
            switch (anEvent.getEventCode()) {
                case 7: {
                    if (!anEvent.getChangedResources().contains(this.resource) || this.resource.isLoaded()) break;
                    try {
                        this.resource.load(this.resource.getResourceSet().getLoadOptions());
                    }
                    catch (IOException ioe) {
                        JptCorePlugin.log(ioe);
                    }
                    break;
                }
                case 3: {
                    if (!anEvent.getChangedResources().contains(this.resource)) break;
                    anEvent.getEditModel().removeListener((EditModelListener)this);
                }
            }
        }
    }

    private class RootAdapter
    extends AdapterImpl {
        final IFile resourceFile;
        final XmlRootContentNode rootContentNode;

        RootAdapter(IFile resourceFile, XmlRootContentNode rootContentNode) {
            this.resourceFile = resourceFile;
            this.rootContentNode = rootContentNode;
        }

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(Resource.class);
            if (featureId == 2 && (notification.getEventType() == 3 || notification.getEventType() == 4)) {
                OrmResource resource = (OrmResource)notification.getNotifier();
                this.rootContentNode.setEntityMappings(resource.getEntityMappings());
            }
        }
    }
}

