/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jpt.core.internal.content.orm.AbstractXmlTable;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmPackage;
import org.eclipse.jpt.core.internal.content.orm.XmlJoinColumn;
import org.eclipse.jpt.core.internal.content.orm.XmlMultiRelationshipMappingInternal;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlJoinTable
extends AbstractXmlTable
implements IJoinTable {
    protected EList<IJoinColumn> specifiedJoinColumns;
    protected EList<IJoinColumn> defaultJoinColumns;
    protected EList<IJoinColumn> specifiedInverseJoinColumns;
    protected EList<IJoinColumn> defaultInverseJoinColumns;

    protected XmlJoinTable() {
        throw new UnsupportedOperationException();
    }

    protected XmlJoinTable(ITable.Owner owner) {
        super(owner);
        this.getDefaultJoinColumns().add((Object)this.createJoinColumn(new IJoinTable.JoinColumnOwner(this)));
        this.getDefaultInverseJoinColumns().add((Object)this.createJoinColumn(new IJoinTable.InverseJoinColumnOwner(this)));
        this.eAdapters().add((Object)this.buildListener());
    }

    @Override
    protected void addInsignificantXmlFeatureIdsTo(Set<Integer> insignificantXmlFeatureIds) {
        super.addInsignificantXmlFeatureIdsTo(insignificantXmlFeatureIds);
        insignificantXmlFeatureIds.add(12);
        insignificantXmlFeatureIds.add(15);
        insignificantXmlFeatureIds.add(10);
        insignificantXmlFeatureIds.add(13);
    }

    private IJoinColumn createJoinColumn(IJoinColumn.Owner owner) {
        return OrmFactory.eINSTANCE.createXmlJoinColumn(owner);
    }

    private Adapter buildListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                XmlJoinTable.this.notifyChanged(notification);
            }
        };
    }

    void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(IJoinTable.class)) {
            case 12: {
                this.defaultJoinColumnsChanged(notification);
                break;
            }
            case 15: {
                this.defaultInverseJoinColumnsChanged(notification);
                break;
            }
        }
    }

    void defaultJoinColumnsChanged(Notification notification) {
        throw new IllegalStateException("'defaultJoinColumns' cannot be changed");
    }

    void defaultInverseJoinColumnsChanged(Notification notification) {
        throw new IllegalStateException("'defaultInverseJoinColumns' cannot be changed");
    }

    @Override
    protected EClass eStaticClass() {
        return OrmPackage.Literals.XML_JOIN_TABLE;
    }

    @Override
    public EList<IJoinColumn> getJoinColumns() {
        return this.getSpecifiedJoinColumns().isEmpty() ? this.getDefaultJoinColumns() : this.getSpecifiedJoinColumns();
    }

    @Override
    public EList<IJoinColumn> getSpecifiedJoinColumns() {
        if (this.specifiedJoinColumns == null) {
            this.specifiedJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 14);
        }
        return this.specifiedJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getDefaultJoinColumns() {
        if (this.defaultJoinColumns == null) {
            this.defaultJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 15);
        }
        return this.defaultJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumns().isEmpty() ? this.getDefaultInverseJoinColumns() : this.getSpecifiedInverseJoinColumns();
    }

    @Override
    public EList<IJoinColumn> getSpecifiedInverseJoinColumns() {
        if (this.specifiedInverseJoinColumns == null) {
            this.specifiedInverseJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 17);
        }
        return this.specifiedInverseJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getDefaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumns == null) {
            this.defaultInverseJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 18);
        }
        return this.defaultInverseJoinColumns;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return ((InternalEList)this.getJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getSpecifiedJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getDefaultJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getInverseJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getSpecifiedInverseJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 18: {
                return ((InternalEList)this.getDefaultInverseJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                return this.getJoinColumns();
            }
            case 14: {
                return this.getSpecifiedJoinColumns();
            }
            case 15: {
                return this.getDefaultJoinColumns();
            }
            case 16: {
                return this.getInverseJoinColumns();
            }
            case 17: {
                return this.getSpecifiedInverseJoinColumns();
            }
            case 18: {
                return this.getDefaultInverseJoinColumns();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 14: {
                this.getSpecifiedJoinColumns().clear();
                this.getSpecifiedJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getDefaultJoinColumns().clear();
                this.getDefaultJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getSpecifiedInverseJoinColumns().clear();
                this.getSpecifiedInverseJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.getDefaultInverseJoinColumns().clear();
                this.getDefaultInverseJoinColumns().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 14: {
                this.getSpecifiedJoinColumns().clear();
                return;
            }
            case 15: {
                this.getDefaultJoinColumns().clear();
                return;
            }
            case 17: {
                this.getSpecifiedInverseJoinColumns().clear();
                return;
            }
            case 18: {
                this.getDefaultInverseJoinColumns().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return !this.getJoinColumns().isEmpty();
            }
            case 14: {
                return this.specifiedJoinColumns != null && !this.specifiedJoinColumns.isEmpty();
            }
            case 15: {
                return this.defaultJoinColumns != null && !this.defaultJoinColumns.isEmpty();
            }
            case 16: {
                return !this.getInverseJoinColumns().isEmpty();
            }
            case 17: {
                return this.specifiedInverseJoinColumns != null && !this.specifiedInverseJoinColumns.isEmpty();
            }
            case 18: {
                return this.defaultInverseJoinColumns != null && !this.defaultInverseJoinColumns.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IJoinTable.class) {
            switch (derivedFeatureID) {
                case 13: {
                    return 10;
                }
                case 14: {
                    return 11;
                }
                case 15: {
                    return 12;
                }
                case 16: {
                    return 13;
                }
                case 17: {
                    return 14;
                }
                case 18: {
                    return 15;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IJoinTable.class) {
            switch (baseFeatureID) {
                case 10: {
                    return 13;
                }
                case 11: {
                    return 14;
                }
                case 12: {
                    return 15;
                }
                case 13: {
                    return 16;
                }
                case 14: {
                    return 17;
                }
                case 15: {
                    return 18;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    private XmlMultiRelationshipMappingInternal getMultiRelationshipMapping() {
        return (XmlMultiRelationshipMappingInternal)this.eContainer();
    }

    @Override
    protected void makeTableForXmlNonNull() {
        this.getMultiRelationshipMapping().makeJoinTableForXmlNonNull();
    }

    @Override
    protected void makeTableForXmlNull() {
        this.getMultiRelationshipMapping().makeJoinTableForXmlNull();
    }

    @Override
    public IJoinColumn createJoinColumn(int index) {
        return this.createXmlJoinColumn(index);
    }

    private XmlJoinColumn createXmlJoinColumn(int index) {
        return OrmFactory.eINSTANCE.createXmlJoinColumn(new IJoinTable.JoinColumnOwner(this));
    }

    @Override
    public IJoinColumn createInverseJoinColumn(int index) {
        return this.createXmlInverseJoinColumn(index);
    }

    private XmlJoinColumn createXmlInverseJoinColumn(int index) {
        return OrmFactory.eINSTANCE.createXmlJoinColumn(new IJoinTable.InverseJoinColumnOwner(this));
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.getSpecifiedJoinColumns().isEmpty();
    }

    @Override
    public boolean containsSpecifiedInverseJoinColumns() {
        return !this.getSpecifiedInverseJoinColumns().isEmpty();
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.setDefaultName((String)defaultsContext.getDefault("joinTable.name"));
    }

    public boolean isSpecified() {
        return this.node != null;
    }

    @Override
    public IRelationshipMapping relationshipMapping() {
        return (IRelationshipMapping)this.eContainer();
    }
}

