/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.XmlEObject;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.orm.EntityMappings;
import org.eclipse.jpt.core.internal.content.orm.IXmlAttributeMappingProvider;
import org.eclipse.jpt.core.internal.content.orm.IXmlTypeMappingProvider;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmPackage;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlEmbeddableProvider;
import org.eclipse.jpt.core.internal.content.orm.XmlEntityProvider;
import org.eclipse.jpt.core.internal.content.orm.XmlMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentAttribute;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPersistentType
extends XmlEObject
implements IPersistentType {
    protected static final String MAPPING_KEY_EDEFAULT = null;
    protected String mappingKey = MAPPING_KEY_EDEFAULT;
    protected static final String CLASS_EDEFAULT = null;
    protected String class_ = CLASS_EDEFAULT;
    protected EList<XmlAttributeMapping> specifiedAttributeMappings;
    protected EList<XmlAttributeMapping> virtualAttributeMappings;
    protected EList<XmlPersistentAttribute> specifiedPersistentAttributes;
    protected EList<XmlPersistentAttribute> virtualPersistentAttributes;
    private Collection<IXmlTypeMappingProvider> typeMappingProviders = this.buildTypeMappingProviders();
    private IPersistentType parentPersistentType;

    protected XmlPersistentType() {
    }

    protected XmlPersistentType(String theMappingKey) {
        this();
        this.mappingKey = theMappingKey;
    }

    @Override
    protected void addInsignificantFeatureIdsTo(Set<Integer> insignificantFeatureIds) {
        super.addInsignificantFeatureIdsTo(insignificantFeatureIds);
        insignificantFeatureIds.add(2);
        insignificantFeatureIds.add(5);
        insignificantFeatureIds.add(6);
        insignificantFeatureIds.add(7);
    }

    protected Collection<IXmlTypeMappingProvider> buildTypeMappingProviders() {
        ArrayList<IXmlTypeMappingProvider> collection = new ArrayList<IXmlTypeMappingProvider>();
        collection.add(new XmlEntityProvider());
        collection.add(new XmlMappedSuperclassProvider());
        collection.add(new XmlEmbeddableProvider());
        return collection;
    }

    @Override
    protected EClass eStaticClass() {
        return OrmPackage.Literals.XML_PERSISTENT_TYPE;
    }

    @Override
    public XmlTypeMapping getMapping() {
        return (XmlTypeMapping)this.eContainer();
    }

    @Override
    public Object getId() {
        return "org.eclipse.jpt.core.xml.persistentType";
    }

    @Override
    public String getMappingKey() {
        return this.mappingKey;
    }

    public void setMappingKeyGen(String newMappingKey) {
        String oldMappingKey = this.mappingKey;
        this.mappingKey = newMappingKey;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldMappingKey, (Object)this.mappingKey));
        }
    }

    @Override
    public void setMappingKey(String newMappingKey) {
        if (this.mappingKey.equals(newMappingKey)) {
            return;
        }
        XmlTypeMapping oldMapping = this.getMapping();
        EntityMappings entityMappings = oldMapping.getEntityMappings();
        entityMappings.changeMapping(oldMapping, newMappingKey);
        this.setMappingKeyGen(newMappingKey);
    }

    public String getClass_() {
        return this.class_;
    }

    public void setClass(String newClass) {
        String oldClass = this.class_;
        this.class_ = newClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldClass, (Object)this.class_));
        }
    }

    public EList<XmlAttributeMapping> getAttributeMappings() {
        EObjectEList list = new EObjectEList(XmlAttributeMapping.class, (InternalEObject)this, 2);
        list.addAll(this.getSpecifiedAttributeMappings());
        list.addAll(this.getVirtualAttributeMappings());
        return list;
    }

    public EList<XmlAttributeMapping> getSpecifiedAttributeMappingsGen() {
        if (this.specifiedAttributeMappings == null) {
            this.specifiedAttributeMappings = new EObjectContainmentEList(XmlAttributeMapping.class, (InternalEObject)this, 3);
        }
        return this.specifiedAttributeMappings;
    }

    public EList<XmlAttributeMapping> getSpecifiedAttributeMappings() {
        if (this.specifiedAttributeMappings == null) {
            this.specifiedAttributeMappings = new SpecifiedAttributeMappingsList();
        }
        return this.getSpecifiedAttributeMappingsGen();
    }

    public EList<XmlAttributeMapping> getVirtualAttributeMappingsGen() {
        if (this.virtualAttributeMappings == null) {
            this.virtualAttributeMappings = new EObjectContainmentEList(XmlAttributeMapping.class, (InternalEObject)this, 4);
        }
        return this.virtualAttributeMappings;
    }

    public EList<XmlAttributeMapping> getVirtualAttributeMappings() {
        if (this.virtualAttributeMappings == null) {
            this.virtualAttributeMappings = new VirtualAttributeMappingsList();
        }
        return this.getVirtualAttributeMappingsGen();
    }

    public EList<XmlPersistentAttribute> getPersistentAttributes() {
        EObjectEList list = new EObjectEList(XmlPersistentAttribute.class, (InternalEObject)this, 5);
        list.addAll(this.getSpecifiedPersistentAttributes());
        list.addAll(this.getVirtualPersistentAttributes());
        return list;
    }

    public EList<XmlPersistentAttribute> getSpecifiedPersistentAttributes() {
        if (this.specifiedPersistentAttributes == null) {
            this.specifiedPersistentAttributes = new EObjectEList(XmlPersistentAttribute.class, (InternalEObject)this, 6);
        }
        return this.specifiedPersistentAttributes;
    }

    public EList<XmlPersistentAttribute> getVirtualPersistentAttributes() {
        if (this.virtualPersistentAttributes == null) {
            this.virtualPersistentAttributes = new EObjectEList(XmlPersistentAttribute.class, (InternalEObject)this, 7);
        }
        return this.virtualPersistentAttributes;
    }

    protected void changeMapping(XmlAttributeMapping oldMapping, String newMappingKey) {
        boolean virtual = oldMapping.isVirtual();
        XmlAttributeMapping newAttributeMapping = this.buildAttributeMapping(oldMapping.getPersistentAttribute().attributeMappingProviders(), newMappingKey);
        XmlPersistentAttribute nullAttribute = OrmFactory.eINSTANCE.createXmlPersistentAttribute();
        XmlPersistentAttribute attribute = oldMapping.getPersistentAttribute();
        oldMapping.setPersistentAttribute(nullAttribute);
        if (virtual) {
            this.getVirtualPersistentAttributes().remove((Object)attribute);
            this.getVirtualAttributeMappings().remove((Object)oldMapping);
        } else {
            this.getSpecifiedPersistentAttributes().remove((Object)attribute);
            this.getSpecifiedAttributeMappings().remove((Object)oldMapping);
        }
        newAttributeMapping.setPersistentAttribute(attribute);
        oldMapping.initializeOn(newAttributeMapping);
        if (virtual) {
            this.insertAttributeMapping(newAttributeMapping, (List<XmlAttributeMapping>)this.getVirtualAttributeMappings());
        } else {
            this.insertAttributeMapping(newAttributeMapping, (List<XmlAttributeMapping>)this.getSpecifiedAttributeMappings());
        }
    }

    private XmlAttributeMapping buildAttributeMapping(Collection<IXmlAttributeMappingProvider> providers, String key) {
        for (IXmlAttributeMappingProvider provider : providers) {
            if (!provider.key().equals(key)) continue;
            return provider.buildAttributeMapping();
        }
        return OrmFactory.eINSTANCE.createXmlNullAttributeMapping();
    }

    public Collection<IXmlTypeMappingProvider> typeMappingProviders() {
        return this.typeMappingProviders;
    }

    protected void setMappingVirtual(XmlAttributeMapping attributeMapping, boolean virtual) {
        boolean oldVirtual = attributeMapping.isVirtual();
        if (oldVirtual == virtual) {
            return;
        }
        if (virtual) {
            this.getSpecifiedAttributeMappings().remove((Object)attributeMapping);
            this.insertAttributeMapping(attributeMapping, (List<XmlAttributeMapping>)this.getVirtualAttributeMappings());
        } else {
            this.getVirtualAttributeMappings().remove((Object)attributeMapping);
            this.insertAttributeMapping(attributeMapping, (List<XmlAttributeMapping>)this.getSpecifiedAttributeMappings());
        }
    }

    private void insertAttributeMapping(XmlAttributeMapping newMapping, List<XmlAttributeMapping> attributeMappings) {
        int newIndex = CollectionTools.insertionIndexOf(attributeMappings, (Object)newMapping, this.buildMappingComparator());
        attributeMappings.add(newIndex, newMapping);
    }

    private Comparator<XmlAttributeMapping> buildMappingComparator() {
        return new Comparator<XmlAttributeMapping>(){

            @Override
            public int compare(XmlAttributeMapping o1, XmlAttributeMapping o2) {
                int o2Sequence;
                int o1Sequence = o1.xmlSequence();
                if (o1Sequence < (o2Sequence = o2.xmlSequence())) {
                    return -1;
                }
                if (o1Sequence == o2Sequence) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getAttributeMappings()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getSpecifiedAttributeMappings()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getVirtualAttributeMappings()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getMappingKey();
            }
            case 1: {
                return this.getClass_();
            }
            case 2: {
                return this.getAttributeMappings();
            }
            case 3: {
                return this.getSpecifiedAttributeMappings();
            }
            case 4: {
                return this.getVirtualAttributeMappings();
            }
            case 5: {
                return this.getPersistentAttributes();
            }
            case 6: {
                return this.getSpecifiedPersistentAttributes();
            }
            case 7: {
                return this.getVirtualPersistentAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMappingKey((String)newValue);
                return;
            }
            case 1: {
                this.setClass((String)newValue);
                return;
            }
            case 3: {
                this.getSpecifiedAttributeMappings().clear();
                this.getSpecifiedAttributeMappings().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getVirtualAttributeMappings().clear();
                this.getVirtualAttributeMappings().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getSpecifiedPersistentAttributes().clear();
                this.getSpecifiedPersistentAttributes().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getVirtualPersistentAttributes().clear();
                this.getVirtualPersistentAttributes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMappingKey(MAPPING_KEY_EDEFAULT);
                return;
            }
            case 1: {
                this.setClass(CLASS_EDEFAULT);
                return;
            }
            case 3: {
                this.getSpecifiedAttributeMappings().clear();
                return;
            }
            case 4: {
                this.getVirtualAttributeMappings().clear();
                return;
            }
            case 6: {
                this.getSpecifiedPersistentAttributes().clear();
                return;
            }
            case 7: {
                this.getVirtualPersistentAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return MAPPING_KEY_EDEFAULT == null ? this.mappingKey != null : !MAPPING_KEY_EDEFAULT.equals(this.mappingKey);
            }
            case 1: {
                return CLASS_EDEFAULT == null ? this.class_ != null : !CLASS_EDEFAULT.equals(this.class_);
            }
            case 2: {
                return !this.getAttributeMappings().isEmpty();
            }
            case 3: {
                return this.specifiedAttributeMappings != null && !this.specifiedAttributeMappings.isEmpty();
            }
            case 4: {
                return this.virtualAttributeMappings != null && !this.virtualAttributeMappings.isEmpty();
            }
            case 5: {
                return !this.getPersistentAttributes().isEmpty();
            }
            case 6: {
                return this.specifiedPersistentAttributes != null && !this.specifiedPersistentAttributes.isEmpty();
            }
            case 7: {
                return this.virtualPersistentAttributes != null && !this.virtualPersistentAttributes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IJpaContentNode.class) {
            return -1;
        }
        if (baseClass == IPersistentType.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IJpaContentNode.class) {
            return -1;
        }
        if (baseClass == IPersistentType.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingKey: ");
        result.append(this.mappingKey);
        result.append(", class: ");
        result.append(this.class_);
        result.append(')');
        return result.toString();
    }

    @Override
    public IType findJdtType() {
        String fqName = this.getClass_();
        if (StringTools.stringIsEmpty((String)fqName)) {
            return null;
        }
        IType type = this.resolveJdtType(fqName);
        if (type == null) {
            fqName = String.valueOf(this.getMapping().getEntityMappings().getPackage()) + "." + this.getClass_();
            type = this.resolveJdtType(fqName);
        }
        return type;
    }

    private IType resolveJdtType(String fullyQualifiedName) {
        String[] name = new String[]{fullyQualifiedName, ""};
        while (name[0].length() != 0) {
            IType type = JDTTools.findType((name = this.moveDot(name))[0], name[1], this.getJpaProject().javaProject());
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private String[] moveDot(String[] packageAndClassName) {
        String segmentToMove;
        if (packageAndClassName[0].length() == 0) {
            throw new IllegalArgumentException();
        }
        String packageName = packageAndClassName[0];
        String className = packageAndClassName[1];
        if (packageName.indexOf(46) == -1) {
            segmentToMove = packageName;
            packageAndClassName[0] = "";
        } else {
            int dotIndex = packageName.lastIndexOf(46);
            segmentToMove = packageName.substring(dotIndex + 1, packageName.length());
            packageAndClassName[0] = packageName.substring(0, dotIndex);
        }
        packageAndClassName[1] = className.length() == 0 ? segmentToMove : String.valueOf(segmentToMove) + '.' + className;
        return packageAndClassName;
    }

    public JavaPersistentType findJavaPersistentType() {
        return this.getJpaProject().javaPersistentType(this.findJdtType());
    }

    public Type findType() {
        JavaPersistentType javaPersistentType = this.findJavaPersistentType();
        return javaPersistentType == null ? null : javaPersistentType.getType();
    }

    public Iterator<XmlPersistentAttribute> attributes() {
        return new ReadOnlyIterator(this.getPersistentAttributes());
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    private Iterator<String> attributeNames(Iterator<? extends IPersistentAttribute> attrs) {
        return new TransformationIterator<IPersistentAttribute, String>(attrs){

            protected String transform(IPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public Iterator<IPersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<IPersistentType, Iterator<IPersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<IPersistentAttribute> transform(IPersistentType pt) {
                return pt.attributes();
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<IPersistentType> inheritanceHierarchy() {
        return new ChainIterator<IPersistentType>((IPersistentType)this){

            protected IPersistentType nextLink(IPersistentType pt) {
                return pt.parentPersistentType();
            }
        };
    }

    @Override
    public IPersistentType parentPersistentType() {
        return this.parentPersistentType;
    }

    public IJpaContentNode getContentNode(int offset) {
        for (XmlAttributeMapping mapping : this.getSpecifiedAttributeMappings()) {
            if (!mapping.getNode().contains(offset)) continue;
            return mapping.getContentNode(offset);
        }
        return this;
    }

    public void refreshDefaults(DefaultsContext context) {
        this.refreshParentPersistentType(context);
    }

    private void refreshParentPersistentType(DefaultsContext context) {
        IPersistentType parentPersistentType;
        JavaPersistentType javaPersistentType = this.findJavaPersistentType();
        if (javaPersistentType == null) {
            this.parentPersistentType = null;
            return;
        }
        ITypeBinding typeBinding = javaPersistentType.getType().typeBinding(javaPersistentType.getType().astRoot());
        this.parentPersistentType = parentPersistentType = JavaPersistentType.parentPersistentType(context, typeBinding);
    }

    protected Iterator<XmlPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<XmlPersistentAttribute>(this.getPersistentAttributes().iterator()){

            protected boolean accept(Object o) {
                return attributeName.equals(((XmlPersistentAttribute)o).getName());
            }
        };
    }

    @Override
    public XmlPersistentAttribute attributeNamed(String attributeName) {
        Iterator<XmlPersistentAttribute> attributes = this.attributesNamed(attributeName);
        return attributes.hasNext() ? attributes.next() : null;
    }

    @Override
    public IPersistentAttribute resolveAttribute(String attributeName) {
        Iterator<XmlPersistentAttribute> attributes = this.attributesNamed(attributeName);
        if (attributes.hasNext()) {
            XmlPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        if (this.parentPersistentType() != null) {
            return this.parentPersistentType().resolveAttribute(attributeName);
        }
        return null;
    }

    @Override
    public ITextRange validationTextRange() {
        return this.selectionTextRange();
    }

    @Override
    public ITextRange selectionTextRange() {
        return this.getMapping().selectionTextRange();
    }

    public ITextRange classTextRange() {
        return this.getMapping().classTextRange();
    }

    public ITextRange attributesTextRange() {
        return this.getMapping().attributesTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AttributeMappingsList<E>
    extends EObjectContainmentEList<XmlAttributeMapping> {
        AttributeMappingsList(int feature) {
            super(XmlAttributeMapping.class, (InternalEObject)XmlPersistentType.this, feature);
        }

        protected abstract EList<XmlPersistentAttribute> persistentAttributes();

        protected void didAdd(int index, XmlAttributeMapping newObject) {
            if (newObject.getPersistentAttribute() == null) {
                throw new IllegalStateException("Must set the PersistentAttribute during creation");
            }
            this.persistentAttributes().add(index, (Object)newObject.getPersistentAttribute());
        }

        protected void didChange() {
            super.didChange();
        }

        protected void didClear(int len, Object[] oldObjects) {
            this.persistentAttributes().clear();
        }

        protected void didMove(int index, XmlAttributeMapping movedObject, int oldIndex) {
            this.persistentAttributes().move(index, (Object)movedObject.getPersistentAttribute());
        }

        protected void didRemove(int index, XmlAttributeMapping oldObject) {
            this.persistentAttributes().remove((Object)oldObject.getPersistentAttribute());
        }

        protected void didSet(int index, XmlAttributeMapping newObject, XmlAttributeMapping oldObject) {
            this.persistentAttributes().set(index, (Object)newObject.getPersistentAttribute());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpecifiedAttributeMappingsList<E>
    extends AttributeMappingsList<XmlAttributeMapping> {
        SpecifiedAttributeMappingsList() {
            super(3);
        }

        @Override
        protected EList<XmlPersistentAttribute> persistentAttributes() {
            return XmlPersistentType.this.getSpecifiedPersistentAttributes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VirtualAttributeMappingsList<E>
    extends AttributeMappingsList<XmlAttributeMapping> {
        VirtualAttributeMappingsList() {
            super(4);
        }

        @Override
        protected EList<XmlPersistentAttribute> persistentAttributes() {
            return XmlPersistentType.this.getVirtualPersistentAttributes();
        }
    }
}

