/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jpt.core.internal.content.orm.OrmPackage;
import org.eclipse.jpt.core.internal.content.orm.resource.EmbeddableTranslator;
import org.eclipse.jpt.core.internal.content.orm.resource.EntityTranslator;
import org.eclipse.jpt.core.internal.content.orm.resource.MappedSuperclassTranslator;
import org.eclipse.jpt.core.internal.content.orm.resource.OrmXmlMapper;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.wst.common.internal.emf.resource.MultiObjectTranslator;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class TypeMappingsTranslator
extends MultiObjectTranslator
implements OrmXmlMapper {
    public static final String ENTITY_MAPPINGS_PATH = "mapped-superclass,entity,embeddable";
    private static final OrmPackage JPA_CORE_XML_PKG = OrmPackage.eINSTANCE;
    private Map<EObject, Translator> translatorMap = new HashMap<EObject, Translator>();

    public TypeMappingsTranslator() {
        super(ENTITY_MAPPINGS_PATH, (EStructuralFeature)JPA_CORE_XML_PKG.getEntityMappingsInternal_TypeMappings());
    }

    public EObject createEMFObject(String nodeName, String readAheadName) {
        Translator translator = this.getDelegateFor(nodeName, readAheadName);
        EObject eObject = translator.createEMFObject(nodeName, readAheadName);
        this.translatorMap.put(eObject, translator);
        return eObject;
    }

    public Translator getDelegateFor(EObject o) {
        Translator translator = this.translatorMap.get(o);
        if (translator != null) {
            return translator;
        }
        switch (o.eClass().getClassifierID()) {
            case 7: {
                translator = new EntityTranslator();
                ((EntityTranslator)translator).setEntity((IEntity)o);
                break;
            }
            case 6: {
                translator = new MappedSuperclassTranslator();
                break;
            }
            case 10: {
                translator = new EmbeddableTranslator();
            }
        }
        if (translator != null) {
            this.translatorMap.put(o, translator);
        }
        return translator;
    }

    public Translator getDelegateFor(String domName, String readAheadName) {
        if (domName.equals("entity")) {
            return new EntityTranslator();
        }
        if (domName.equals("mapped-superclass")) {
            return new MappedSuperclassTranslator();
        }
        if (domName.equals("embeddable")) {
            return new EmbeddableTranslator();
        }
        throw new IllegalStateException("Illegal dom name: " + domName);
    }

    public boolean isDependencyParent() {
        return true;
    }

    public EStructuralFeature getDependencyFeature() {
        return JPA_CORE_XML_PKG.getXmlTypeMapping_PersistentType();
    }

    public EObject basicGetDependencyObject(EObject parent) {
        Translator delegate = this.getDelegateFor(parent);
        if (delegate != null) {
            return delegate.basicGetDependencyObject(parent);
        }
        return super.basicGetDependencyObject(parent);
    }
}

