/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.persistence;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceArtifactEdit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class PersistenceXmlJpaFileContentProvider
implements IJpaFileContentProvider {
    private static final PersistenceXmlJpaFileContentProvider INSTANCE = new PersistenceXmlJpaFileContentProvider();

    public static IJpaFileContentProvider instance() {
        return INSTANCE;
    }

    private PersistenceXmlJpaFileContentProvider() {
    }

    public IJpaRootContentNode buildRootContent(IJpaFile jpaFile) {
        IFile resourceFile = jpaFile.getFile();
        PersistenceArtifactEdit pae = PersistenceArtifactEdit.getArtifactEditForRead(resourceFile.getProject());
        PersistenceResource resource = pae.getPersistenceResource(resourceFile);
        pae.addListener(this.buildReloadListener(resource));
        PersistenceXmlRootContentNode root = PersistenceFactory.eINSTANCE.createPersistenceXmlRootContentNode();
        root.setArtifactEdit(pae);
        root.setPersistence(resource.getPersistence());
        resource.eAdapters().add((Object)this.buildRootNodeListener(resourceFile, root));
        jpaFile.setContent(root);
        return root;
    }

    private Adapter buildRootNodeListener(IFile resourceFile, PersistenceXmlRootContentNode rootContentNode) {
        return new RootAdapter(resourceFile, rootContentNode);
    }

    private EditModelListener buildReloadListener(PersistenceResource resource) {
        return new ReloadListener(resource);
    }

    public String contentType() {
        return "org.eclipse.jpt.core.content.persistence";
    }

    private class ReloadListener
    implements EditModelListener {
        final PersistenceResource resource;

        ReloadListener(PersistenceResource resource) {
            this.resource = resource;
        }

        public void editModelChanged(EditModelEvent anEvent) {
            switch (anEvent.getEventCode()) {
                case 7: {
                    if (!anEvent.getChangedResources().contains((Object)this.resource) || this.resource.isLoaded()) break;
                    try {
                        this.resource.load(this.resource.getResourceSet().getLoadOptions());
                    }
                    catch (IOException ioe) {
                        JptCorePlugin.log(ioe);
                    }
                    break;
                }
                case 3: {
                    if (!anEvent.getChangedResources().contains((Object)this.resource)) break;
                    anEvent.getEditModel().removeListener((EditModelListener)this);
                }
            }
        }
    }

    private class RootAdapter
    extends AdapterImpl {
        final IFile resourceFile;
        final PersistenceXmlRootContentNode rootContentNode;

        RootAdapter(IFile resourceFile, PersistenceXmlRootContentNode rootContentNode) {
            this.resourceFile = resourceFile;
            this.rootContentNode = rootContentNode;
        }

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(Resource.class);
            if (featureId == 2 && (notification.getEventType() == 3 || notification.getEventType() == 4)) {
                PersistenceResource resource = (PersistenceResource)((Object)notification.getNotifier());
                this.rootContentNode.setPersistence(resource.getPersistence());
            }
        }
    }
}

