/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaFacetDataModelProvider
extends FacetInstallDataModelProvider
implements IJpaFacetDataModelProperties {
    private static final String EJB_FACET_ID = "jst.ejb";
    private static final String RUNTIME_NONE = WTPCommonPlugin.getResourceString((String)"44", null);
    private static final IStatus PLATFORM_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_NOT_SPECIFIED);
    private static final IStatus CONNECTION_NOT_CONNECTED_STATUS = JpaFacetDataModelProvider.buildInfoStatus(JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED);
    private static final IStatus RUNTIME_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildWarningStatus(JptCoreMessages.VALIDATE_RUNTIME_NOT_SPECIFIED);
    private static final IStatus RUNTIME_DOES_NOT_SUPPORT_EJB_30_STATUS = JpaFacetDataModelProvider.buildWarningStatus(JptCoreMessages.VALIDATE_RUNTIME_DOES_NOT_SUPPORT_EJB_30);
    private static final IStatus LIBRARY_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildWarningStatus(JptCoreMessages.VALIDATE_LIBRARY_NOT_SPECIFIED);

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJpaFacetDataModelProperties.PLATFORM_ID");
        propertyNames.add("IJpaFacetDataModelProperties.CONNECTION");
        propertyNames.add("IJpaFacetDataModelProperties.RUNTIME");
        propertyNames.add("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
        propertyNames.add("IJpaFacetDataModelProperties.JPA_LIBRARY");
        propertyNames.add("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
        propertyNames.add("IJpaFacetDataModelProperties.CREATE_ORM_XML");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jpt.jpa";
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.PLATFORM_ID")) {
            return "generic";
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.CONNECTION")) {
            return "";
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.RUNTIME")) {
            return null;
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION")) {
            return this.runtimeSupportsEjb30(this.runtime());
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.JPA_LIBRARY")) {
            return JptCorePlugin.instance().getPluginPreferences().getString("defaultJpaLib");
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.runtimeSupportsEjb30(this.runtime());
        }
        if (propertyName.equals("IJpaFacetDataModelProperties.CREATE_ORM_XML")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IJpaFacetDataModelProperties.RUNTIME")) {
            this.model.notifyPropertyChange("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", 2);
            this.model.notifyPropertyChange("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", 2);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IJpaFacetDataModelProperties.JPA_LIBRARY")) {
            String[] libraries = (String[])CollectionTools.sort((Object[])JavaCore.getUserLibraryNames());
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[libraries.length + 1];
            descriptors[0] = new DataModelPropertyDescriptor((Object)"", RUNTIME_NONE);
            int i = 1;
            String[] stringArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                descriptors[i++] = new DataModelPropertyDescriptor((Object)library, library);
                ++n2;
            }
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String name) {
        if (name.equals("IJpaFacetDataModelProperties.PLATFORM_ID")) {
            return this.validatePlatformId(this.getStringProperty(name));
        }
        if (name.equals("IJpaFacetDataModelProperties.CONNECTION")) {
            return this.validateConnectionName(this.getStringProperty(name));
        }
        if (name.equals("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION")) {
            return this.validateJpaLibrary(this.getBooleanProperty(name));
        }
        if (name.equals("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.validatePersistentClassManagement(this.getBooleanProperty(name));
        }
        return super.validate(name);
    }

    private IRuntime runtime() {
        return (IRuntime)this.getProperty("IJpaFacetDataModelProperties.RUNTIME");
    }

    private boolean runtimeSupportsEjb30(IRuntime runtime) {
        IProjectFacetVersion ejb30 = ProjectFacetsManager.getProjectFacet((String)EJB_FACET_ID).getVersion("3.0");
        return runtime == null ? false : runtime.supports(ejb30);
    }

    private IStatus validatePlatformId(String platformId) {
        return StringTools.stringIsEmpty((String)platformId) ? PLATFORM_NOT_SPECIFIED_STATUS : OK_STATUS;
    }

    private IStatus validateConnectionName(String connectionName) {
        return ConnectionProfileRepository.instance().profileNamed(connectionName).isConnected() ? OK_STATUS : CONNECTION_NOT_CONNECTED_STATUS;
    }

    private IStatus validateJpaLibrary(boolean useServerJpaImplementation) {
        if (useServerJpaImplementation) {
            IRuntime runtime = this.runtime();
            if (runtime == null) {
                return RUNTIME_NOT_SPECIFIED_STATUS;
            }
            if (!this.runtimeSupportsEjb30(runtime)) {
                return RUNTIME_DOES_NOT_SUPPORT_EJB_30_STATUS;
            }
        } else if (StringTools.stringIsEmpty((String)this.getStringProperty("IJpaFacetDataModelProperties.JPA_LIBRARY"))) {
            return LIBRARY_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus validatePersistentClassManagement(boolean discoverAnnotatedClasses) {
        return OK_STATUS;
    }

    private static IStatus buildInfoStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(1, message);
    }

    private static IStatus buildWarningStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(2, message);
    }

    private static IStatus buildErrorStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(4, message);
    }

    private static IStatus buildStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.jpt.core", message);
    }
}

