/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaFacetInstallDelegate
implements IDelegate,
IJpaFacetDataModelProperties {
    private static final IClasspathAttribute[] EMPTY_CLASSPATH_ATTRIBUTES = new IClasspathAttribute[0];

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor = this.nonNullMonitor(monitor);
        try {
            this.execute_(project, fv, config, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void execute_(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IDataModel dataModel = (IDataModel)config;
        this.configureClasspath(javaProject, dataModel, monitor);
        JptCorePlugin.setJpaPlatformId(project, dataModel.getStringProperty("IJpaFacetDataModelProperties.PLATFORM_ID"));
        JptCorePlugin.setConnectionProfileName(project, dataModel.getStringProperty("IJpaFacetDataModelProperties.CONNECTION"));
        JptCorePlugin.setDiscoverAnnotatedClasses(project, dataModel.getBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"));
        monitor.worked(1);
    }

    private void configureClasspath(IJavaProject javaProject, IDataModel dataModel, IProgressMonitor monitor) throws CoreException {
        boolean useServerLibrary = dataModel.getBooleanProperty("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
        if (useServerLibrary) {
            return;
        }
        String jpaLibrary = dataModel.getStringProperty("IJpaFacetDataModelProperties.JPA_LIBRARY");
        if (StringTools.stringIsEmpty((String)jpaLibrary)) {
            return;
        }
        IClasspathAttribute[] attributes = this.buildClasspathAttributes(javaProject.getProject());
        IClasspathEntry jpaLibraryEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.USER_LIBRARY/" + jpaLibrary), null, (IClasspathAttribute[])attributes, (boolean)true);
        Object[] classpath = javaProject.getRawClasspath();
        if (CollectionTools.contains((Object[])classpath, (Object)jpaLibraryEntry)) {
            return;
        }
        int len = classpath.length;
        IClasspathEntry[] newClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(classpath, 0, newClasspath, 0, len);
        newClasspath[len] = jpaLibraryEntry;
        javaProject.setRawClasspath(newClasspath, monitor);
    }

    private IClasspathAttribute[] buildClasspathAttributes(IProject project) {
        boolean webApp = JptCorePlugin.projectHasWebFacet(project);
        if (!webApp && this.projectIsStandalone(project)) {
            return EMPTY_CLASSPATH_ATTRIBUTES;
        }
        return new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)webApp).toString())};
    }

    private boolean projectIsStandalone(IProject project) {
        return J2EEProjectUtilities.isStandaloneProject((IProject)project);
    }

    private IProgressMonitor nonNullMonitor(IProgressMonitor monitor) {
        return monitor != null ? monitor : new NullProgressMonitor();
    }
}

