/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jpt.core.internal.jdtutility.AbstractAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.StringTools;

public class MemberIndexedAnnotationAdapter
extends AbstractAnnotationAdapter
implements IndexedAnnotationAdapter {
    private final IndexedDeclarationAnnotationAdapter idaa;

    public MemberIndexedAnnotationAdapter(Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super(member, idaa);
        this.idaa = idaa;
    }

    public int index() {
        return this.idaa.getIndex();
    }

    public void moveAnnotation(int newIndex) {
        this.edit(this.buildMoveAnnotationEditor(newIndex));
    }

    protected Member.Editor buildMoveAnnotationEditor(int newIndex) {
        return new MoveAnnotationEditor(this.idaa, newIndex);
    }

    protected static class MoveAnnotationEditor
    implements Member.Editor {
        private final IndexedDeclarationAnnotationAdapter idaa;
        private int index;

        MoveAnnotationEditor(IndexedDeclarationAnnotationAdapter idaa, int index) {
            this.idaa = idaa;
            this.index = index;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.idaa.moveAnnotation(this.index, declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

