/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.IMappingKeys;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseJpaProjectContext
extends BaseContext {
    private IJpaProject jpaProject;
    private List<IJpaFile> validPersistenceXmlFiles;
    private List<IJpaFile> invalidPersistenceXmlFiles;
    private Collection<PersistenceUnitContext> persistenceUnitContexts;
    private boolean okToContinueValidation = true;
    protected boolean okToProceedForConnectionValidation = true;

    public BaseJpaProjectContext(IJpaProject theJpaProject) {
        super(null);
        this.jpaProject = theJpaProject;
        this.validPersistenceXmlFiles = new ArrayList<IJpaFile>();
        this.invalidPersistenceXmlFiles = new ArrayList<IJpaFile>();
        this.persistenceUnitContexts = new ArrayList<PersistenceUnitContext>();
    }

    @Override
    protected void initialize() {
        this.sortPersistenceXmlFiles();
        this.buildPersistenceUnitContexts();
    }

    private void sortPersistenceXmlFiles() {
        Iterator<IJpaFile> stream = this.persistenceXmlFiles();
        while (stream.hasNext()) {
            IJpaFile jpaFile = stream.next();
            if (this.isValidPersistenceXmlLocation(jpaFile)) {
                this.validPersistenceXmlFiles.add(jpaFile);
                continue;
            }
            this.invalidPersistenceXmlFiles.add(jpaFile);
        }
    }

    private Iterator<IJpaFile> persistenceXmlFiles() {
        return this.jpaProject.jpaFiles("org.eclipse.jpt.core.content.persistence");
    }

    private boolean isValidPersistenceXmlLocation(IJpaFile jpaFile) {
        IFile file = jpaFile.getFile();
        IProject project = this.jpaProject.project();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder rootFolder = component.getRootFolder();
        IVirtualFolder metaInfFolder = rootFolder.getFolder((IPath)new Path(String.valueOf(this.jpaProject.rootDeployLocation()) + '/' + "META-INF"));
        return metaInfFolder.exists() && CollectionTools.contains((Object[])metaInfFolder.getUnderlyingFolders(), (Object)file.getParent());
    }

    protected void buildPersistenceUnitContexts() {
        if (this.validPersistenceXmlFiles.size() == 1) {
            IJpaFile file = this.validPersistenceXmlFiles.get(0);
            this.buildPersistenceUnitContexts(this.getPersistence(file));
        }
    }

    protected void buildPersistenceUnitContexts(Persistence persistence) {
        if (persistence != null) {
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnits()) {
                PersistenceUnitContext persistenceUnitContext = new PersistenceUnitContext(this, persistenceUnit);
                this.persistenceUnitContexts.add(persistenceUnitContext);
            }
        }
    }

    protected Persistence getPersistence(IJpaFile persistenceXmlFile) {
        return ((PersistenceXmlRootContentNode)persistenceXmlFile.getContent()).getPersistence();
    }

    @Override
    public IJpaPlatform getPlatform() {
        return this.jpaProject.jpaPlatform();
    }

    protected Iterator<IJpaFile> validPersistenceXmlFiles() {
        return this.validPersistenceXmlFiles.iterator();
    }

    public void refreshDefaults(IProgressMonitor monitor) {
        this.refreshDefaults(null, monitor);
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults, IProgressMonitor monitor) {
        super.refreshDefaults(parentDefaults, monitor);
        DefaultsContext defaultsContext = this.buildDefaultsContext();
        for (PersistenceUnitContext context : this.persistenceUnitContexts) {
            this.checkCanceled(monitor);
            context.refreshDefaults(defaultsContext, monitor);
        }
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private DefaultsContext buildDefaultsContext() {
        return new DefaultsContext(){

            public Object getDefault(String key) {
                if (key.equals("table.schema") || key.equals("tableGenerator.schema")) {
                    return BaseJpaProjectContext.this.getDefaultSchema();
                }
                if (key.equals("table.catalog")) {
                    return BaseJpaProjectContext.this.getProjectUserCatalog();
                }
                return null;
            }

            public IPersistentType persistentType(String fullyQualifiedTypeName) {
                return null;
            }

            public CompilationUnit astRoot() {
                return null;
            }
        };
    }

    protected ConnectionProfile getProjectConnectionProfile() {
        return this.jpaProject.connectionProfile();
    }

    private String getDefaultSchema() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        return profile.getDefaultSchema();
    }

    private String getProjectUserCatalog() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        return profile.getCatalogName();
    }

    public boolean contains(IPersistentType persistentType) {
        for (PersistenceUnitContext context : this.persistenceUnitContexts) {
            if (!context.contains(persistentType)) continue;
            return true;
        }
        return false;
    }

    private Iterator<PersistenceUnitContext> persistenceUnitContexts() {
        return this.persistenceUnitContexts.iterator();
    }

    int persistenceUnitContextsSize() {
        return this.persistenceUnitContexts.size();
    }

    PersistenceUnitContext persistenceUnitContext(String persistenceUnitName) {
        Iterator<PersistenceUnitContext> stream = this.persistenceUnitContexts();
        while (stream.hasNext()) {
            PersistenceUnitContext puContext = stream.next();
            if (!puContext.persistenceUnit().getName().equals(persistenceUnitName)) continue;
            return puContext;
        }
        return null;
    }

    Iterator<PersistenceUnit> persistenceUnits() {
        return new TransformationIterator<PersistenceUnitContext, PersistenceUnit>(this.persistenceUnitContexts()){

            protected PersistenceUnit transform(PersistenceUnitContext next) {
                return next.persistenceUnit();
            }
        };
    }

    public boolean containsPersistenceUnitNamed(String name) {
        return this.persistenceUnitNamed(name) != null;
    }

    PersistenceUnit persistenceUnitNamed(String name) {
        for (PersistenceUnitContext context : this.persistenceUnitContexts) {
            if (!context.persistenceUnit().getName().equals(name)) continue;
            return context.persistenceUnit();
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addProjectLevelMessages(messages);
        if (this.okToContinueValidation) {
            for (PersistenceUnitContext context : this.persistenceUnitContexts) {
                context.addToMessages(messages);
            }
        }
        this.addOrphanedJavaClassMessages(messages);
    }

    protected void addProjectLevelMessages(List<IMessage> messages) {
        this.addConnectionMessages(messages);
        this.addNoPersistenceXmlMessage(messages);
        this.addMultiplePersistenceXmlMessage(messages);
        this.addInvalidPersistenceXmlContentMessage(messages);
        this.addNoPersistenceUnitMessage(messages);
        this.addMultiplePersistenceUnitMessage(messages);
    }

    protected void addConnectionMessages(List<IMessage> messages) {
        this.addNoConnectionMessage(messages);
        this.addInactiveConnectionMessage(messages);
    }

    protected void addNoConnectionMessage(List<IMessage> messages) {
        if (!this.jpaProject.dataSource().hasAConnection()) {
            messages.add(JpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this.jpaProject));
            this.okToProceedForConnectionValidation = false;
        }
    }

    protected void addInactiveConnectionMessage(List<IMessage> messages) {
        if (this.okToProceedForConnectionValidation && !this.jpaProject.dataSource().isConnected()) {
            messages.add(JpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{this.jpaProject.dataSource().getConnectionProfileName()}, this.jpaProject));
        }
        this.okToProceedForConnectionValidation = true;
    }

    protected void addNoPersistenceXmlMessage(List<IMessage> messages) {
        if (this.validPersistenceXmlFiles.isEmpty()) {
            messages.add(JpaValidationMessages.buildMessage(1, "PROJECT_NO_PERSISTENCE_XML", this.jpaProject));
            this.okToContinueValidation = false;
        }
    }

    protected void addMultiplePersistenceXmlMessage(List<IMessage> messages) {
        if (this.validPersistenceXmlFiles.size() > 1) {
            messages.add(JpaValidationMessages.buildMessage(1, "PROJECT_MULTIPLE_PERSISTENCE_XML", this.jpaProject));
            this.okToContinueValidation = false;
        }
    }

    protected void addInvalidPersistenceXmlContentMessage(List<IMessage> messages) {
        IJpaFile persistenceXmlFile;
        if (this.validPersistenceXmlFiles.size() == 1 && this.getPersistence(persistenceXmlFile = this.validPersistenceXmlFiles.get(0)) == null) {
            PersistenceXmlRootContentNode root = (PersistenceXmlRootContentNode)persistenceXmlFile.getContent();
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_XML_INVALID_CONTENT", root, root.validationTextRange()));
            this.okToContinueValidation = false;
        }
    }

    protected void addNoPersistenceUnitMessage(List<IMessage> messages) {
        if (this.okToContinueValidation && this.persistenceUnitContexts.size() == 0) {
            IJpaFile validPersistenceXml = this.validPersistenceXmlFiles.get(0);
            Persistence persistence = this.getPersistence(validPersistenceXml);
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_NO_PERSISTENCE_UNIT", persistence, persistence.validationTextRange()));
            this.okToContinueValidation = false;
        }
    }

    protected void addMultiplePersistenceUnitMessage(List<IMessage> messages) {
        if (this.okToContinueValidation && this.persistenceUnitContexts.size() > 1) {
            IJpaFile validPersistenceXml = this.validPersistenceXmlFiles.get(0);
            Persistence persistence = this.getPersistence(validPersistenceXml);
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS", persistence, persistence.validationTextRange()));
            this.okToContinueValidation = false;
        }
    }

    protected void addOrphanedJavaClassMessages(List<IMessage> messages) {
        Iterator<JavaPersistentType> stream = this.jpaProject.javaPersistentTypes();
        while (stream.hasNext()) {
            JavaPersistentType jpType = stream.next();
            if (jpType.getMappingKey() == IMappingKeys.NULL_TYPE_MAPPING_KEY || this.contains(jpType)) continue;
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CONTEXT", jpType.getMapping(), jpType.getMapping().validationTextRange()));
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.jpaProject.javaProject().getProject().getName());
    }
}

