/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaPersistentAttributeContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaAttributeContext
extends BaseContext {
    protected IJavaAttributeMapping attributeMapping;

    public JavaAttributeContext(IContext parentContext, IJavaAttributeMapping javaAttributeMapping) {
        super(parentContext);
        this.attributeMapping = javaAttributeMapping;
    }

    @Override
    protected void initialize() {
    }

    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
    }

    protected PersistenceUnitContext persistenceUnitContext() {
        return (PersistenceUnitContext)this.persistentAttributeContext().javaTypeContext().getParentContext();
    }

    protected JavaPersistentAttributeContext persistentAttributeContext() {
        return (JavaPersistentAttributeContext)this.getParentContext();
    }

    protected boolean embeddableOwned() {
        return this.getMapping().typeMapping().getKey() == "embeddable";
    }

    protected boolean entityOwned() {
        return this.getMapping().typeMapping().getKey() == "entity";
    }

    @Override
    public final void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaults(defaultsContext, monitor);
        defaultsContext = this.wrapDefaultsContext(defaultsContext);
        this.refreshDefaultsInternal(defaultsContext, monitor);
    }

    protected void refreshDefaultsInternal(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        this.attributeMapping.refreshDefaults(defaultsContext);
    }

    protected IAttributeMapping getMapping() {
        return this.attributeMapping;
    }

    public final DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                return JavaAttributeContext.this.getDefault(key, this.getWrappedDefaultsContext());
            }
        };
    }

    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("column.name")) {
            return this.getMapping().getPersistentAttribute().getName();
        }
        return defaultsContext.getDefault(key);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addModifierMessages(messages);
        this.addInvalidMappingMessage(messages);
    }

    protected void addModifierMessages(List<IMessage> messages) {
        JavaPersistentAttribute attribute = (JavaPersistentAttribute)this.attributeMapping.getPersistentAttribute();
        if (attribute.getMapping().getKey() != "transient" && attribute.getAttribute().isField()) {
            int flags;
            try {
                flags = attribute.getAttribute().getJdtMember().getFlags();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            if (Flags.isFinal((int)flags)) {
                messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_FINAL_FIELD", new String[]{attribute.getName()}, attribute, attribute.validationTextRange()));
            }
            if (Flags.isPublic((int)flags)) {
                messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", new String[]{attribute.getName()}, attribute, attribute.validationTextRange()));
            }
        }
    }

    protected void addInvalidMappingMessage(List<IMessage> messages) {
        IAttributeMapping attributeMapping = this.getMapping();
        ITypeMapping typeMapping = attributeMapping.typeMapping();
        if (!typeMapping.attributeMappingKeyAllowed(attributeMapping.getKey())) {
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{attributeMapping.getPersistentAttribute().getName()}, attributeMapping, attributeMapping.validationTextRange()));
        }
    }
}

