/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.content.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.platform.AbstractJoinColumnContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnContext
extends AbstractJoinColumnContext<IJoinColumn> {
    private boolean doContinue;

    public JoinColumnContext(IContext parentContext, IJoinColumn column) {
        super(parentContext, column);
    }

    @Override
    protected String buildDefaultName() {
        if (((IJoinColumn)this.getColumn()).getOwner().joinColumns().size() != 1) {
            return null;
        }
        String prefix = ((IJoinColumn)this.getColumn()).getOwner().attributeName();
        if (prefix == null) {
            prefix = this.targetEntityName();
        }
        if (prefix == null) {
            return null;
        }
        String targetColumn = ((IJoinColumn)this.getColumn()).getReferencedColumnName();
        if (targetColumn == null) {
            return null;
        }
        return String.valueOf(prefix) + "_" + targetColumn;
    }

    private String targetEntityName() {
        IEntity targetEntity = ((IJoinColumn)this.getColumn()).getOwner().targetEntity();
        return targetEntity == null ? null : targetEntity.getName();
    }

    @Override
    protected String buildDefaultReferencedColumnName() {
        if (((IJoinColumn)this.getColumn()).getOwner().joinColumns().size() != 1) {
            return null;
        }
        return this.targetPrimaryKeyColumnName();
    }

    private String targetPrimaryKeyColumnName() {
        IEntity targetEntity = ((IJoinColumn)this.getColumn()).getOwner().targetEntity();
        return targetEntity == null ? null : targetEntity.primaryKeyColumnName();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        XmlRelationshipMapping mapping = (XmlRelationshipMapping)((IJoinColumn)this.column).getOwner().getRelationshipMapping();
        this.doContinue = ((IJoinColumn)this.column).isConnected();
        if (this.doContinue && !((IJoinColumn)this.column).isResolved()) {
            if (mapping.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{mapping.getPersistentAttribute().getName(), ((IJoinColumn)this.column).getName()}, this.column, ((IJoinColumn)this.column).nameTextRange()));
            } else {
                messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{((IJoinColumn)this.column).getName()}, this.column, ((IJoinColumn)this.column).nameTextRange()));
            }
        }
    }
}

