/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEntity;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTable;
import org.eclipse.jpt.core.internal.content.orm.XmlEntity;
import org.eclipse.jpt.core.internal.content.orm.XmlTable;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.ISecondaryTable;
import org.eclipse.jpt.core.internal.platform.AssociationOverrideContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.MappingFileContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.platform.SecondaryTableContext;
import org.eclipse.jpt.core.internal.platform.TableContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeOverrideContext;
import org.eclipse.jpt.core.internal.platform.XmlSecondaryTableContext;
import org.eclipse.jpt.core.internal.platform.XmlTypeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEntityContext
extends XmlTypeContext
implements XmlSecondaryTableContext.ParentContext {
    private TableContext tableContext;
    private Collection<XmlSecondaryTableContext> secondaryTableContexts;
    private JavaTable javaTable;
    private Collection<XmlAttributeOverrideContext> attributeOverrideContexts = this.buildAttributeOverrideContexts();
    private Collection<AssociationOverrideContext> associationOverrideContexts = this.buildAssociationOverrideContexts();

    public XmlEntityContext(MappingFileContext parentContext, XmlEntity xmlEntity) {
        super(parentContext, (XmlTypeMapping)((Object)xmlEntity));
        this.secondaryTableContexts = this.buildSecondaryTableContexts();
    }

    protected Collection<XmlAttributeOverrideContext> buildAttributeOverrideContexts() {
        ArrayList<XmlAttributeOverrideContext> contexts = new ArrayList<XmlAttributeOverrideContext>();
        for (IAttributeOverride attributeOverride : this.getEntity().getAttributeOverrides()) {
            contexts.add(new XmlAttributeOverrideContext(this.buildParentContext(), attributeOverride));
        }
        return contexts;
    }

    private XmlAttributeOverrideContext.ParentContext buildParentContext() {
        return new XmlAttributeOverrideContext.ParentContext(){

            @Override
            public void refreshDefaults(DefaultsContext defaults, IProgressMonitor monitor) {
                XmlEntityContext.this.refreshDefaults(defaults, monitor);
            }

            @Override
            public IJpaPlatform getPlatform() {
                return XmlEntityContext.this.getPlatform();
            }

            @Override
            public IContext getParentContext() {
                return XmlEntityContext.this.getParentContext();
            }

            @Override
            public void addToMessages(List<IMessage> messages) {
                XmlEntityContext.this.addToMessages(messages);
            }

            @Override
            public IAttributeOverride javaAttributeOverride(String overrideName) {
                JavaEntity javaEntity = XmlEntityContext.this.getJavaEntity();
                if (javaEntity == null) {
                    return null;
                }
                return javaEntity.attributeOverrideNamed(overrideName);
            }
        };
    }

    protected Collection<AssociationOverrideContext> buildAssociationOverrideContexts() {
        ArrayList<AssociationOverrideContext> contexts = new ArrayList<AssociationOverrideContext>();
        for (IAssociationOverride associationOverride : this.getEntity().getDefaultAssociationOverrides()) {
            contexts.add(new AssociationOverrideContext(this, associationOverride));
        }
        return contexts;
    }

    protected Collection<XmlSecondaryTableContext> buildSecondaryTableContexts() {
        ArrayList<XmlSecondaryTableContext> contexts = new ArrayList<XmlSecondaryTableContext>();
        for (ISecondaryTable secondaryTable : this.getEntity().getSecondaryTables()) {
            contexts.add(new XmlSecondaryTableContext(this, secondaryTable));
        }
        return contexts;
    }

    @Override
    public ISecondaryTable javaSecondaryTable(int index) {
        JavaEntity javaEntity = this.getJavaEntity();
        return javaEntity == null ? null : (ISecondaryTable)javaEntity.getSpecifiedSecondaryTables().get(index);
    }

    protected XmlEntity getEntity() {
        return (XmlEntity)((Object)this.getXmlTypeMapping());
    }

    protected JavaEntity getJavaEntity() {
        IJavaTypeMapping javaTypeMapping = this.javaTypeMapping();
        if (javaTypeMapping != null && javaTypeMapping.getKey() == "entity") {
            return (JavaEntity)javaTypeMapping;
        }
        return null;
    }

    @Override
    public void initialize() {
        super.initialize();
        IJavaTypeMapping javaTypeMapping = this.javaTypeMapping();
        XmlTable xmlTable = (XmlTable)((XmlEntity)((Object)this.getXmlTypeMapping())).getTable();
        if (javaTypeMapping instanceof IEntity) {
            this.javaTable = (JavaTable)((IEntity)((Object)javaTypeMapping)).getTable();
        }
        this.tableContext = new TableContext(this, xmlTable);
    }

    @Override
    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
        if (this.getEntity().getTableGenerator() != null) {
            generatorRepository.addGenerator(this.getEntity().getTableGenerator());
        }
        if (this.getEntity().getSequenceGenerator() != null) {
            generatorRepository.addGenerator(this.getEntity().getSequenceGenerator());
        }
    }

    public PersistenceUnitContext getPersistenceUnitContext() {
        return ((MappingFileContext)this.getParentContext()).getPersistenceUnitContext();
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults, IProgressMonitor monitor) {
        super.refreshDefaults(parentDefaults, monitor);
        DefaultsContext defaultsContext = this.wrapDefaultsContext(parentDefaults);
        this.refreshDefaultAttributeOverrides();
        this.refreshDefaultAssociationOverrides();
        this.refreshDefaultSecondaryTables();
        for (XmlSecondaryTableContext xmlSecondaryTableContext : this.secondaryTableContexts) {
            xmlSecondaryTableContext.refreshDefaults(defaultsContext, monitor);
        }
        for (XmlAttributeOverrideContext xmlAttributeOverrideContext : this.attributeOverrideContexts) {
            xmlAttributeOverrideContext.refreshDefaults(defaultsContext, monitor);
        }
        for (AssociationOverrideContext associationOverrideContext : this.associationOverrideContexts) {
            associationOverrideContext.refreshDefaults(defaultsContext, monitor);
        }
    }

    @Override
    protected void refreshTableContext(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        this.tableContext.refreshDefaults(defaultsContext, monitor);
    }

    protected void refreshDefaultAttributeOverrides() {
        IAttributeOverride defaultAttributeOverride;
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null && !this.getXmlTypeMapping().isXmlMetadataComplete()) {
            for (IAttributeOverride attributeOverride : javaEntity.getAttributeOverrides()) {
                if (this.getEntity().containsAttributeOverride(attributeOverride.getName())) continue;
                defaultAttributeOverride = this.getEntity().createAttributeOverride(0);
                defaultAttributeOverride.setName(attributeOverride.getName());
                this.getEntity().getDefaultAttributeOverrides().add((Object)defaultAttributeOverride);
            }
        } else {
            Iterator<String> i = this.getEntity().allOverridableAttributeNames();
            while (i.hasNext()) {
                String override = i.next();
                if (this.getEntity().containsAttributeOverride(override)) continue;
                defaultAttributeOverride = this.getEntity().createAttributeOverride(0);
                defaultAttributeOverride.setName(override);
                this.getEntity().getDefaultAttributeOverrides().add((Object)defaultAttributeOverride);
            }
        }
        Collection attributeNames = CollectionTools.collection(this.getEntity().allOverridableAttributeNames());
        ArrayList<IAttributeOverride> overridesToRemove = new ArrayList<IAttributeOverride>();
        for (IAttributeOverride attributeOverride : this.getEntity().getDefaultAttributeOverrides()) {
            if (this.getEntity().containsSpecifiedAttributeOverride(attributeOverride.getName())) {
                overridesToRemove.add(attributeOverride);
                continue;
            }
            if (attributeNames.contains(attributeOverride.getName())) continue;
            if (javaEntity == null) {
                overridesToRemove.add(attributeOverride);
                continue;
            }
            if (this.getXmlTypeMapping().isXmlMetadataComplete()) {
                if (javaEntity.containsDefaultAttributeOverride(attributeOverride.getName())) continue;
                overridesToRemove.add(attributeOverride);
                continue;
            }
            if (javaEntity.containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            overridesToRemove.add(attributeOverride);
        }
        this.getEntity().getDefaultAttributeOverrides().removeAll(overridesToRemove);
    }

    protected void refreshDefaultAssociationOverrides() {
        IAssociationOverride defaultAssociationOverride;
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null && !this.getXmlTypeMapping().isXmlMetadataComplete()) {
            for (IAssociationOverride associationOverride : javaEntity.getAssociationOverrides()) {
                if (this.getEntity().containsAssociationOverride(associationOverride.getName())) continue;
                defaultAssociationOverride = this.getEntity().createAssociationOverride(0);
                defaultAssociationOverride.setName(associationOverride.getName());
                this.getEntity().getDefaultAssociationOverrides().add((Object)defaultAssociationOverride);
            }
        } else {
            Iterator<String> i = this.getEntity().allOverridableAssociationNames();
            while (i.hasNext()) {
                String override = i.next();
                if (this.getEntity().containsAssociationOverride(override)) continue;
                defaultAssociationOverride = this.getEntity().createAssociationOverride(0);
                defaultAssociationOverride.setName(override);
                this.getEntity().getDefaultAssociationOverrides().add((Object)defaultAssociationOverride);
            }
        }
        Collection attributeNames = CollectionTools.collection(this.getEntity().allOverridableAssociationNames());
        ArrayList<IAssociationOverride> overridesToRemove = new ArrayList<IAssociationOverride>();
        for (IAssociationOverride associationOverride : this.getEntity().getDefaultAssociationOverrides()) {
            if (this.getEntity().containsSpecifiedAssociationOverride(associationOverride.getName())) {
                overridesToRemove.add(associationOverride);
                continue;
            }
            if (attributeNames.contains(associationOverride.getName())) continue;
            if (javaEntity == null) {
                overridesToRemove.add(associationOverride);
                continue;
            }
            if (this.getXmlTypeMapping().isXmlMetadataComplete()) {
                if (javaEntity.containsDefaultAssociationOverride(associationOverride.getName())) continue;
                overridesToRemove.add(associationOverride);
                continue;
            }
            if (javaEntity.containsSpecifiedAssociationOverride(associationOverride.getName())) continue;
            overridesToRemove.add(associationOverride);
        }
        this.getEntity().getDefaultAssociationOverrides().removeAll(overridesToRemove);
    }

    protected void refreshDefaultSecondaryTables() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null && !this.getXmlTypeMapping().isXmlMetadataComplete()) {
            for (ISecondaryTable secondaryTable : javaEntity.getSecondaryTables()) {
                if (secondaryTable.getName() == null || this.getEntity().containsSecondaryTable(secondaryTable.getName())) continue;
                ISecondaryTable defaultSecondaryTable = this.getEntity().createSecondaryTable(0);
                defaultSecondaryTable.setSpecifiedName(secondaryTable.getName());
                this.getEntity().getVirtualSecondaryTables().add((Object)defaultSecondaryTable);
            }
        }
        ArrayList<ISecondaryTable> secondaryTablesToRemove = new ArrayList<ISecondaryTable>();
        for (ISecondaryTable secondaryTable : this.getEntity().getVirtualSecondaryTables()) {
            if (this.getXmlTypeMapping().isXmlMetadataComplete() || this.getEntity().containsSpecifiedSecondaryTable(secondaryTable.getName())) {
                secondaryTablesToRemove.add(secondaryTable);
                continue;
            }
            if (javaEntity == null) {
                secondaryTablesToRemove.add(secondaryTable);
                continue;
            }
            if (javaEntity.containsSecondaryTable(secondaryTable.getName())) continue;
            secondaryTablesToRemove.add(secondaryTable);
        }
        this.getEntity().getVirtualSecondaryTables().removeAll(secondaryTablesToRemove);
    }

    @Override
    public DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return super.wrapDefaultsContext(this.tableContext.wrapDefaultsContext(defaultsContext));
    }

    @Override
    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        String className;
        if (key.equals("entity.name") && (className = this.getPersistentType().getClass_()) != null) {
            return ClassTools.shortNameForClassNamed((String)className);
        }
        XmlTable xmlTable = this.getXmlTable();
        if (this.javaTable != null) {
            if (this.getXmlTypeMapping().isXmlMetadataComplete() || xmlTable.getNode() != null) {
                if (key.equals("table.schema")) {
                    return this.javaTable.getDefaultSchema();
                }
                if (key.equals("table.catalog")) {
                    return this.javaTable.getDefaultCatalog();
                }
                if (key.equals("table.name")) {
                    return this.javaTable.getDefaultName();
                }
            } else {
                if (key.equals("table.schema")) {
                    return this.javaTable.getSchema();
                }
                if (key.equals("table.catalog")) {
                    return this.javaTable.getCatalog();
                }
                if (key.equals("table.name")) {
                    return this.javaTable.getName();
                }
            }
        } else if (key.equals("table.name")) {
            if (this.getEntity().rootEntity().getInheritanceStrategy().isSingleTable()) {
                IEntity rootEntity = this.getEntity().rootEntity();
                if (rootEntity == this.getEntity()) {
                    return rootEntity.getName();
                }
                return rootEntity.getTable().getName();
            }
            return this.getEntity().getName();
        }
        return super.getDefault(key, defaultsContext);
    }

    private XmlTable getXmlTable() {
        return (XmlTable)((XmlEntity)((Object)this.getXmlTypeMapping())).getTable();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.tableContext.addToMessages(messages);
        this.addIdMessages(messages);
        for (SecondaryTableContext secondaryTableContext : this.secondaryTableContexts) {
            secondaryTableContext.addToMessages(messages);
        }
        for (XmlAttributeOverrideContext xmlAttributeOverrideContext : this.attributeOverrideContexts) {
            xmlAttributeOverrideContext.addToMessages(messages);
        }
        for (AssociationOverrideContext associationOverrideContext : this.associationOverrideContexts) {
            associationOverrideContext.addToMessages(messages);
        }
    }

    protected void addIdMessages(List<IMessage> messages) {
        this.addNoIdMessage(messages);
    }

    protected void addNoIdMessage(List<IMessage> messages) {
        XmlEntity entity = this.getEntity();
        if (this.entityHasNoId()) {
            messages.add(JpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{entity.getName()}, entity, entity.validationTextRange()));
        }
    }

    private boolean entityHasNoId() {
        return !this.entityHasId();
    }

    private boolean entityHasId() {
        Iterator<IPersistentAttribute> stream = this.getEntity().getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }
}

