/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.orm.XmlMultiRelationshipMappingInternal;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IMultiRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlJoinTableContext;
import org.eclipse.jpt.core.internal.platform.XmlRelationshipMappingContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlMultiRelationshipMappingContext
extends XmlRelationshipMappingContext
implements XmlJoinTableContext.ParentContext {
    private XmlJoinTableContext joinTableContext;

    protected XmlMultiRelationshipMappingContext(IContext parentContext, XmlMultiRelationshipMappingInternal mapping) {
        super(parentContext, mapping);
        this.joinTableContext = new XmlJoinTableContext(this, mapping.getJoinTable());
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaults(defaultsContext, monitor);
        this.joinTableContext.refreshDefaults(defaultsContext, monitor);
    }

    protected XmlMultiRelationshipMappingInternal multiRelationshipMapping() {
        return (XmlMultiRelationshipMappingInternal)this.relationshipMapping();
    }

    @Override
    public IMultiRelationshipMapping javaRelationshipMapping() {
        IAttributeMapping javaAttributeMapping = this.javaAttributeMapping();
        if (javaAttributeMapping instanceof IMultiRelationshipMapping) {
            return (IMultiRelationshipMapping)javaAttributeMapping;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.multiRelationshipMapping().getMappedBy() != null) {
            this.addMappedByMessages(messages);
        } else if (this.entityOwned()) {
            this.addJoinTableMessages(messages);
        }
    }

    protected void addJoinTableMessages(List<IMessage> messages) {
        this.joinTableContext.addToMessages(messages);
    }

    protected void addMappedByMessages(List<IMessage> messages) {
        INonOwningMapping mappedByMapping;
        IEntity targetEntity;
        XmlMultiRelationshipMappingInternal mapping = this.multiRelationshipMapping();
        String mappedBy = mapping.getMappedBy();
        if (mapping.isJoinTableSpecified()) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_WITH_JOIN_TABLE", mapping.getJoinTable(), mapping.getJoinTable().validationTextRange()));
        }
        if ((targetEntity = mapping.getResolvedTargetEntity()) == null) {
            return;
        }
        IPersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        if (!mapping.mappedByIsValid(attribute.getMapping())) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, mapping, mapping.mappedByTextRange()));
            return;
        }
        try {
            mappedByMapping = (INonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(JpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", mapping, mapping.mappedByTextRange()));
        }
    }
}

