/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.synch;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IMappingKeys;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.JavaClassRef;
import org.eclipse.jpt.core.internal.content.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeClassesJob
extends Job {
    private IFile persistenceXmlFile;

    public SynchronizeClassesJob(IFile file) {
        super(JptCoreMessages.SYNCHRONIZE_CLASSES_JOB);
        this.setRule((ISchedulingRule)file.getProject());
        this.persistenceXmlFile = file;
    }

    protected IStatus run(IProgressMonitor monitor) {
        PersistenceUnit persistenceUnit;
        PersistenceXmlRootContentNode root;
        monitor.beginTask(JptCoreMessages.SYNCHRONIZING_CLASSES_TASK, 150);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IJpaFile jpaFile = JptCorePlugin.jpaFile(this.persistenceXmlFile);
        try {
            root = (PersistenceXmlRootContentNode)jpaFile.getContent();
        }
        catch (ClassCastException classCastException) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.INVALID_PERSISTENCE_XML_CONTENT);
        }
        Persistence persistence = root.getPersistence();
        if (persistence == null) {
            persistence = PersistenceFactory.eINSTANCE.createPersistence();
            root.setPersistence(persistence);
        }
        if (persistence.getPersistenceUnits().size() > 0) {
            persistenceUnit = (PersistenceUnit)persistence.getPersistenceUnits().get(0);
        } else {
            persistenceUnit = PersistenceFactory.eINSTANCE.createPersistenceUnit();
            persistenceUnit.setName(this.persistenceXmlFile.getProject().getName());
            persistence.getPersistenceUnits().add((Object)persistenceUnit);
        }
        PersistenceResource resource = (PersistenceResource)persistenceUnit.eResource();
        persistenceUnit.getClasses().clear();
        Iterator<String> stream = this.sortedMappedTypeNames(persistenceUnit);
        while (stream.hasNext()) {
            JavaClassRef classRef = PersistenceFactory.eINSTANCE.createJavaClassRef();
            classRef.setJavaClass(stream.next());
            persistenceUnit.getClasses().add((Object)classRef);
        }
        monitor.worked(50);
        try {
            resource.save(null);
        }
        catch (IOException ioe) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.ERROR_WRITING_FILE, (Throwable)ioe);
        }
        return Status.OK_STATUS;
    }

    private Iterator<String> sortedMappedTypeNames(PersistenceUnit persistenceUnit) {
        return CollectionTools.sort(this.mappedTypeNames(persistenceUnit));
    }

    private Iterator<String> mappedTypeNames(PersistenceUnit persistenceUnit) {
        return new TransformationIterator<IPersistentType, String>(this.mappedTypes(persistenceUnit)){

            protected String transform(IPersistentType pType) {
                return pType.findJdtType().getFullyQualifiedName();
            }
        };
    }

    private Iterator<IPersistentType> mappedTypes(PersistenceUnit persistenceUnit) {
        return new FilteringIterator(persistenceUnit.getJpaProject().javaPersistentTypes(), this.filter(persistenceUnit));
    }

    private Filter<IPersistentType> filter(final PersistenceUnit persistenceUnit) {
        return new Filter<IPersistentType>(){

            public boolean accept(IPersistentType o) {
                if (o == null) {
                    return false;
                }
                if (o.getMappingKey() == IMappingKeys.NULL_TYPE_MAPPING_KEY) {
                    return false;
                }
                IType jdtType = o.findJdtType();
                if (jdtType == null) {
                    return false;
                }
                for (MappingFileRef mappingFileRef : persistenceUnit.getMappingFiles()) {
                    if (!SynchronizeClassesJob.this.containsType(mappingFileRef, jdtType)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private boolean containsType(MappingFileRef mappingFileRef, IType jdtType) {
        XmlRootContentNode root;
        IJpaFile mappingFile = mappingFileRef.getMappingFile();
        if (mappingFile == null) {
            return false;
        }
        try {
            root = (XmlRootContentNode)mappingFile.getContent();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        EntityMappingsInternal entityMappings = root.getEntityMappings();
        if (entityMappings == null) {
            return false;
        }
        for (IPersistentType persistentType : entityMappings.getPersistentTypes()) {
            IType otherJdtType = persistentType.findJdtType();
            if (otherJdtType == null || !otherJdtType.equals(jdtType)) continue;
            return true;
        }
        return false;
    }
}

