/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.validation;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaValidator
implements IValidatorJob {
    private static final CollectionChangeListener JPA_MODEL_LISTENER = new LocalCollectionChangeListener();

    static {
        JptCorePlugin.jpaModel().addCollectionChangeListener("jpaProjects", JPA_MODEL_LISTENER);
    }

    public void validate(IValidationContext context, IReporter reporter) throws ValidationException {
        reporter.removeAllMessages((IValidator)this);
        Iterator<IMessage> stream = this.validationMessages(context);
        while (stream.hasNext()) {
            reporter.addMessage((IValidator)this, stream.next());
        }
    }

    private Iterator<IMessage> validationMessages(IValidationContext context) {
        IProject project = ((IProjectValidationContext)context).getProject();
        return JptCorePlugin.jpaProject(project).validationMessages();
    }

    public void cleanup(IReporter reporter) {
    }

    public ISchedulingRule getSchedulingRule(IValidationContext context) {
        return ((IWorkbenchContext)context).getProject();
    }

    public IStatus validateInJob(IValidationContext context, IReporter reporter) throws ValidationException {
        this.validate(context, reporter);
        return OK_STATUS;
    }

    private static class DeleteMarkersJob
    extends Job {
        private final IJpaProject jpaProject;

        DeleteMarkersJob(IJpaProject jpaProject) {
            super("Delete Markers");
            this.jpaProject = jpaProject;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IMarker[] markers = this.jpaProject.project().findMarkers("org.eclipse.jpt.core.jpaProblemMarker", true, 2);
                ResourcesPlugin.getWorkspace().deleteMarkers(markers);
            }
            catch (CoreException ex) {
                JptCorePlugin.log(ex);
            }
            return Status.OK_STATUS;
        }
    }

    private static class LocalCollectionChangeListener
    implements CollectionChangeListener {
        LocalCollectionChangeListener() {
        }

        public void itemsAdded(CollectionChangeEvent event) {
        }

        public void itemsRemoved(CollectionChangeEvent event) {
            Iterator items = event.items();
            DeleteMarkersJob j = new DeleteMarkersJob((IJpaProject)items.next());
            j.schedule();
            if (items.hasNext()) {
                throw new UnsupportedOperationException("unexpected event");
            }
        }

        public void collectionCleared(CollectionChangeEvent event) {
            throw new UnsupportedOperationException("unexpected event");
        }

        public void collectionChanged(CollectionChangeEvent event) {
            throw new UnsupportedOperationException("unexpected event");
        }
    }
}

