/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.diagram.ui.util.DiagramEditorUtil;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyToHTMLImageUtil
extends CopyToImageUtil {
    private HashMap<ImageFileFormat, Dimension> imageFormatToTileSizeMap = new HashMap(ImageFileFormat.VALUES.length);
    private String tileImageFileNameIndexDelimiter = "_";

    public CopyToHTMLImageUtil() {
        this.imageFormatToTileSizeMap.put(ImageFileFormat.GIF, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.BMP, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.JPG, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.JPEG, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.PNG, new Dimension(3000, 3000));
        this.imageFormatToTileSizeMap.put(ImageFileFormat.SVG, new Dimension(0, 0));
    }

    @Override
    public DiagramGenerator copyToImage(DiagramEditPart diagramEP, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        ExportInfo exportInfo = this.copyToImageAndReturnInfo(diagramEP, diagramEP.getPrimaryEditParts(), destination, format, monitor);
        this.createHTMLFileForTiledImage(destination, exportInfo.commonTileFileName, format.getName().toLowerCase(), exportInfo.tiles.y, exportInfo.tiles.x);
        return exportInfo.diagramGenerator;
    }

    @Override
    public void copyToImage(DiagramEditPart diagramEP, List selection, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        ExportInfo exportInfo = this.copyToImageAndReturnInfo(diagramEP, selection, destination, format, monitor);
        this.createHTMLFileForTiledImage(destination, exportInfo.commonTileFileName, format.getName().toLowerCase(), exportInfo.tiles.y, exportInfo.tiles.x);
    }

    private Point exportImage(DiagramGenerator gen, List editParts, IPath destinationFolder, String fileName, ImageFileFormat imageFormat, int logTileWidth, int logTileHeight, IProgressMonitor monitor) throws Error, CoreException {
        org.eclipse.swt.graphics.Rectangle diagramArea = gen.calculateImageRectangle(editParts);
        int rows = 1;
        int columns = 1;
        columns = (int)Math.ceil((double)diagramArea.width / (double)logTileWidth);
        rows = (int)Math.ceil((double)diagramArea.height / (double)logTileHeight);
        int jobsToDo = 6 * columns * rows + 1;
        monitor.beginTask(DiagramUIMessages.CopyToHTMLImageTask_exportingToHTML, jobsToDo);
        int i = 0;
        while (i < rows) {
            int sourceY = i * logTileHeight + diagramArea.y;
            int sourceHeight = Math.min(logTileHeight, diagramArea.height - logTileHeight * i);
            int j = 0;
            while (j < columns) {
                int sourceX = diagramArea.x + j * logTileWidth;
                int sourceWidth = Math.min(logTileWidth, diagramArea.width - logTileWidth * j);
                String tileFileName = String.valueOf(fileName) + this.getTileImageFileNameIndexDelimiter() + i + this.getTileImageFileNameIndexDelimiter() + j + "." + imageFormat.getName().toLowerCase();
                IPath tilePath = new Path(destinationFolder.toOSString()).append(tileFileName);
                monitor.subTask(String.valueOf(DiagramUIMessages.CopyToHTMLImageTask_generateImageFile) + tilePath);
                this.copyToImage(gen, editParts, new org.eclipse.swt.graphics.Rectangle(sourceX, sourceY, sourceWidth, sourceHeight), tilePath, imageFormat, monitor);
                ++j;
            }
            ++i;
        }
        return new Point(columns, rows);
    }

    private IStatus createHTMLFileForTiledImage(IPath htmlFileLocation, String fileName, String fileExtension, int numRows, int numColumns) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(htmlFileLocation.toOSString()));
            out.write("<html>\n<body>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"RIGHT\">\n");
            int i = 0;
            while (i < numRows) {
                out.write("<tr>\n");
                int j = 0;
                while (j < numColumns) {
                    out.write("\t<td><img src=\"");
                    out.write(String.valueOf(fileName) + this.getTileImageFileNameIndexDelimiter() + i + this.getTileImageFileNameIndexDelimiter() + j + "." + fileExtension);
                    out.write("\"></td>\n");
                    ++j;
                }
                out.write("</tr>\n");
                ++i;
            }
            out.write("</table>\n</body>\n</html>");
            out.close();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(htmlFileLocation);
            if (file != null) {
                file.refreshLocal(0, null);
                return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
            }
        }
        catch (IOException iOException) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException coreException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public String getTileImageFileNameIndexDelimiter() {
        return this.tileImageFileNameIndexDelimiter;
    }

    public void setTileImageFileNameIndexDelimiter(String tileImageFileNameIndexDelimiter) {
        if (tileImageFileNameIndexDelimiter == null || tileImageFileNameIndexDelimiter.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.tileImageFileNameIndexDelimiter = tileImageFileNameIndexDelimiter;
    }

    public HashMap<ImageFileFormat, Dimension> getImageFormatToTileSizeMap() {
        return this.imageFormatToTileSizeMap;
    }

    private ExportInfo copyToImageAndReturnInfo(DiagramEditPart diagramEP, List selection, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        Dimension dimension = (Dimension)MapModeUtil.getMapMode((IFigure)diagramEP.getFigure()).DPtoLP((Translatable)this.imageFormatToTileSizeMap.get(format).getCopy());
        IPath destinationFolder = destination.removeLastSegments(1);
        String fileName = destination.removeFileExtension().lastSegment();
        Point tiles = this.exportImage(gen, selection, destinationFolder, fileName, format, dimension.width, dimension.height, monitor);
        return new ExportInfo(gen, tiles, fileName);
    }

    @Override
    public List copyToImage(Diagram diagram, IPath destination, ImageFileFormat format, IProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
        Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy diagram to Image " + destination + " as " + format));
        ExportInfo exportInfo = null;
        List partsInfo = Collections.EMPTY_LIST;
        DiagramEditor openedDiagramEditor = DiagramEditorUtil.findOpenedDiagramEditorForID((String)ViewUtil.getIdStr((View)diagram));
        if (openedDiagramEditor != null) {
            DiagramEditPart diagramEditPart = openedDiagramEditor.getDiagramEditPart();
            exportInfo = this.copyToImageAndReturnInfo(diagramEditPart, diagramEditPart.getPrimaryEditParts(), destination, format, monitor);
            partsInfo = exportInfo.diagramGenerator.getDiagramPartInfo(diagramEditPart);
        } else {
            Shell shell = new Shell();
            try {
                DiagramEditPart diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
                Assert.isNotNull((Object)diagramEditPart);
                exportInfo = this.copyToImageAndReturnInfo(diagramEditPart, diagramEditPart.getPrimaryEditParts(), destination, format, monitor);
                partsInfo = exportInfo.diagramGenerator.getDiagramPartInfo(diagramEditPart);
            }
            finally {
                shell.dispose();
            }
        }
        return this.createTilesPartsInfoList(exportInfo, partsInfo, format);
    }

    private List<List<List<PartPositionInfo>>> createTilesPartsInfoList(ExportInfo exportInfo, List partsInfo, ImageFileFormat format) {
        List<List<List<PartPositionInfo>>> tilesPartsInfoList = Collections.EMPTY_LIST;
        if (exportInfo.diagramGenerator != null && exportInfo.tiles.x > 0 && exportInfo.tiles.y > 0 && partsInfo != null) {
            tilesPartsInfoList = this.initializeTilesPartsInfoList(exportInfo.tiles.y, exportInfo.tiles.x);
            if (exportInfo.tiles.x == 1 && exportInfo.tiles.y == 1) {
                tilesPartsInfoList.get(0).set(0, partsInfo);
            } else {
                Dimension tileSize = this.imageFormatToTileSizeMap.get(format);
                Rectangle defaultTile = new Rectangle(new Point(), tileSize);
                for (PartPositionInfo info : partsInfo) {
                    if (info.getPolyline() == null) {
                        Point startCell = new Point();
                        startCell.x = info.getPartX() / tileSize.width;
                        startCell.y = info.getPartY() / tileSize.height;
                        Point endCell = new Point();
                        endCell.x = (info.getPartX() + info.getPartWidth()) / tileSize.width;
                        endCell.y = (info.getPartY() + info.getPartHeight()) / tileSize.height;
                        int i = startCell.y;
                        while (i <= endCell.y) {
                            int j = startCell.x;
                            while (j <= endCell.x) {
                                Rectangle shapeRect = new Rectangle(info.getPartX(), info.getPartY(), info.getPartWidth(), info.getPartHeight());
                                shapeRect.translate(-j * tileSize.width, -i * tileSize.height);
                                Rectangle intersection = shapeRect.intersect(defaultTile);
                                PartPositionInfo newInfo = new PartPositionInfo();
                                newInfo.setSemanticElement(info.getSemanticElement());
                                newInfo.setPartHeight(intersection.height);
                                newInfo.setPartWidth(intersection.width);
                                newInfo.setPartX(intersection.x);
                                newInfo.setPartY(intersection.y);
                                tilesPartsInfoList.get(i).get(j).add(newInfo);
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    int i = 1;
                    while (i <= info.getPolyline().size() / 2) {
                        Point upperStartPt = (Point)info.getPolyline().get(i - 1);
                        Point upperEndPt = (Point)info.getPolyline().get(i);
                        Point lowerEndPt = (Point)info.getPolyline().get(info.getPolyline().size() - 1 - i);
                        Point lowerStartPt = (Point)info.getPolyline().get(info.getPolyline().size() - 1 - (i + 1));
                        HashSet<Point> cells = new HashSet<Point>();
                        HashMap<Point, LineSeg> upperLineSegs = this.getMapOfLineSegments(upperStartPt, upperEndPt, tileSize, cells);
                        HashMap<Point, LineSeg> lowerLineSegs = this.getMapOfLineSegments(lowerStartPt, lowerEndPt, tileSize, cells);
                        HashMap<Point, LineSeg> upperToLowerLineSegs = this.getMapOfLineSegments(upperEndPt, lowerStartPt, tileSize, cells);
                        HashMap<Point, LineSeg> lowerToUpperLineSegs = this.getMapOfLineSegments(lowerEndPt, upperStartPt, tileSize, cells);
                        for (Point cell : cells) {
                            LineSeg upperSeg = upperLineSegs.get(cell);
                            LineSeg lowerSeg = lowerLineSegs.get(cell);
                            LineSeg upperToLowerSeg = upperToLowerLineSegs.get(cell);
                            LineSeg lowerToUpperSeg = lowerToUpperLineSegs.get(cell);
                            ArrayList<LineSeg> cwListOfLineSegs = new ArrayList<LineSeg>(4);
                            if (upperSeg != null) {
                                cwListOfLineSegs.add(upperSeg);
                            }
                            if (upperToLowerSeg != null) {
                                cwListOfLineSegs.add(upperToLowerSeg);
                            }
                            if (lowerSeg != null) {
                                cwListOfLineSegs.add(lowerSeg);
                            }
                            if (lowerToUpperSeg != null) {
                                cwListOfLineSegs.add(lowerToUpperSeg);
                            }
                            PartPositionInfo newInfo = new PartPositionInfo();
                            newInfo.setSemanticElement(info.getSemanticElement());
                            newInfo.setPolyline(this.createCellPolyline(tileSize, cwListOfLineSegs));
                            tilesPartsInfoList.get(cell.y).get(cell.x).add(newInfo);
                        }
                        i += 2;
                    }
                }
            }
        }
        return tilesPartsInfoList;
    }

    private List<List<List<PartPositionInfo>>> initializeTilesPartsInfoList(int rows, int columns) {
        ArrayList<List<List<PartPositionInfo>>> tilesPartsInfoList = new ArrayList<List<List<PartPositionInfo>>>(rows);
        int i = 0;
        while (i < rows) {
            ArrayList row = new ArrayList(columns);
            int j = 0;
            while (j < columns) {
                row.add(new LinkedList());
                ++j;
            }
            tilesPartsInfoList.add(row);
            ++i;
        }
        return tilesPartsInfoList;
    }

    private HashMap<Point, LineSeg> getMapOfLineSegments(Point startPoint, Point endPoint, Dimension tileSize, HashSet<Point> cells) {
        HashMap<Point, LineSeg> map = new HashMap<Point, LineSeg>();
        Point startCell = new Point();
        startCell.x = startPoint.x / tileSize.width;
        startCell.y = startPoint.y / tileSize.height;
        Point endCell = new Point();
        endCell.x = endPoint.x / tileSize.width;
        endCell.y = endPoint.y / tileSize.height;
        if (startCell.equals((Object)endCell)) {
            map.put(startCell, new LineSeg(startPoint.getCopy().translate(-startCell.x * tileSize.width, -startCell.y * tileSize.height), endPoint.getCopy().translate(-startCell.x * tileSize.width, -startCell.y * tileSize.height)));
            cells.add(startCell);
        } else {
            double[] equation = LineSeg.getLineEquation((double)startPoint.x, (double)startPoint.y, (double)endPoint.x, (double)endPoint.y);
            ArrayList<Point> linePoints = new ArrayList<Point>(2 + Math.abs(startCell.x - endCell.x) + Math.abs(startCell.y - endCell.y));
            if (equation[1] != 0.0) {
                int x = tileSize.width * (Math.min(startCell.x, endCell.x) + 1);
                while (x <= tileSize.width * Math.max(startCell.x, endCell.x)) {
                    linePoints.add(new Point((double)x, (double)Math.round((equation[2] - equation[0] * (double)x) / equation[1])));
                    x += tileSize.width;
                }
            }
            if (equation[0] != 0.0) {
                int y = tileSize.height * (Math.min(startCell.y, endCell.y) + 1);
                while (y <= tileSize.height * Math.max(startCell.y, endCell.y)) {
                    linePoints.add(new Point((double)Math.round((equation[2] - equation[1] * (double)y) / equation[0]), (double)y));
                    y += tileSize.height;
                }
            }
            Collections.sort(linePoints, new LineSegmentPointsComparator(startPoint));
            linePoints.add(0, startPoint.getCopy());
            linePoints.add(endPoint.getCopy());
            Point currentCell = startCell;
            Iterator pointsItr = linePoints.iterator();
            Point originPoint = (Point)pointsItr.next();
            while (pointsItr.hasNext()) {
                Point terminusPoint = (Point)pointsItr.next();
                Point translatedOrigin = originPoint.getCopy().translate(-currentCell.x * tileSize.width, -currentCell.y * tileSize.height);
                Point translatedTerminus = terminusPoint.getCopy().translate(-currentCell.x * tileSize.width, -currentCell.y * tileSize.height);
                map.put(currentCell.getCopy(), new LineSeg(translatedOrigin, translatedTerminus));
                cells.add(currentCell.getCopy());
                if (translatedTerminus.x == 0) {
                    --currentCell.x;
                }
                if (translatedTerminus.y == 0) {
                    --currentCell.y;
                }
                if (translatedTerminus.x == tileSize.width) {
                    ++currentCell.x;
                }
                if (translatedTerminus.y == tileSize.height) {
                    ++currentCell.y;
                }
                originPoint = terminusPoint;
            }
        }
        return map;
    }

    private List<Point> createCellPolyline(Dimension cellSize, List<LineSeg> segments) {
        LinkedList<Point> result = new LinkedList<Point>();
        if (segments.size() > 0) {
            LineSeg currentSegment = segments.get(0);
            int i = 0;
            while (i < segments.size()) {
                LineSeg nextSegment = segments.get((i + 1) % segments.size());
                result.add(currentSegment.getTerminus());
                if (!currentSegment.getTerminus().equals((Object)nextSegment.getOrigin())) {
                    List<Point> connectingPoints = this.connectLineSegmentsEndsViaCellEdges(cellSize, currentSegment, nextSegment);
                    Iterator<Point> itr = connectingPoints.iterator();
                    while (itr.hasNext()) {
                        result.add(itr.next());
                    }
                    result.add(nextSegment.getOrigin());
                }
                currentSegment = nextSegment;
                ++i;
            }
            result.add((Point)result.get(0));
        }
        return result;
    }

    private List<Point> connectLineSegmentsEndsViaCellEdges(Dimension cellSize, LineSeg lineSeg1, LineSeg lineSeg2) {
        Point current = lineSeg1.getTerminus();
        Point next = lineSeg2.getOrigin();
        LinkedList<Point> result = new LinkedList<Point>();
        List<Point> cwCellVertices = this.createClockwiseListOfCellVertices(cellSize);
        int currentIdx = this.indexOfCellEdgePointClockwise(cellSize, current);
        int nextIdx = this.indexOfCellEdgePointClockwise(cellSize, next);
        int i = currentIdx;
        while (i != nextIdx) {
            result.add(cwCellVertices.get(i));
            i = (i + 1) % cwCellVertices.size();
        }
        return result;
    }

    private List<Point> createClockwiseListOfCellVertices(Dimension cellSize) {
        ArrayList<Point> cellVertices = new ArrayList<Point>(4);
        cellVertices.add(new Point());
        cellVertices.add(new Point(cellSize.width, 0));
        cellVertices.add(new Point(cellSize.width, cellSize.height));
        cellVertices.add(new Point(0, cellSize.height));
        return cellVertices;
    }

    private int indexOfCellEdgePointClockwise(Dimension cellSize, Point pt) {
        if (pt.x == 0) {
            return 0;
        }
        if (pt.y == 0) {
            return 1;
        }
        if (pt.x == cellSize.width) {
            return 2;
        }
        if (pt.y == cellSize.height) {
            return 3;
        }
        return 0;
    }

    private class ExportInfo {
        DiagramGenerator diagramGenerator;
        Point tiles;
        String commonTileFileName;

        ExportInfo(DiagramGenerator diagramGenerator, Point tiles, String commonTileFileName) {
            this.diagramGenerator = diagramGenerator;
            this.tiles = tiles;
            this.commonTileFileName = commonTileFileName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineSegmentPointsComparator
    implements Comparator<Point> {
        private Point segmentOrigin;

        public LineSegmentPointsComparator(Point segmentOrigin) {
            this.segmentOrigin = segmentOrigin;
        }

        @Override
        public int compare(Point p1, Point p2) {
            if (p1.x == p2.x) {
                return Math.abs(p1.y - this.segmentOrigin.y) - Math.abs(p2.y - this.segmentOrigin.y);
            }
            return Math.abs(p1.x - this.segmentOrigin.x) - Math.abs(p2.x - this.segmentOrigin.x);
        }
    }
}

