/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramImageGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.util.DiagramEditorUtil;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageExporter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class CopyToImageUtil {
    public DiagramEditPart createDiagramEditPart(Diagram diagram, Shell shell, PreferencesHint preferencesHint) {
        return OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell, preferencesHint);
    }

    public List copyToImage(Diagram diagram, IPath destination, ImageFileFormat format, IProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
        Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy diagram to Image " + destination + " as " + format));
        List partInfo = Collections.EMPTY_LIST;
        DiagramEditor openedDiagramEditor = DiagramEditorUtil.findOpenedDiagramEditorForID((String)ViewUtil.getIdStr((View)diagram));
        if (openedDiagramEditor != null) {
            DiagramGenerator generator = this.copyToImage(openedDiagramEditor.getDiagramEditPart(), destination, format, monitor);
            partInfo = generator.getDiagramPartInfo(openedDiagramEditor.getDiagramEditPart());
        } else {
            Shell shell = new Shell();
            try {
                DiagramEditPart diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
                Assert.isNotNull((Object)diagramEditPart);
                DiagramGenerator generator = this.copyToImage(diagramEditPart, destination, format, monitor);
                partInfo = generator.getDiagramPartInfo(diagramEditPart);
            }
            finally {
                shell.dispose();
            }
        }
        return partInfo;
    }

    public DiagramGenerator copyToImage(DiagramEditPart diagramEP, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        List editParts = diagramEP.getPrimaryEditParts();
        this.copyToImage(gen, editParts, gen.calculateImageRectangle(editParts), destination, format, monitor);
        monitor.worked(1);
        return gen;
    }

    public void copyToImage(DiagramEditPart diagramEP, List selection, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
        this.copyToImage(gen, selection, gen.calculateImageRectangle(selection), destination, format, monitor);
        monitor.worked(1);
    }

    protected DiagramGenerator getDiagramGenerator(DiagramEditPart diagramEP, ImageFileFormat format) {
        if (format.equals((Object)ImageFileFormat.SVG)) {
            return new DiagramSVGGenerator(diagramEP);
        }
        return new DiagramImageGenerator(diagramEP);
    }

    protected void copyToImage(DiagramGenerator gen, List editParts, Rectangle imageRect, IPath destination, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
        boolean found = false;
        if (format.equals((Object)ImageFileFormat.SVG)) {
            gen.createSWTImageDescriptorForParts(editParts, imageRect);
            monitor.worked(1);
            this.saveSVGToFile(destination, (DiagramSVGGenerator)gen, monitor);
            found = true;
        } else if (format.equals((Object)ImageFileFormat.JPEG) || format.equals((Object)ImageFileFormat.PNG)) {
            String exportFormat = "JPEG";
            if (format.equals((Object)ImageFileFormat.PNG)) {
                exportFormat = "PNG";
            }
            Image image = gen.createAWTImageForParts(editParts, imageRect);
            monitor.worked(1);
            if (image instanceof BufferedImage) {
                ImageExporter.exportToFile((IPath)destination, (BufferedImage)((BufferedImage)image), (String)exportFormat, (IProgressMonitor)monitor);
                found = true;
            }
        }
        if (!found) {
            org.eclipse.swt.graphics.Image image = gen.createSWTImageDescriptorForParts(editParts, imageRect).createImage();
            monitor.worked(1);
            this.saveToFile(destination, image, format, monitor);
            image.dispose();
        }
        monitor.worked(1);
    }

    protected void saveToFile(IPath destination, org.eclipse.swt.graphics.Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) throws CoreException {
        monitor.worked(1);
        ImageData imageData = image.getImageData();
        if (imageFormat.equals((Object)ImageFileFormat.GIF) || imageFormat.equals((Object)ImageFileFormat.BMP)) {
            imageData = this.createImageData(image);
        }
        monitor.worked(1);
        IStatus fileModificationStatus = this.createFile(destination);
        if (!fileModificationStatus.isOK()) {
            return;
        }
        monitor.worked(1);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.logicalScreenHeight = image.getBounds().width;
        imageLoader.logicalScreenHeight = image.getBounds().height;
        imageLoader.save(destination.toOSString(), imageFormat.getOrdinal());
        monitor.worked(1);
        this.refreshLocal(destination);
    }

    protected void saveSVGToFile(IPath destination, DiagramSVGGenerator generator, IProgressMonitor monitor) throws CoreException {
        IStatus fileModificationStatus = this.createFile(destination);
        if (!fileModificationStatus.isOK()) {
            return;
        }
        monitor.worked(1);
        try {
            FileOutputStream os = new FileOutputStream(destination.toOSString());
            monitor.worked(1);
            generator.stream(os);
            monitor.worked(1);
            os.close();
            monitor.worked(1);
            this.refreshLocal(destination);
        }
        catch (IOException ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
            Status status = new Status(4, "exportToFile", 0, ex.getMessage(), null);
            throw new CoreException((IStatus)status);
        }
    }

    private IStatus createFile(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null && !file.exists()) {
            File osFile = new File(destination.toOSString());
            if (osFile.exists()) {
                file.refreshLocal(0, null);
            } else {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)input, false, null);
            }
        }
        if (file != null) {
            return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
        }
        return Status.OK_STATUS;
    }

    private void refreshLocal(IPath destination) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
        if (file != null) {
            file.refreshLocal(0, null);
        }
    }

    private ImageData createImageData(org.eclipse.swt.graphics.Image image) {
        ImageData imageData = image.getImageData();
        if (imageData.depth <= 8) {
            return imageData;
        }
        ImageData newImageData = this.get8BitPaletteImageData(imageData);
        if (newImageData == null) {
            newImageData = this.getWebSafePalletteImageData(imageData);
        }
        return newImageData;
    }

    private ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private ImageData getWebSafePalletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] webSafePallette = this.getWebSafePallette();
        PaletteData newPaletteData = new PaletteData(webSafePallette);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    RGB webSafeColour = this.getWebSafeColour(colour);
                    newPixel = 0;
                    while (newPixel < 216) {
                        if (webSafePallette[newPixel].equals((Object)webSafeColour)) break;
                        ++newPixel;
                    }
                    Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    private RGB getWebSafeColour(RGB colour) {
        int red = Math.round((colour.red + 25) / 51) * 51;
        int green = Math.round((colour.green + 25) / 51) * 51;
        int blue = Math.round((colour.blue + 25) / 51) * 51;
        return new RGB(red, green, blue);
    }

    private RGB[] getWebSafePallette() {
        RGB[] colours = new RGB[256];
        int i = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    RGB colour = new RGB(red, green, blue);
                    colours[i++] = colour;
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return colours;
    }
}

