/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class PreviewSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList classpaths = new ArrayList();
        classpaths.addAll(Arrays.asList(JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration)));
        ArrayList<FolderSourceContainer> sourcefolderList = new ArrayList<FolderSourceContainer>();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server != null) {
            ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
            IModule[] modules = server.getModules();
            int i = 0;
            while (i < modules.length) {
                IProject project = modules[i].getProject();
                if (project != null) {
                    IFolder moduleFolder = project.getFolder(modules[i].getName());
                    if (moduleFolder.exists()) {
                        sourcefolderList.add(new FolderSourceContainer((IContainer)moduleFolder, true));
                    }
                    try {
                        IJavaProject javaProject;
                        if (project.hasNature("org.eclipse.jdt.core.javanature") && !list.contains(javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature"))) {
                            list.add(javaProject);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            int size = list.size();
            IJavaProject[] projects = new IJavaProject[size];
            list.toArray(projects);
            int i2 = 0;
            while (i2 < size) {
                classpaths.addAll(Arrays.asList(JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)projects[i2])));
                ++i2;
            }
        }
        IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[classpaths.size()];
        classpaths.toArray(entries);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ISourceContainer[] sourceContainers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
        if (!sourcefolderList.isEmpty()) {
            ISourceContainer[] combinedSourceContainers = new ISourceContainer[sourceContainers.length + sourcefolderList.size()];
            sourcefolderList.toArray(combinedSourceContainers);
            System.arraycopy(sourceContainers, 0, combinedSourceContainers, sourcefolderList.size(), sourceContainers.length);
            sourceContainers = combinedSourceContainers;
        }
        return sourceContainers;
    }
}

