/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteFromDiagramAction
extends DiagramAction {
    public DeleteFromDiagramAction(IWorkbenchPart part) {
        super(part);
    }

    public DeleteFromDiagramAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        super.init();
        this.setId("deleteFromDiagramAction");
        this.setText(DiagramUIActionsMessages.DeleteFromDiagram_ActionLabelText);
        this.setToolTipText(DiagramUIActionsMessages.DeleteFromDiagram_ActionToolTipText);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Request createTargetRequest() {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        return deleteReq;
    }

    protected Command getCommand() {
        List objects = this.createOperationSet();
        if (!this.supportViews(objects) || this.isCanonical(objects)) {
            return null;
        }
        CompoundCommand deleteCC = new CompoundCommand(this.getLabel());
        for (EditPart editPart : objects) {
            deleteCC.add(editPart.getCommand(this.getTargetRequest()));
        }
        return deleteCC;
    }

    private boolean supportViews(List objects) {
        for (Object object : objects) {
            if (!(object instanceof GraphicalEditPart) || ((GraphicalEditPart)object).hasNotationView()) continue;
            return false;
        }
        return true;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        return selection;
    }

    private boolean isCanonical(List selectedItems) {
        if (selectedItems.isEmpty()) {
            return false;
        }
        for (Object selectedObject : selectedItems) {
            EObject element;
            IGraphicalEditPart gep;
            Object model;
            if (!(selectedObject instanceof IGraphicalEditPart) || !((model = (gep = (IGraphicalEditPart)selectedObject).getModel()) instanceof View) || ((element = ((View)model).getElement()) == null || element instanceof View) && (!(selectedObject instanceof ConnectionEditPart) || !((ConnectionEditPart)selectedObject).isSemanticConnection())) continue;
            if (selectedObject instanceof ConnectionEditPart) {
                ConnectionEditPart ePart = (ConnectionEditPart)selectedObject;
                EditPart sEditPart = ePart.getSource();
                EditPart tEditPart = ePart.getTarget();
                if (!this.isCanonical(sEditPart) || !this.isCanonical(tEditPart)) continue;
                return true;
            }
            if (!this.isCanonical(gep)) continue;
            return true;
        }
        return false;
    }

    private boolean isCanonical(EditPart gep) {
        if (gep instanceof IGraphicalEditPart) {
            return this.isCanonical((IGraphicalEditPart)gep);
        }
        return false;
    }

    private boolean isCanonical(IGraphicalEditPart gep) {
        CanonicalEditPolicy cep;
        EditPart parent = gep.getParent();
        while (parent instanceof GroupEditPart) {
            parent = parent.getParent();
        }
        return parent instanceof IGraphicalEditPart && (cep = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical")) != null && cep.isEnabled();
    }
}

