/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.earcreation.EarFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.jca.project.facet.ConnectorFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.AppClientFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.UtilityFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.IComponentProjectMigrator;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.SimpleValidateEdit;
import org.eclipse.wst.project.facet.SimpleWebFacetInstallDataModelProvider;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

public class J2EEComponentProjectMigrator
implements IComponentProjectMigrator {
    private static final String WEB_LIB_CONTAINER = "org.eclipse.jst.j2ee.internal.web.container";
    private static final String WEB_LIB_PATH = "/WEB-INF/lib";
    private static final String OLD_DEPLOYABLES_PATH = ".deployables";
    private IProject project;
    private static final String[] J2EE_CONTENT_EXTENSION_IDS = new String[]{"org.eclipse.jst.navigator.j2ee.ui.EARDDContent", "org.eclipse.jst.navigator.j2ee.ui.WebDDContent", "org.eclipse.jst.navigator.j2ee.ui.EJBDDContent", "org.eclipse.jst.navigator.j2ee.ui.ConnectorDDContent"};
    private static final String PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer";

    public void migrateProject(IProject aProject) {
        if (aProject.isAccessible() && aProject.getFile(StructureEdit.MODULE_META_FILE_NAME).exists()) {
            Resource resource = WorkbenchResourceHelperBase.getResource((IFile)aProject.getFile(StructureEdit.MODULE_META_FILE_NAME), (boolean)false);
            if (resource != null && resource.isLoaded()) {
                resource.unload();
            }
            ArrayList<IFile> files = new ArrayList<IFile>();
            files.add(aProject.getFile(".project"));
            files.add(aProject.getFile(".classpath"));
            files.add(aProject.getFile(StructureEdit.MODULE_META_FILE_NAME));
            if (SimpleValidateEdit.validateEdit(files)) {
                String facetid;
                this.project = aProject;
                this.removeComponentBuilders(this.project);
                if (this.multipleComponentsDetected()) {
                    this.createNewProjects();
                }
                if ((facetid = this.getFacetFromProject(this.project)).length() == 0) {
                    this.addFacets(this.project);
                }
                J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.project);
            }
        }
        this.ensureJ2EEContentExtensionsEnabled();
    }

    private void ensureJ2EEContentExtensionsEnabled() {
        Display display;
        IViewPart view = null;
        try {
            view = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView(PROJECT_EXPLORER);
        }
        catch (Exception exception) {}
        if (view == null) {
            return;
        }
        INavigatorContentService contentService = (INavigatorContentService)view.getAdapter(INavigatorContentService.class);
        CommonViewer viewer = (CommonViewer)view.getAdapter(CommonViewer.class);
        if (contentService != null) {
            contentService.getActivationService().activateExtensions(J2EE_CONTENT_EXTENSION_IDS, false);
        }
        if (viewer != null && (display = viewer.getControl().getDisplay()) != null && Thread.currentThread().equals(display.getThread())) {
            viewer.refresh();
        }
    }

    private void createNewProjects() {
        StructureEdit se = null;
        try {
            se = StructureEdit.getStructureEditForWrite((IProject)this.project);
            EList comps = se.getComponentModelRoot().getComponents();
            ArrayList<WorkbenchComponent> removedComps = new ArrayList<WorkbenchComponent>();
            int i = 1;
            while (i < comps.size()) {
                WorkbenchComponent comp = (WorkbenchComponent)comps.get(i);
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IProject newProj = ws.getRoot().getProject(comp.getName());
                if (!newProj.exists()) {
                    try {
                        this.createProj(newProj, !comp.getComponentType().getComponentTypeId().equals("jst.ear"));
                        WtpUtils.addNatures((IProject)newProj);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                if (comp != null && comp.getComponentType() != null) {
                    this.addFacetsToProject(newProj, comp.getComponentType().getComponentTypeId(), comp.getComponentType().getVersion(), false);
                }
                removedComps.add(comp);
                IFolder compFolder = this.project.getFolder(comp.getName());
                if (compFolder.exists()) {
                    try {
                        compFolder.delete(true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            se.getComponentModelRoot().getComponents().removeAll(removedComps);
            se.save(null);
        }
        finally {
            if (se != null) {
                se.dispose();
            }
        }
    }

    private void createProj(IProject newProj, boolean isJavaProject) throws CoreException {
        newProj.create(null);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(newProj.getName());
        description.setLocation(null);
        newProj.open(null);
        newProj.setDescription(description, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean multipleComponentsDetected() {
        StructureEdit se = null;
        try {
            se = StructureEdit.getStructureEditForRead((IProject)this.project);
            if (se == null) {
                return false;
            }
            if (se.getComponentModelRoot() == null) {
                return false;
            }
            boolean bl = se.getComponentModelRoot().getComponents().size() > 1;
            return bl;
        }
        finally {
            if (se != null) {
                se.dispose();
            }
        }
    }

    private void removeComponentBuilders(IProject aProject) {
        try {
            aProject.refreshLocal(2, null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        ArrayList<String> oldBuilders = new ArrayList<String>();
        oldBuilders.add("org.eclipse.wst.common.modulecore.ComponentStructuralBuilder");
        oldBuilders.add("org.eclipse.wst.common.modulecore.ComponentStructuralBuilderDependencyResolver");
        oldBuilders.add("org.eclipse.wst.common.modulecore.DependencyGraphBuilder");
        try {
            J2EEProjectUtilities.removeBuilders((IProject)aProject, oldBuilders);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getFacetFromProject(IProject aProject) {
        return J2EEProjectUtilities.getJ2EEProjectType((IProject)aProject);
    }

    protected IDataModel setupJavaInstallAction(IProject aProject, boolean existing, String srcFolder) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        String jVersion = "1.4";
        ProjectScope context = new ProjectScope(this.project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.core");
        if ("1.5".equals(prefs.get("org.eclipse.jdt.core.compiler.compliance", "1.4"))) {
            jVersion = "5.0";
        }
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)jVersion);
        if (!existing) {
            dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", srcFolder);
        }
        return dm;
    }

    protected IDataModel setupUtilInstallAction(IProject aProject, String specVersion) {
        IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UtilityFacetInstallDataModelProvider());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        aFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return aFacetInstallDataModel;
    }

    protected IDataModel setupEarInstallAction(IProject aProject, String specVersion) {
        IDataModel earFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarFacetInstallDataModelProvider());
        earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        earFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        return earFacetInstallDataModel;
    }

    protected IDataModel setupAppClientInstallAction(IProject aProject, String specVersion) {
        IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetInstallDataModelProvider());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        aFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        aFacetInstallDataModel.setBooleanProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS", false);
        return aFacetInstallDataModel;
    }

    protected IDataModel setupConnectorInstallAction(IProject aProject, String specVersion) {
        IDataModel aFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorFacetInstallDataModelProvider());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        aFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        aFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        aFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return aFacetInstallDataModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFacets(IProject aProject) {
        StructureEdit edit = null;
        try {
            edit = StructureEdit.getStructureEditForWrite((IProject)aProject);
            if (edit == null) {
                return;
            }
            edit.getModuleStructuralModel().setUseOldFormat(true);
            if (edit.getComponent() == null) {
                return;
            }
            ComponentType type = edit.getComponent().getComponentType();
            if (type == null) {
                return;
            }
            String compId = type.getComponentTypeId();
            String specVersion = edit.getComponent().getComponentType().getVersion();
            this.moveMetaProperties(edit.getComponent(), type);
            this.addFacetsToProject(aProject, compId, specVersion, true);
            return;
        }
        finally {
            if (edit != null) {
                edit.save(null);
                edit.getModuleStructuralModel().setUseOldFormat(false);
                edit.dispose();
            }
        }
    }

    private void moveMetaProperties(WorkbenchComponent component, ComponentType type) {
        EList props = type.getProperties();
        EList compProps = component.getProperties();
        for (Property element : props) {
            Property newProp = ComponentcoreFactory.eINSTANCE.createProperty();
            newProp.setName(element.getName());
            newProp.setValue(element.getValue());
            compProps.add(newProp);
        }
        props.clear();
    }

    private void addFacetsToProject(IProject aProject, String compId, String specVersion, boolean existing) {
        if (compId.equals("jst.web")) {
            this.installWEBFacets(aProject, specVersion, existing);
        } else if (compId.equals("jst.ejb")) {
            this.installEJBFacets(aProject, specVersion, existing);
        } else if (compId.equals("jst.appclient")) {
            this.installAppClientFacets(aProject, specVersion, existing);
        } else if (compId.equals("jst.ear")) {
            this.installEARFacets(aProject, specVersion, existing);
        } else if (compId.equals("jst.connector")) {
            this.installConnectorFacets(aProject, specVersion, existing);
        } else if (compId.equals("jst.utility")) {
            this.installUtilityFacets(aProject, specVersion, existing);
        } else if (compId.equals("wst.web")) {
            this.installStaticWebFacets(aProject, specVersion, existing);
        }
    }

    private void installStaticWebFacets(IProject project2, String specVersion, boolean existing) {
        block3: {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project2.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel newModel = this.setupStaticWebInstallAction(project2);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null || !(realException instanceof CoreException)) break block3;
                IStatus st = ((CoreException)realException).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                realException.printStackTrace();
            }
        }
    }

    private IDataModel setupStaticWebInstallAction(IProject project2) {
        IDataModel webFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new SimpleWebFacetInstallDataModelProvider());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project2.getName());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        return webFacetInstallDataModel;
    }

    private void installUtilityFacets(IProject aProject, String specVersion, boolean existing) {
        block3: {
            this.replaceDeployablesOutputIfNecessary(this.project);
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetDMs.add(this.setupJavaInstallAction(aProject, existing, "src"));
            IDataModel newModel = this.setupUtilInstallAction(aProject, specVersion);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null || !(realException instanceof CoreException)) break block3;
                IStatus st = ((CoreException)realException).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                realException.printStackTrace();
            }
        }
    }

    private void installConnectorFacets(IProject aProject, String specVersion, boolean existing) {
        block3: {
            this.replaceDeployablesOutputIfNecessary(this.project);
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetDMs.add(this.setupJavaInstallAction(aProject, existing, J2EEPlugin.getDefault().getJ2EEPreferences().getString("jcaContent")));
            IDataModel newModel = this.setupConnectorInstallAction(aProject, specVersion);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null || !(realException instanceof CoreException)) break block3;
                IStatus st = ((CoreException)realException).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                realException.printStackTrace();
            }
        }
    }

    private void installEARFacets(IProject aProject, String specVersion, boolean existing) {
        block3: {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel newModel = this.setupEarInstallAction(aProject, specVersion);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null || !(realException instanceof CoreException)) break block3;
                IStatus st = ((CoreException)realException).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                realException.printStackTrace();
            }
        }
    }

    private void installAppClientFacets(IProject aProject, String specVersion, boolean existing) {
        block3: {
            this.replaceDeployablesOutputIfNecessary(this.project);
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetDMs.add(this.setupJavaInstallAction(aProject, existing, J2EEPlugin.getDefault().getJ2EEPreferences().getString("appClientContent")));
            IDataModel newModel = this.setupAppClientInstallAction(aProject, specVersion);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null || !(realException instanceof CoreException)) break block3;
                IStatus st = ((CoreException)realException).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                realException.printStackTrace();
            }
        }
    }

    private void installEJBFacets(IProject ejbProject2, String ejbVersion, boolean existing) {
        block3: {
            this.replaceDeployablesOutputIfNecessary(this.project);
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)ejbProject2.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetDMs.add(this.setupJavaInstallAction(ejbProject2, existing, J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent")));
            IDataModel newModel = this.setupEjbInstallAction(ejbProject2, ejbVersion, existing);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null || !(realException instanceof CoreException)) break block3;
                IStatus st = ((CoreException)realException).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                realException.printStackTrace();
            }
        }
    }

    private void installWEBFacets(IProject webProj, String specVersion, boolean existing) {
        block6: {
            this.removeOldWebContainerIfNecessary(this.project);
            this.replaceDeployablesOutputIfNecessary(this.project);
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)webProj.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetDMs = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetDMs.add(this.setupJavaInstallAction(webProj, existing, CommonFrameworksPlugin.getDefault().getPluginPreferences().getString("defaultSource")));
            IDataModel newModel = this.setupWebInstallAction(webProj, specVersion);
            facetDMs.add(newModel);
            try {
                dm.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException != null && realException instanceof CoreException) {
                    IStatus st = ((CoreException)realException).getStatus();
                    if (st != null) {
                        System.out.println(st);
                    }
                    realException.printStackTrace();
                }
            }
            catch (Exception ex) {
                if (ex == null || !(ex instanceof CoreException)) break block6;
                IStatus st = ((CoreException)((Object)ex)).getStatus();
                if (st != null) {
                    System.out.println(st);
                }
                ex.printStackTrace();
            }
        }
    }

    private void replaceDeployablesOutputIfNecessary(IProject proj) {
        IJavaProject jproj = JemProjectUtilities.getJavaProject((IProject)proj);
        boolean deployablesFound = false;
        try {
            IClasspathEntry[] current = jproj.getRawClasspath();
            ArrayList<IClasspathEntry> updatedList = new ArrayList<IClasspathEntry>();
            IPath sourcePath = null;
            int i = 0;
            while (i < current.length) {
                IClasspathEntry entry = current[i];
                if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null && entry.getOutputLocation().toString().indexOf(OLD_DEPLOYABLES_PATH) != -1) {
                    sourcePath = entry.getPath();
                    updatedList.add(JavaCore.newSourceEntry((IPath)sourcePath));
                    deployablesFound = true;
                } else {
                    updatedList.add(entry);
                }
                ++i;
            }
            if (deployablesFound) {
                IClasspathEntry[] updated = updatedList.toArray(new IClasspathEntry[updatedList.size()]);
                jproj.setRawClasspath(updated, null);
                jproj.save(null, true);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void removeOldWebContainerIfNecessary(IProject webProj) {
        IJavaProject jproj = JemProjectUtilities.getJavaProject((IProject)webProj);
        try {
            IClasspathEntry[] current = jproj.getRawClasspath();
            ArrayList<IClasspathEntry> updatedList = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < current.length) {
                IClasspathEntry entry = current[i];
                if (entry.getPath().toString().indexOf(WEB_LIB_CONTAINER) == -1 && entry.getPath().toString().indexOf(WEB_LIB_PATH) == -1) {
                    updatedList.add(entry);
                }
                ++i;
            }
            IClasspathEntry[] updated = updatedList.toArray(new IClasspathEntry[updatedList.size()]);
            jproj.setRawClasspath(updated, null);
            jproj.save(null, true);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected IRuntime getRuntimeByID(String id) {
        IRuntime[] targets = ServerUtil.getRuntimes((String)"", (String)"");
        int i = 0;
        while (i < targets.length) {
            IRuntime target = targets[i];
            if (id.equals(target.getId())) {
                return target;
            }
            ++i;
        }
        return null;
    }

    protected IDataModel setupEjbInstallAction(IProject aProject, String ejbVersion, boolean existing) {
        IDataModel ejbFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetInstallDataModelProvider());
        ejbFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        ejbFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)ejbVersion);
        ejbFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        ejbFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        if (!existing) {
            ejbFacetInstallDataModel.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent"));
        }
        return ejbFacetInstallDataModel;
    }

    protected IDataModel setupWebInstallAction(IProject aProject, String specVersion) {
        IDataModel webFacetInstallDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProject.getName());
        webFacetInstallDataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)specVersion);
        webFacetInstallDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        webFacetInstallDataModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", null);
        return webFacetInstallDataModel;
    }
}

