/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.internal.ClasspathTableManager;
import org.eclipse.jst.j2ee.internal.IClasspathTableOwner;
import org.eclipse.jst.j2ee.internal.IJ2EEDependenciesControl;
import org.eclipse.jst.j2ee.internal.J2EEDependenciesPage;
import org.eclipse.jst.j2ee.internal.ManifestErrorPrompter;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.UpdateManifestOperation;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.listeners.IValidateEditListener;
import org.eclipse.jst.j2ee.internal.listeners.ValidateEditListener;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;

public class JARDependencyPropertiesPage
implements IJ2EEDependenciesControl,
IClasspathTableOwner,
Listener,
ClasspathModelListener,
IElementChangedListener {
    protected final IProject project;
    protected final J2EEDependenciesPage propPage;
    protected IOException caughtManifestException;
    protected boolean isDirty;
    protected Text classPathText;
    protected Text componentNameText;
    protected ClasspathModel model;
    protected CCombo availableAppsCombo;
    protected ClasspathTableManager tableManager;
    protected IValidateEditListener validateEditListener;
    protected Label manifestLabel;
    protected Label enterpriseApplicationLabel;
    protected Label availableDependentJars;
    private final Display display;
    private boolean isDisposed = false;

    public JARDependencyPropertiesPage(IProject project, J2EEDependenciesPage page) {
        J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
        this.project = project;
        this.propPage = page;
        this.display = this.propPage.getShell().getDisplay();
    }

    protected void initialize() {
        this.model = new ClasspathModel(null);
        this.model.setProject(this.project);
        if (this.model.getComponent() != null) {
            this.model.addListener((ClasspathModelListener)this);
            this.updateModelManifest();
            this.initializeValidateEditListener();
        }
    }

    public void dispose() {
        this.isDisposed = true;
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        if (this.model.earArtifactEdit != null) {
            this.model.earArtifactEdit.dispose();
            this.model.earArtifactEdit = null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateModelManifest() {
        void var1_4;
        if (JemProjectUtilities.isBinaryProject((IProject)this.project) || this.model.getAvailableEARComponents().length == 0) {
            return;
        }
        Object var1_1 = null;
        IFile manifestFile = null;
        if (this.project != null) {
            IProject iProject = this.project;
        } else {
            IContainer iContainer = JemProjectUtilities.getSourceFolderOrFirst((IProject)this.project, null);
        }
        if (var1_4 != null) {
            manifestFile = var1_4.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        }
        if (manifestFile == null || !manifestFile.exists()) {
            return;
        }
        InputStream in = null;
        try {
            in = manifestFile.getContents();
            ArchiveManifestImpl mf = new ArchiveManifestImpl(new Manifest(in));
            this.model.primSetManifest((ArchiveManifest)mf);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
            this.model.primSetManifest((ArchiveManifest)new ArchiveManifestImpl());
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iox) {
            try {
                Logger.getLogger().logError((Throwable)iox);
                this.model.primSetManifest((ArchiveManifest)new ArchiveManifestImpl());
                this.caughtManifestException = iox;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected void initializeValidateEditListener() {
        this.validateEditListener = new ValidateEditListener(null, (ResourceStateValidator)this.model);
        this.validateEditListener.setShell(this.propPage.getShell());
    }

    public void setVisible(boolean visible) {
        if (visible && this.caughtManifestException != null && !this.model.isDirty()) {
            ManifestErrorPrompter.showManifestException(this.propPage.getShell(), ERROR_READING_MANIFEST_DIALOG_MESSAGE_PROP_PAGE, false, this.caughtManifestException);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() == 1 && this.classpathChanged(event.getDelta()) && !this.isDisposed) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (!JARDependencyPropertiesPage.this.isDisposed) {
                        JARDependencyPropertiesPage.this.handleClasspathChange();
                    }
                }
            });
        }
    }

    protected void handleClasspathChange() {
        this.model.resetClassPathSelection();
        this.refresh();
    }

    private boolean classpathChanged(IJavaElementDelta delta) {
        block7: {
            IJavaProject jproject;
            IProject eventProject;
            IJavaElement element;
            int flags;
            block8: {
                int kind = delta.getKind();
                if (kind != 4) break block7;
                flags = delta.getFlags();
                element = delta.getElement();
                if (!(element instanceof IJavaModel)) break block8;
                if ((flags & 8) != 8) break block7;
                IJavaElementDelta[] children = delta.getChangedChildren();
                int i = 0;
                while (i < children.length) {
                    if (this.classpathChanged(children[i])) {
                        return true;
                    }
                    ++i;
                }
                break block7;
            }
            if (element instanceof IJavaProject && (eventProject = (jproject = (IJavaProject)element).getProject()).equals((Object)this.project)) {
                if ((flags & 0x20000) != 0) {
                    return true;
                }
                IResourceDelta[] deltas = delta.getResourceDeltas();
                if (deltas != null) {
                    int i = 0;
                    while (i < deltas.length) {
                        if (deltas[i].getProjectRelativePath().toString().equals(".classpath")) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    public Composite createContents(Composite parent) {
        this.initialize();
        Composite composite = this.createBasicComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.model.getComponent() != null) {
            if (!this.isValidComponent()) {
                return composite;
            }
            J2EEDependenciesPage.createDescriptionComposite(composite, ManifestUIResourceHandler.J2EE_Modules_Desc);
            this.createProjectLabelsGroup(composite);
            this.createListGroup(composite);
            this.createTextGroup(composite);
            this.refresh();
        }
        Dialog.applyDialogFont((Control)parent);
        this.postCreateContents();
        return composite;
    }

    protected void postCreateContents() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    protected Composite createBasicComposite(Composite comp) {
        Composite composite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected boolean isValidComponent() {
        if (J2EEProjectUtilities.isEARProject((IProject)this.project)) {
            this.propPage.setErrorMessage(ManifestUIResourceHandler.EAR_Module_Dep_Error);
            return false;
        }
        if (J2EEProjectUtilities.isStandaloneProject((IProject)this.model.getComponent().getProject())) {
            this.propPage.setErrorMessage(ClasspathModel.NO_EAR_MESSAGE);
            return false;
        }
        return true;
    }

    protected void createProjectLabelsGroup(Composite parent) {
        Composite labelsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labelsGroup.setLayout((Layout)layout);
        labelsGroup.setLayoutData((Object)new GridData(768));
        this.createEnterpriseAppsControls(labelsGroup);
    }

    private void createEnterpriseAppsControls(Composite labelsGroup) {
        this.enterpriseApplicationLabel = new Label(labelsGroup, 0);
        this.enterpriseApplicationLabel.setText(ManifestUIResourceHandler.EAR_Project_Name__UI__UI_);
        this.availableAppsCombo = new CCombo(labelsGroup, 2056);
        GridData gd = new GridData(768);
        this.availableAppsCombo.setLayoutData((Object)gd);
        this.availableAppsCombo.addListener(13, (Listener)this);
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableDependentJars = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableDependentJars.setText(ManifestUIResourceHandler.Available_dependent_JARs__UI_);
        this.availableDependentJars.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    public Group createGroup(Composite parent) {
        return new Group(parent, 0);
    }

    protected void createTextGroup(Composite parent) {
        Composite textGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        textGroup.setLayout((Layout)layout);
        textGroup.setLayoutData((Object)new GridData(1808));
        this.createClassPathText(textGroup);
    }

    protected void createClassPathText(Composite textGroup) {
        this.manifestLabel = new Label(textGroup, 0);
        this.manifestLabel.setText(ManifestUIResourceHandler.Manifest_Class_Path__UI_);
        this.classPathText = new Text(textGroup, 2626);
        GridData gData = new GridData(1808);
        gData.widthHint = 400;
        gData.heightHint = 100;
        this.classPathText.setLayoutData((Object)gData);
        this.classPathText.setEditable(false);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.tableManager = new ClasspathTableManager(this, this.model, this.validateEditListener);
        this.tableManager.setReadOnly(this.isReadOnly());
        this.tableManager.fillComposite(composite);
    }

    public CheckboxTableViewer createAvailableJARsViewer(Composite parent) {
        int flags = 67618;
        Table table = new Table(parent, flags);
        CheckboxTableViewer availableJARsViewer = new CheckboxTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(ManifestUIResourceHandler.JAR_Module_UI_);
        fileNameColumn.setResizable(true);
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(ManifestUIResourceHandler.Project_UI_);
        projectColumn.setResizable(true);
        tableLayout.layout((Composite)table, true);
        return availableJARsViewer;
    }

    public Composite createButtonColumnComposite(Composite parent) {
        Composite buttonColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonColumn.setLayout((Layout)layout);
        GridData data = new GridData(258);
        buttonColumn.setLayoutData((Object)data);
        return buttonColumn;
    }

    public Button primCreatePushButton(String label, Composite buttonColumn) {
        Button aButton = new Button(buttonColumn, 8);
        aButton.setText(label);
        return aButton;
    }

    public Button primCreateRadioButton(String label, Composite parent) {
        Button aButton = new Button(parent, 16);
        aButton.setText(label);
        return aButton;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.availableAppsCombo) {
            this.availableAppsSelected(event);
        }
    }

    protected void availableAppsSelected(Event event) {
        int index = this.availableAppsCombo.getSelectionIndex();
        this.model.selectEAR(index);
    }

    protected void populateApps() {
        IVirtualComponent[] components = this.model.getAvailableEARComponents();
        String[] values = new String[components.length];
        int i = 0;
        while (i < components.length) {
            values[i] = components[i].getProject().getName();
            ++i;
        }
        if (this.availableAppsCombo != null) {
            this.availableAppsCombo.setItems(values);
            IVirtualComponent selected = this.model.getSelectedEARComponent();
            if (selected != null) {
                int index = Arrays.asList(components).indexOf(selected);
                this.availableAppsCombo.select(index);
            } else {
                this.availableAppsCombo.clearSelection();
            }
        }
    }

    protected void refresh() {
        this.populateApps();
        if (this.tableManager != null) {
            this.tableManager.refresh();
        }
        this.refreshText();
    }

    public void refreshText() {
        ClassPathSelection sel = this.model.getClassPathSelection();
        if (sel != null && this.classPathText != null) {
            this.classPathText.setText(sel == null ? "" : sel.toString());
        }
    }

    public void modelChanged(ClasspathModelEvent evt) {
        if (evt.getEventType() == 1) {
            this.isDirty = true;
            this.refreshText();
        } else if (evt.getEventType() == 2) {
            this.tableManager.refresh();
        }
    }

    public void performDefaults() {
        this.model.resetClassPathSelection();
        this.refresh();
        this.isDirty = false;
        this.model.dispose();
    }

    public boolean performCancel() {
        this.model.dispose();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean performOk() {
        if (!this.isDirty) {
            return true;
        }
        composed = new WorkspaceModifyComposedOperation((IRunnableWithProgress)this.createManifestOperation());
        composed.addRunnable(this.createClasspathAttributeUpdateOperation(this.model.getClassPathSelection(), false));
        try {
            try {
                new ProgressMonitorDialog(this.propPage.getShell()).run(true, true, (IRunnableWithProgress)composed);
            }
            catch (InvocationTargetException ex) {
                msg = title = ManifestUIResourceHandler.An_internal_error_occurred_ERROR_;
                if (ex.getTargetException() != null && ex.getTargetException().getMessage() != null) {
                    msg = ex.getTargetException().getMessage();
                }
                MessageDialog.openError((Shell)this.propPage.getShell(), (String)title, (String)msg);
                Logger.getLogger().logError((Throwable)ex);
lbl17:
                // 2 sources

                while (true) {
                    this.model.dispose();
                    return false;
                }
            }
            catch (InterruptedException v0) {
                ** continue;
            }
        }
        finally {
            this.model.dispose();
        }
        this.isDirty = false;
        return true;
    }

    List getUnSelectedClassPathElementsForJ2EEDependency() {
        List unselectedForJ2EE = this.getUnSelectedClassPathSelection().getClasspathElements();
        ArrayList<ClasspathElement> unselected = new ArrayList<ClasspathElement>();
        if (this.model != null && this.model.getClassPathSelectionForWLPs() != null) {
            List wlpSelected = this.model.getClassPathSelectionForWLPs().getSelectedClasspathElements();
            for (ClasspathElement element : unselectedForJ2EE) {
                Iterator wlpIterator = wlpSelected.iterator();
                boolean found = false;
                while (wlpIterator.hasNext()) {
                    ClasspathElement wlpElement = (ClasspathElement)wlpIterator.next();
                    String text = element.getText();
                    int index = text.indexOf(".jar");
                    if (index == -1 || !(text = text.substring(0, index)).equals(wlpElement.getText())) continue;
                    found = true;
                    break;
                }
                if (found || unselected.contains(element)) continue;
                unselected.add(element);
            }
        }
        return unselected;
    }

    List getUnSelectedClassPathElementsForWebDependency() {
        List unselectedForWLP = this.getUnSelectedClassPathSelectionForWLPs().getClasspathElements();
        List<ClasspathElement> unselected = new ArrayList();
        if (this.model != null && this.model.getClassPathSelection() != null) {
            List j2eeSelected = this.model.getClassPathSelection().getSelectedClasspathElements();
            for (ClasspathElement element : unselectedForWLP) {
                Iterator j2eeIterator = j2eeSelected.iterator();
                boolean found = false;
                while (j2eeIterator.hasNext()) {
                    ClasspathElement j2eeElement = (ClasspathElement)j2eeIterator.next();
                    String text = j2eeElement.getText();
                    int index = text.indexOf(".jar");
                    if (index == -1) continue;
                    text = text.substring(0, index);
                    if (!element.getText().equals(text)) continue;
                    found = true;
                    break;
                }
                if (found || unselected.contains(element)) continue;
                unselected.add(element);
            }
        } else {
            unselected = unselectedForWLP;
        }
        return unselected;
    }

    protected WorkspaceModifyComposedOperation createJ2EEComponentDependencyOperations() {
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        List selected = this.getSelectedClassPathSelection().getClasspathElements();
        List unselected = this.getUnSelectedClassPathElementsForJ2EEDependency();
        ArrayList<IVirtualComponent> targetComponentsHandles = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            IVirtualComponent component = element.getComponent();
            if (component != null) {
                targetComponentsHandles.add(component);
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            IProject elementProject = element.getProject();
            if (elementProject != null) {
                if (ModuleCoreNature.isFlexibleProject((IProject)elementProject)) {
                    IVirtualComponent targetComp = ComponentCore.createComponent((IProject)elementProject);
                    targetComponentsHandles.add(targetComp);
                }
            } else {
                URI archiveURI = element.getArchiveURI();
                if (archiveURI != null && !archiveURI.equals((Object)"")) {
                    IVirtualReference ref;
                    String name = "";
                    try {
                        String type = ModuleURIUtil.getArchiveType((URI)archiveURI);
                        String tmpname = ModuleURIUtil.getArchiveName((URI)archiveURI);
                        name = String.valueOf(type) + '/' + tmpname;
                    }
                    catch (UnresolveableURIException e) {
                        Logger.getLogger().logError(e.getMessage());
                    }
                    if (!name.equals("") && (ref = this.model.getComponent().getReference(name)) != null) {
                        IVirtualComponent referenced = ref.getReferencedComponent();
                        targetComponentsHandles.add(referenced);
                    }
                }
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        return composedOp;
    }

    protected WorkspaceModifyComposedOperation createComponentDependencyOperations() {
        IVirtualComponent targetComp;
        IProject elementProject;
        ClasspathElement element;
        WorkspaceModifyComposedOperation composedOp = null;
        ClassPathSelection selectedWLPs = this.getSelectedClassPathSelectionForWLPs();
        List selected = selectedWLPs.getClasspathElements();
        List unselected = this.getUnSelectedClassPathElementsForWebDependency();
        ArrayList<IVirtualComponent> targetComponentsHandles = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < selected.size()) {
            element = (ClasspathElement)selected.get(i);
            if (!element.isClasspathDependency() && !element.isClasspathEntry() && (elementProject = element.getProject()) != null) {
                targetComp = ComponentCore.createComponent((IProject)elementProject);
                targetComponentsHandles.add(targetComp);
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            composedOp = new WorkspaceModifyComposedOperation();
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.createWLPReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        targetComponentsHandles = new ArrayList();
        i = 0;
        while (i < unselected.size()) {
            element = (ClasspathElement)unselected.get(i);
            if (!element.isClasspathDependency() && !element.isClasspathEntry()) {
                elementProject = element.getProject();
                if (elementProject != null) {
                    if (ModuleCoreNature.isFlexibleProject((IProject)elementProject)) {
                        targetComp = ComponentCore.createComponent((IProject)elementProject);
                        targetComponentsHandles.add(targetComp);
                    }
                } else {
                    URI archiveURI = element.getArchiveURI();
                    if (archiveURI != null && !archiveURI.equals((Object)"")) {
                        String name = "";
                        try {
                            String type = ModuleURIUtil.getArchiveType((URI)archiveURI);
                            String tmpname = ModuleURIUtil.getArchiveName((URI)archiveURI);
                            name = String.valueOf(type) + '/' + tmpname;
                        }
                        catch (UnresolveableURIException e) {
                            Logger.getLogger().logError(e.getMessage());
                        }
                        if (!name.equals("")) {
                            IVirtualReference ref = this.model.getComponent().getReference(name);
                            IVirtualComponent referenced = ref.getReferencedComponent();
                            targetComponentsHandles.add(referenced);
                        }
                    }
                }
            }
            ++i;
        }
        if (!targetComponentsHandles.isEmpty()) {
            if (composedOp == null) {
                composedOp = new WorkspaceModifyComposedOperation();
            }
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)ComponentUtilities.removeWLPReferenceComponentOperation((IVirtualComponent)this.model.getComponent(), targetComponentsHandles)));
        }
        if (composedOp == null) {
            composedOp = new WorkspaceModifyComposedOperation();
        }
        composedOp.addRunnable(this.createClasspathAttributeUpdateOperation(selectedWLPs, true));
        return composedOp;
    }

    protected WorkspaceModifyComposedOperation createFlexProjectOperations() {
        WorkspaceModifyComposedOperation composedOp = null;
        try {
            Object[] elements = this.tableManager.availableJARsViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                ClasspathElement element = (ClasspathElement)elements[i];
                IProject elementProject = element.getProject();
                if (elementProject != null && !elementProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    if (composedOp == null) {
                        composedOp = new WorkspaceModifyComposedOperation();
                    }
                    composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)elementProject, (boolean)false)));
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return composedOp;
    }

    protected ClassPathSelection getUnSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelectionForWLPs().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains(modelElements.get(i))) {
                selection.getClasspathElements().add(modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelection() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add(checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected ClassPathSelection getUnSelectedClassPathSelection() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        List modelElements = this.model.getClassPathSelection().getClasspathElements();
        int i = 0;
        while (i < modelElements.size()) {
            List<Object> checkedElementsList = Arrays.asList(checkedElements);
            if (!checkedElementsList.contains(modelElements.get(i))) {
                selection.getClasspathElements().add(modelElements.get(i));
            }
            ++i;
        }
        return selection;
    }

    private ClassPathSelection getSelectedClassPathSelectionForWLPs() {
        ClassPathSelection selection = new ClassPathSelection();
        Object[] checkedElements = this.tableManager.availableJARsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            selection.getClasspathElements().add(checkedElements[i]);
            ++i;
        }
        return selection;
    }

    protected UpdateManifestOperation createManifestOperation() {
        return new UpdateManifestOperation(this.project.getName(), this.model.getClassPathSelection().toString(), true);
    }

    protected IRunnableWithProgress createClasspathAttributeUpdateOperation(ClassPathSelection selection, boolean isWebApp) {
        HashMap<IClasspathEntry, IPath> entriesToRuntimePath = new HashMap<IClasspathEntry, IPath>();
        List selectedElements = selection.getSelectedClasspathElements();
        int i = 0;
        while (i < selectedElements.size()) {
            ClasspathElement element = (ClasspathElement)selectedElements.get(i);
            if (element.isClasspathEntry() && element.isSelected()) {
                IClasspathEntry entry = element.getClasspathEntry();
                IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute((IClasspathEntry)entry);
                IPath runtimePath = ClasspathDependencyUtil.getRuntimePath((IClasspathAttribute)attrib, (boolean)isWebApp, (boolean)ClasspathDependencyUtil.isClassFolderEntry((IClasspathEntry)entry));
                entriesToRuntimePath.put(entry, runtimePath);
            }
            ++i;
        }
        IDataModelOperation op = UpdateClasspathAttributeUtil.createUpdateDependencyAttributesOperation((String)this.project.getName(), entriesToRuntimePath);
        return WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op);
    }

    protected boolean isReadOnly() {
        return JemProjectUtilities.isBinaryProject((IProject)this.project);
    }
}

