/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.internal.ClasspathTableManager;
import org.eclipse.jst.j2ee.internal.IClasspathTableOwner;
import org.eclipse.jst.j2ee.internal.J2EEDependenciesPage;
import org.eclipse.jst.j2ee.internal.JARDependencyPropertiesPage;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;

public class WebLibDependencyPropertiesPage
extends JARDependencyPropertiesPage
implements IClasspathTableOwner,
Listener,
ClasspathModelListener {
    public WebLibDependencyPropertiesPage(IProject project, J2EEDependenciesPage page) {
        super(project, page);
    }

    public Composite createContents(Composite parent) {
        this.initialize();
        Composite composite = this.createBasicComposite(parent);
        if (this.model.getComponent() != null) {
            if (!this.isValidWebModule()) {
                return composite;
            }
            J2EEDependenciesPage.createDescriptionComposite(composite, ManifestUIResourceHandler.Web_Libraries_Desc);
            this.createListGroup(composite);
            this.handleWLPSupport();
            this.model.setWLPModel(true);
            this.setEnablement();
        }
        Dialog.applyDialogFont((Control)parent);
        this.postCreateContents();
        return composite;
    }

    protected void createProjectLabelsGroup(Composite parent) {
        Composite labelsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        labelsGroup.setLayout((Layout)layout);
        labelsGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(labelsGroup, 0);
        label.setText(ManifestUIResourceHandler.Project_name__UI_);
        this.componentNameText = new Text(labelsGroup, 2048);
        GridData data = new GridData(768);
        this.componentNameText.setEditable(false);
        this.componentNameText.setLayoutData((Object)data);
        this.componentNameText.setText(this.project.getName());
    }

    protected void createListGroup(Composite parent) {
        Composite listGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listGroup.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalIndent = 5;
        listGroup.setLayoutData((Object)gData);
        this.availableDependentJars = new Label(listGroup, 0);
        gData = new GridData(272);
        this.availableDependentJars.setText(ManifestUIResourceHandler.Available_dependent_JARs__UI_);
        this.availableDependentJars.setLayoutData((Object)gData);
        this.createTableComposite(listGroup);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.tableManager = new ClasspathTableManager(this, this.model, this.validateEditListener);
        this.tableManager.setReadOnly(this.isReadOnly());
        this.tableManager.fillWLPComposite(composite);
    }

    protected boolean isValidWebModule() {
        if (!J2EEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
            this.propPage.setErrorMessage(ManifestUIResourceHandler.Web_Lib_Error);
            return false;
        }
        return true;
    }

    protected void setEnablement() {
        if (this.tableManager.availableJARsViewer.getTable().getItems().length == 0) {
            this.tableManager.selectAllButton.setEnabled(false);
            this.tableManager.deselectAllButton.setEnabled(false);
        } else {
            this.tableManager.selectAllButton.setEnabled(true);
            this.tableManager.deselectAllButton.setEnabled(true);
        }
    }

    private void handleWLPSupport() {
        this.tableManager.setWLPEntry(true);
        this.availableDependentJars.setText(ManifestUIResourceHandler.WEB_LIB_LIST_DESCRIPTION);
        this.tableManager.refresh();
    }

    protected void handleClasspathChange() {
        this.model.resetClassPathSelectionForWLPs();
        super.handleClasspathChange();
        this.setEnablement();
    }

    public boolean performOk() {
        if (this.model.getComponent() == null || !this.isValidWebModule()) {
            return true;
        }
        if (!this.isDirty) {
            return true;
        }
        try {
            boolean createdFlexProjects = this.runWLPOp(this.createFlexProjectOperations());
            boolean createdComponentDependency = false;
            if (createdFlexProjects) {
                createdComponentDependency = this.runWLPOp(this.createComponentDependencyOperations());
                this.isDirty = false;
            }
            boolean bl = createdComponentDependency;
            return bl;
        }
        finally {
            this.model.dispose();
        }
    }

    private boolean runWLPOp(WorkspaceModifyComposedOperation composed) {
        try {
            if (composed != null) {
                new ProgressMonitorDialog(this.propPage.getShell()).run(true, true, (IRunnableWithProgress)composed);
            }
        }
        catch (InvocationTargetException ex) {
            String title;
            ex.printStackTrace();
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            String msg = title = ManifestUIResourceHandler.An_internal_error_occurred_ERROR_;
            if (ex.getTargetException() != null && ex.getTargetException().getMessage() != null) {
                msg = ex.getTargetException().getMessage();
            }
            MessageDialog.openError((Shell)this.propPage.getShell(), (String)title, (String)msg);
            Logger.getLogger().logError((Throwable)ex);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void createRef(String aComponentName) {
        IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)this.model.getComponent().getProject(), (String)aComponentName);
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)this.model.getComponent(), (IVirtualComponent)archive, (IPath)new Path("/WEB-INF/lib"));
        this.model.getComponent().addReferences(new IVirtualReference[]{ref});
        ClasspathElement element = this.createClassPathElement(archive, archive.getName());
        this.model.getClassPathSelectionForWLPs().getClasspathElements().add(element);
    }

    public void handleSelectExternalJarButton() {
        IPath[] selected;
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)this.project) && (selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.propPage.getShell())) != null) {
            String type = "lib/";
            int i = 0;
            while (i < selected.length) {
                this.createRef(String.valueOf(type) + selected[i].toString());
                ++i;
            }
            this.refresh();
        }
    }

    public void handleSelectVariableButton() {
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)this.project)) {
            Path[] existingPath = new Path[]{};
            IPath[] selected = BuildPathDialogAccess.chooseVariableEntries((Shell)this.propPage.getShell(), (IPath[])existingPath);
            if (selected != null) {
                String type = "var/";
                int i = 0;
                while (i < selected.length) {
                    IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)selected[i]);
                    File file = new File(resolvedPath.toOSString());
                    if (file.isFile() && file.exists()) {
                        this.createRef(String.valueOf(type) + selected[i].toString());
                    }
                    ++i;
                }
                this.refresh();
            }
        }
    }

    private ClasspathElement createClassPathElement(IVirtualComponent archiveComp, String unresolvedName) {
        URI uri = URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)archiveComp));
        ClasspathElement element = new ClasspathElement(uri);
        element.setValid(false);
        element.setSelected(true);
        element.setRelativeText(unresolvedName);
        element.setText(unresolvedName);
        element.setEarProject(null);
        return element;
    }

    public void handleSelectProjectJarButton() {
        IPath[] selected;
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)this.project) && (selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.propPage.getShell(), (IPath)this.project.getLocation(), (IPath[])new IPath[0])) != null) {
            String type = "lib/";
            int i = 0;
            while (i < selected.length) {
                this.createRef(String.valueOf(type) + selected[i].makeRelative().toString());
                ++i;
            }
            this.refresh();
        }
    }
}

