/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.ejb.ui.internal.plugin.EJBUIPlugin;
import org.eclipse.jst.ejb.ui.internal.wizard.AddSessionBeanWizardPage;
import org.eclipse.jst.ejb.ui.internal.wizard.IEjbWizardConstants;
import org.eclipse.jst.ejb.ui.internal.wizard.NewEnterpriseBeansWizard;
import org.eclipse.jst.ejb.ui.internal.wizard.NewSessionBeanClassWizardPage;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewSessionBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class AddSessionBeanWizard
extends NewEnterpriseBeansWizard {
    private static final String PAGE_ONE = "pageOne";
    private static final String PAGE_TWO = "pageTwo";
    private AddSessionBeanWizardPage page2;
    private NewSessionBeanClassWizardPage page1;

    public AddSessionBeanWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(IEjbWizardConstants.ADD_SESSION_BEANS_WIZARD_PAGE_TITLE);
        this.setDefaultPageImageDescriptor(this.getWizBan());
    }

    private ImageDescriptor getWizBan() {
        return EJBUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ejb.ui", (String)"icons/full/wizban/newejb_wiz_ban.gif");
    }

    public AddSessionBeanWizard() {
        this(null);
    }

    protected void doAddPages() {
        this.page1 = new NewSessionBeanClassWizardPage(this.getDataModel(), PAGE_ONE, IEjbWizardConstants.NEW_JAVA_CLASS_DESTINATION_WIZARD_PAGE_DESC, IEjbWizardConstants.ADD_SESSION_BEANS_WIZARD_PAGE_TITLE, "jst.ejb");
        this.addPage((IWizardPage)this.page1);
        this.page2 = new AddSessionBeanWizardPage(this.getDataModel(), PAGE_TWO);
        this.addPage((IWizardPage)this.page2);
    }

    protected IDataModelProvider getDefaultProvider() {
        return new NewSessionBeanClassDataModelProvider();
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
        IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
        IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
        try {
            IFile file = (IFile)javaProject.findType(className).getResource();
            this.openEditor(file);
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e);
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.getLogger().log((Throwable)e);
                    }
                }
            });
        }
    }
}

