/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.DB_Results;

public class BuildResults
extends AbstractResults {
    String date;
    boolean baseline;
    String failure;
    String comment;
    int summaryKind = -1;
    Dim[] dimensions;
    double[] average;
    double[] stddev;
    long[] count;
    double[][] values;

    BuildResults(AbstractResults parent) {
        super(parent, -1);
    }

    BuildResults(AbstractResults parent, int id) {
        super(parent, id);
        this.name = DB_Results.getBuildName(id);
        this.baseline = this.name.startsWith(parent.getPerformance().getBaselinePrefix());
    }

    void cleanValues() {
        int length = this.values.length;
        int dim_id = 0;
        while (dim_id < length) {
            int vLength = this.values[dim_id].length;
            this.average[dim_id] = 0.0;
            int i = 0;
            while (i < vLength) {
                int n = dim_id;
                this.average[n] = this.average[n] + this.values[dim_id][i];
                ++i;
            }
            int n = dim_id;
            this.average[n] = this.average[n] / (double)vLength;
            double squaredDeviations = 0.0;
            int i2 = 0;
            while (i2 < vLength) {
                double deviation = this.average[dim_id] - this.values[dim_id][i2];
                squaredDeviations += deviation * deviation;
                ++i2;
            }
            this.stddev[dim_id] = Math.sqrt(squaredDeviations / (double)(this.count[dim_id] - 1L));
            this.values[dim_id] = null;
            ++dim_id;
        }
        int i = 0;
        while (i < length) {
            if (this.values[i] != null) {
                return;
            }
            ++i;
        }
        this.values = null;
    }

    public int compareTo(Object obj) {
        if (obj instanceof BuildResults) {
            BuildResults res = (BuildResults)obj;
            return this.getDate().compareTo(res.getDate());
        }
        return -1;
    }

    public String getComment() {
        if (this.comment == null) {
            return null;
        }
        return this.comment;
    }

    long getCount(int dim_id) {
        return this.count[this.getDimIndex(dim_id)];
    }

    public String getDate() {
        if (this.date == null) {
            if (this.baseline) {
                int length = this.name.length();
                this.date = this.name.substring(length - 12, length);
            } else {
                char first = this.name.charAt(0);
                if (first == 'N' || first == 'I' || first == 'M') {
                    this.date = String.valueOf(this.name.substring(1, 9)) + this.name.substring(10, 14);
                } else {
                    int length = this.name.length() - 12;
                    int i = 0;
                    while (i <= length) {
                        try {
                            String substring = i == 0 ? this.name : this.name.substring(i);
                            DATE_FORMAT.parse(substring);
                            this.date = substring;
                            break;
                        }
                        catch (ParseException parseException) {
                            ++i;
                        }
                    }
                }
            }
        }
        return this.date;
    }

    public double getDeviation(int dim_id) {
        return this.stddev[this.getDimIndex(dim_id)];
    }

    int getDimIndex(int dim_id) {
        if (this.dimensions == null) {
            return -1;
        }
        int length = this.dimensions.length;
        int i = 0;
        while (i < length) {
            if (this.dimensions[i] == null) break;
            if (this.dimensions[i].getId() == dim_id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    double getError(int dim_id) {
        long n = this.getCount(dim_id);
        if (n == 1L) {
            return Double.NaN;
        }
        return this.getDeviation(dim_id) / Math.sqrt(n);
    }

    public String getFailure() {
        if (this.failure == null) {
            return null;
        }
        return this.failure;
    }

    public double getValue(int dim_id) {
        return this.average[this.getDimIndex(dim_id)];
    }

    public boolean isBaseline() {
        return this.baseline;
    }

    public boolean hasSummary() {
        return this.summaryKind >= 0;
    }

    public boolean hasGlobalSummary() {
        return this.summaryKind == 1;
    }

    boolean match(String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.indexOf(42) < 0 && pattern.indexOf(63) < 0) {
            pattern = String.valueOf(pattern) + "*";
        }
        StringTokenizer tokenizer = new StringTokenizer(pattern, "*?", true);
        int start = 0;
        String previous = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals("*") && !token.equals("?")) {
                if (previous.equals("*")) {
                    int idx = this.name.substring(start).indexOf(token);
                    if (idx < 0) {
                        return false;
                    }
                    start += idx;
                } else {
                    if (previous.equals("?")) {
                        ++start;
                    }
                    if (!this.name.substring(start).startsWith(token)) {
                        return false;
                    }
                }
                start += token.length();
            }
            previous = token;
        }
        if (previous.equals("*")) {
            return true;
        }
        if (previous.equals("?")) {
            return this.name.length() == start;
        }
        return this.name.endsWith(previous);
    }

    void readData(DataInputStream stream) throws IOException {
        long timeBuild = stream.readLong();
        this.date = new Long(timeBuild).toString();
        byte kind = stream.readByte();
        boolean bl = this.baseline = kind == 0;
        if (this.baseline) {
            this.name = String.valueOf(this.getPerformance().baselinePrefix) + '_' + this.date;
        } else {
            String suffix = String.valueOf(this.date.substring(0, 8)) + '-' + this.date.substring(8);
            switch (kind) {
                case 1: {
                    this.name = "N" + suffix;
                    break;
                }
                case 2: {
                    this.name = "I" + suffix;
                    break;
                }
                case 3: {
                    this.name = "M" + suffix;
                    break;
                }
                default: {
                    this.name = stream.readUTF();
                }
            }
        }
        int length = stream.readInt();
        this.dimensions = new Dim[length];
        this.average = new double[length];
        this.stddev = new double[length];
        this.count = new long[length];
        int i = 0;
        while (i < length) {
            this.dimensions[i] = BuildResults.getDimension(stream.readInt());
            this.average[i] = stream.readLong();
            this.count[i] = stream.readLong();
            this.stddev[i] = stream.readDouble();
            ++i;
        }
        this.id = DB_Results.getBuildId(this.name);
    }

    void setSummary(int kind, String comment) {
        this.comment = comment;
        this.summaryKind = kind;
    }

    void setFailure(String failure) {
        this.failure = failure;
    }

    void setValue(int dim_id, int step, long value) {
        int i;
        int length = SUPPORTED_DIMS.length;
        Dim dimension = BuildResults.getDimension(dim_id);
        int idx = 0;
        if (this.dimensions == null) {
            this.dimensions = new Dim[length];
            this.average = new double[length];
            this.stddev = new double[length];
            this.count = new long[length];
            this.dimensions[0] = dimension;
            i = 0;
            while (i < length) {
                this.average[i] = -1.0;
                ++i;
            }
        } else {
            length = this.dimensions.length;
            i = 0;
            while (i < length) {
                if (this.dimensions[i] == null) {
                    this.dimensions[i] = dimension;
                    idx = i;
                    break;
                }
                if (this.dimensions[i].getId() == dim_id) {
                    idx = i;
                    break;
                }
                ++i;
            }
        }
        switch (step) {
            case -3: {
                if (this.average[idx] != -1.0) {
                    if (this.values == null) {
                        this.values = new double[length][];
                        this.values[idx] = new double[2];
                        this.values[idx][0] = this.average[idx];
                        this.values[idx][1] = value;
                        this.average[idx] = -1.0;
                        break;
                    }
                    if (this.values[idx] != null) break;
                    this.values[idx] = new double[2];
                    this.values[idx][0] = this.average[idx];
                    this.values[idx][1] = value;
                    this.average[idx] = -1.0;
                    break;
                }
                if (this.values != null && this.values[idx] != null) {
                    int vLength = this.values[idx].length;
                    this.values[idx] = new double[vLength + 1];
                    System.arraycopy(this.values[idx], 0, this.values[idx], 0, vLength);
                    this.values[idx][vLength] = value;
                    break;
                }
                this.average[idx] = value;
                break;
            }
            case -5: {
                int n = idx;
                this.stddev[n] = this.stddev[n] + Double.longBitsToDouble(value);
                break;
            }
            case -4: {
                int n = idx;
                this.count[n] = this.count[n] + value;
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.name);
        buffer.append(": ");
        int length = this.dimensions.length;
        int i = 0;
        while (i < length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('[');
            buffer.append(this.dimensions[i].getId());
            buffer.append("]=");
            buffer.append(this.average[i]);
            buffer.append('/');
            buffer.append(this.count[i]);
            buffer.append('/');
            buffer.append((double)Math.round(this.stddev[i] * 1000.0) / 1000.0);
            ++i;
        }
        return buffer.toString();
    }

    void write(DataOutputStream stream) throws IOException {
        long timeBuild = -1L;
        try {
            timeBuild = Long.parseLong(this.getDate());
        }
        catch (NumberFormatException numberFormatException) {}
        stream.writeLong(timeBuild);
        int kind = 0;
        if (!this.baseline) {
            switch (this.name.charAt(0)) {
                case 'N': {
                    kind = 1;
                    break;
                }
                case 'I': {
                    kind = 2;
                    break;
                }
                case 'M': {
                    kind = 3;
                    break;
                }
                default: {
                    kind = 4;
                }
            }
        }
        stream.writeByte(kind);
        if (kind == 4) {
            stream.writeUTF(this.name);
        }
        int length = this.dimensions == null ? 0 : this.dimensions.length;
        stream.writeInt(length);
        int i = 0;
        while (i < length) {
            stream.writeInt(this.dimensions[i].getId());
            stream.writeLong((long)this.average[i]);
            stream.writeLong(this.count[i]);
            stream.writeDouble(this.stddev[i]);
            ++i;
        }
    }
}

