/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.ConfigResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class ComponentResults
extends AbstractResults {
    public ComponentResults(AbstractResults parent, String name) {
        super(parent, name);
        this.print = parent.print;
    }

    ComponentResults getComponent() {
        return this;
    }

    private ScenarioResults getScenarioResults(List scenarios, int searchedId) {
        int size = scenarios.size();
        int i = 0;
        while (i < size) {
            ScenarioResults scenarioResults = (ScenarioResults)scenarios.get(i);
            if (scenarioResults.id == searchedId) {
                return scenarioResults;
            }
            ++i;
        }
        return null;
    }

    public List getSummaryScenarios(boolean global, String config) {
        int size = this.size();
        ArrayList<ScenarioResults> scenarios = new ArrayList<ScenarioResults>(size);
        int i = 0;
        while (i < size) {
            ScenarioResults scenarioResults = (ScenarioResults)this.children.get(i);
            ConfigResults configResults = scenarioResults.getConfigResults(config);
            if (configResults != null) {
                BuildResults buildResults = configResults.getCurrentBuildResults();
                if (global && buildResults.summaryKind == 1 || !global && buildResults.summaryKind >= 0) {
                    scenarios.add(scenarioResults);
                }
            }
            ++i;
        }
        return scenarios;
    }

    void read(List scenarios, File dataDir) {
        this.println("Component '" + this.name + "':");
        long start = System.currentTimeMillis();
        boolean dirty = false;
        if (dataDir != null) {
            try {
                dirty = this.readData(dataDir, scenarios);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int size = scenarios.size();
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < size) {
            ScenarioResults scenarioResults = (ScenarioResults)scenarios.get(i);
            if (scenarioResults.parent == null) {
                scenarioResults.parent = this;
                scenarioResults.print = this.print;
                scenarioResults.read();
                dirty = true;
                this.addChild(scenarioResults, true);
            }
            if (dataDir != null && dirty && System.currentTimeMillis() - time > 300000L) {
                this.writeData(dataDir);
                time = System.currentTimeMillis();
                dirty = false;
            }
            ++i;
        }
        if (dataDir != null && dirty) {
            this.writeData(dataDir);
        }
        this.printGlobalTime(start);
    }

    boolean readData(File dir, List scenarios) throws IOException {
        if (!dir.exists()) {
            return true;
        }
        File dataFile = new File(dir, String.valueOf(this.getName()) + ".dat");
        if (!dataFile.exists()) {
            return true;
        }
        DB_Results.queryAllVariations(this.getPerformance().getConfigurationsPattern());
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
        boolean valid = false;
        boolean dirty = false;
        int size = 0;
        try {
            long time = System.currentTimeMillis();
            String lastBuildName = stream.readUTF();
            size = stream.readInt();
            int i = 0;
            while (i < size) {
                int scenario_id = stream.readInt();
                ScenarioResults scenarioResults = this.getScenarioResults(scenarios, scenario_id);
                if (scenarioResults != null) {
                    scenarioResults.parent = this;
                    scenarioResults.print = this.print;
                    if (scenarioResults.readData(stream, lastBuildName)) {
                        dirty = true;
                    }
                    this.addChild(scenarioResults, true);
                }
                if (dirty && System.currentTimeMillis() - time > 300000L) {
                    this.writeData(dir);
                    time = System.currentTimeMillis();
                    dirty = false;
                }
                ++i;
            }
            valid = true;
        }
        finally {
            stream.close();
            if (valid) {
                this.println("\t\t=> " + size + " scenarios data were read from file " + dataFile);
            } else {
                dataFile.delete();
                this.println("\t\t=> deleted file " + dataFile + " as it contained invalid data!!!");
            }
        }
        return dirty;
    }

    public void writeData(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("can't create directory " + dir);
        }
        File tmpFile = new File(dir, String.valueOf(this.getName()) + ".tmp");
        File logFile = new File(dir, String.valueOf(this.getName()) + ".dat");
        try {
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
            int size = this.children.size();
            stream.writeUTF(this.getPerformance().getName());
            stream.writeInt(size);
            int i = 0;
            while (i < size) {
                ScenarioResults scenarioResults = (ScenarioResults)this.children.get(i);
                scenarioResults.write(stream);
                ++i;
            }
            stream.close();
            if (logFile.exists()) {
                logFile.delete();
            }
            tmpFile.renameTo(logFile);
            this.println("\t\t=> extracted data written in file " + logFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("can't create output file" + tmpFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

