/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.db.SQL;

public class SQL_Results
extends SQL {
    private PreparedStatement queryBuildScenarios;
    private PreparedStatement queryScenarioFailures;
    private PreparedStatement queryScenarioSummaries;
    private PreparedStatement queryAllComments;
    private PreparedStatement queryScenariosBuilds;
    private PreparedStatement queryScenarioDataPoints;
    private PreparedStatement queryScenarioTimestampDataPoints;
    private PreparedStatement queryDimScalars;
    private PreparedStatement queryAllVariations;

    SQL_Results(Connection con) throws SQLException {
        super(con);
    }

    protected void dispose() throws SQLException {
        super.dispose();
        if (this.queryBuildScenarios != null) {
            this.queryBuildScenarios.close();
        }
        if (this.queryScenarioFailures != null) {
            this.queryScenarioFailures.close();
        }
        if (this.queryScenarioSummaries != null) {
            this.queryScenarioSummaries.close();
        }
        if (this.queryAllComments != null) {
            this.queryAllComments.close();
        }
        if (this.queryScenariosBuilds != null) {
            this.queryScenariosBuilds.close();
        }
        if (this.queryScenarioDataPoints != null) {
            this.queryScenarioDataPoints.close();
        }
        if (this.queryDimScalars != null) {
            this.queryDimScalars.close();
        }
        if (this.queryAllVariations != null) {
            this.queryAllVariations.close();
        }
    }

    ResultSet queryAllComments() throws SQLException {
        if (this.queryAllComments == null) {
            this.queryAllComments = this.fConnection.prepareStatement("select ID, KIND, TEXT from COMMENT");
        }
        return this.queryAllComments.executeQuery();
    }

    ResultSet queryAllVariations(String configPattern) throws SQLException {
        System.currentTimeMillis();
        if (this.queryAllVariations == null) {
            this.queryAllVariations = this.fConnection.prepareStatement("select KEYVALPAIRS from VARIATION where KEYVALPAIRS like ? order by KEYVALPAIRS");
        }
        this.queryAllVariations.setString(1, "%" + configPattern + "%");
        ResultSet resultSet = this.queryAllVariations.executeQuery();
        return resultSet;
    }

    ResultSet queryBuildScenarios(String scenarioPattern, String buildName) throws SQLException {
        if (this.queryBuildScenarios == null) {
            String statement = "select distinct SCENARIO.ID, SCENARIO.NAME , SCENARIO.SHORT_NAME from SCENARIO, SAMPLE, VARIATION where SAMPLE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SAMPLE.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME LIKE ? order by SCENARIO.NAME";
            this.queryBuildScenarios = this.fConnection.prepareStatement(statement);
        }
        this.queryBuildScenarios.setString(1, "|build=" + buildName + '%');
        this.queryBuildScenarios.setString(2, scenarioPattern);
        return this.queryBuildScenarios.executeQuery();
    }

    ResultSet queryDimScalars(int datapointId) throws SQLException {
        if (this.queryDimScalars == null) {
            this.queryDimScalars = this.fConnection.prepareStatement("select DIM_ID, VALUE from SCALAR where DATAPOINT_ID = ? and (DIM_ID = " + InternalDimensions.CPU_TIME.getId() + " or DIM_ID = " + InternalDimensions.ELAPSED_PROCESS.getId() + ") " + "order by DIM_ID");
        }
        this.queryDimScalars.setInt(1, datapointId);
        return this.queryDimScalars.executeQuery();
    }

    ResultSet queryScenarioTimestampDataPoints(String config, int scenarioID, String lastBuildName, long lastBuildTime) throws SQLException {
        if (this.queryScenarioTimestampDataPoints == null) {
            String statement = "select DATAPOINT.ID, DATAPOINT.STEP, VARIATION.KEYVALPAIRS from SAMPLE, DATAPOINT, VARIATION where SAMPLE.SCENARIO_ID = ? and DATAPOINT.SAMPLE_ID = SAMPLE.ID and SAMPLE.STARTTIME > ? and SAMPLE.VARIATION_ID = VARIATION.ID ORDER BY DATAPOINT.ID, DATAPOINT.STEP";
            this.queryScenarioTimestampDataPoints = this.fConnection.prepareStatement(statement);
        }
        this.queryScenarioTimestampDataPoints.setInt(1, scenarioID);
        Timestamp timestamp = new Timestamp(lastBuildTime + 43200000L);
        this.queryScenarioTimestampDataPoints.setTimestamp(2, timestamp);
        ResultSet resultSet = this.queryScenarioTimestampDataPoints.executeQuery();
        return resultSet;
    }

    ResultSet queryScenarioDataPoints(String config, int scenarioID) throws SQLException {
        System.currentTimeMillis();
        if (this.queryScenarioDataPoints == null) {
            String statement = "select DATAPOINT.ID, DATAPOINT.STEP, VARIATION.KEYVALPAIRS from VARIATION, SAMPLE, DATAPOINT where VARIATION.KEYVALPAIRS like ? and SAMPLE.VARIATION_ID = VARIATION.ID and SAMPLE.SCENARIO_ID = ? and DATAPOINT.SAMPLE_ID = SAMPLE.ID ORDER BY DATAPOINT.ID, DATAPOINT.STEP";
            this.queryScenarioDataPoints = this.fConnection.prepareStatement(statement);
        }
        this.queryScenarioDataPoints.setString(1, "%" + config + "%");
        this.queryScenarioDataPoints.setInt(2, scenarioID);
        ResultSet resultSet = this.queryScenarioDataPoints.executeQuery();
        return resultSet;
    }

    ResultSet queryScenarioFailures(int scenarioID, String config, String currentBuildName, String baselineBuildName) throws SQLException {
        if (this.queryScenarioFailures == null) {
            this.queryScenarioFailures = this.fConnection.prepareStatement("select KEYVALPAIRS, MESSAGE from VARIATION, FAILURE where (KEYVALPAIRS like ? or KEYVALPAIRS like ?) and VARIATION_ID = VARIATION.ID and SCENARIO_ID = ? ORDER BY VARIATION_ID");
        }
        this.queryScenarioFailures.setString(1, "|build=" + currentBuildName + "||config=" + config + "||jvm=sun|");
        this.queryScenarioFailures.setString(2, "|build=" + baselineBuildName + "||config=" + config + "||jvm=sun|");
        this.queryScenarioFailures.setInt(3, scenarioID);
        return this.queryScenarioFailures.executeQuery();
    }

    ResultSet queryScenarioSummaries(int scenarioID, String config, String currentBuildName, String baselineBuildName) throws SQLException {
        if (this.queryScenarioSummaries == null) {
            this.queryScenarioSummaries = this.fConnection.prepareStatement("select KEYVALPAIRS, IS_GLOBAL, COMMENT_ID from VARIATION, SUMMARYENTRY where (KEYVALPAIRS like ? or KEYVALPAIRS like ?) and VARIATION_ID = VARIATION.ID and SCENARIO_ID = ? and DIM_ID = " + InternalDimensions.ELAPSED_PROCESS.getId() + " order by VARIATION_ID");
        }
        this.queryScenarioSummaries.setString(1, "|build=" + currentBuildName + "||config=" + config + "||jvm=sun|");
        this.queryScenarioSummaries.setString(2, "|build=" + baselineBuildName + "||config=" + config + "||jvm=sun|");
        this.queryScenarioSummaries.setInt(3, scenarioID);
        return this.queryScenarioSummaries.executeQuery();
    }
}

