/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EARArtifactEdit
extends EnterpriseArtifactEdit
implements IArtifactEditFactory,
IEARModelProvider {
    private static final String EAR_CONTENT_TYPE = "org.eclipse.jst.j2ee.earDD";
    public static final Class ADAPTER_TYPE = EARArtifactEdit.class;
    private static final IVirtualReference[] NO_REFERENCES = new IVirtualReference[0];

    public EARArtifactEdit() {
    }

    public EARArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public EARArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly, forCreate, "jst.ear");
    }

    public static EARArtifactEdit getEARArtifactEditForRead(IProject aProject) {
        EARArtifactEdit artifactEdit = null;
        try {
            if (EARArtifactEdit.isValidEARModule(ComponentCore.createComponent((IProject)aProject))) {
                artifactEdit = new EARArtifactEdit(aProject, true, false);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static EARArtifactEdit getEARArtifactEditForWrite(IProject aProject) {
        EARArtifactEdit artifactEdit = null;
        try {
            if (EARArtifactEdit.isValidEARModule(ComponentCore.createComponent((IProject)aProject))) {
                artifactEdit = new EARArtifactEdit(aProject, false, false);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static EARArtifactEdit getEARArtifactEditForRead(IVirtualComponent aModule) {
        if (aModule == null) {
            return null;
        }
        return EARArtifactEdit.getEARArtifactEditForRead(aModule.getProject());
    }

    public static EARArtifactEdit getEARArtifactEditForWrite(IVirtualComponent aModule) {
        if (aModule == null) {
            return null;
        }
        return EARArtifactEdit.getEARArtifactEditForWrite(aModule.getProject());
    }

    public static boolean isValidEARModule(IVirtualComponent aModule) throws UnresolveableURIException {
        if (!EARArtifactEdit.isValidEditableModule((IVirtualComponent)aModule)) {
            return false;
        }
        return JavaEEProjectUtilities.isEARProject(aModule.getProject());
    }

    public EARArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    protected EARArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public int getJ2EEVersion() {
        this.verifyOperationSupported();
        return this.getApplicationXmiResource().getJ2EEVersionID();
    }

    public ApplicationResource getApplicationXmiResource() {
        this.verifyOperationSupported();
        return (ApplicationResource)this.getDeploymentDescriptorResource();
    }

    public Application getApplication() {
        this.verifyOperationSupported();
        return (Application)this.getDeploymentDescriptorRoot();
    }

    public Resource getDeploymentDescriptorResource() {
        this.verifyOperationSupported();
        return this.getArtifactEditModel().getResource(J2EEConstants.APPLICATION_DD_URI_OBJ);
    }

    protected void addApplicationIfNecessary(XMLResource aResource) {
        this.verifyOperationSupported();
        if (aResource != null) {
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                Application newApp = ApplicationFactory.eINSTANCE.createApplication();
                aResource.getContents().add((Object)newApp);
            }
            Application application = (Application)aResource.getContents().get(0);
            URI moduleURI = this.getArtifactEditModel().getModuleURI();
            try {
                application.setDisplayName(StructureEdit.getDeployedName((URI)moduleURI));
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            aResource.setID((EObject)application, "Application_ID");
        }
    }

    public boolean uriExists(String currentURI) {
        StructureEdit edit = null;
        try {
            edit = StructureEdit.getStructureEditForRead((IProject)this.getProject());
            if (edit != null && edit.getComponent() != null) {
                EList referencedComps = edit.getComponent().getReferencedComponents();
                int i = 0;
                while (i < referencedComps.size()) {
                    String existingURI;
                    ReferencedComponent ref = (ReferencedComponent)referencedComps.get(i);
                    EObject module = ref.getDependentObject();
                    if (module != null && module instanceof Module && (existingURI = ((Module)module).getUri()) != null && existingURI.equals(currentURI)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return false;
    }

    public EObject createModelRoot() {
        this.verifyOperationSupported();
        return this.createModelRoot(this.getJ2EEVersion());
    }

    public EObject createModelRoot(int version) {
        this.verifyOperationSupported();
        ApplicationResource res = (ApplicationResource)this.getDeploymentDescriptorResource();
        res.setModuleVersionID(version);
        this.addApplicationIfNecessary((XMLResource)res);
        return ((ApplicationResource)this.getDeploymentDescriptorResource()).getRootObject();
    }

    public IVirtualReference[] getUtilityModuleReferences() {
        this.verifyOperationSupported();
        List explicitUtilityReferences = this.getComponentReferencesAsList(Collections.singletonList("jst.utility"));
        List<String> implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb");
        List implicitUtilityReferences = this.getComponentReferencesAsList(implicitUtilityReferenceTypes);
        Application application = this.getApplication();
        Module module = null;
        IVirtualReference reference = null;
        Iterator referenceItr = implicitUtilityReferences.iterator();
        while (referenceItr.hasNext()) {
            reference = (IVirtualReference)referenceItr.next();
            module = application.getFirstModule(reference.getArchiveName());
            if (module == null) continue;
            referenceItr.remove();
        }
        ArrayList allUtilityModuleReferences = new ArrayList();
        allUtilityModuleReferences.addAll(explicitUtilityReferences);
        allUtilityModuleReferences.addAll(implicitUtilityReferences);
        if (allUtilityModuleReferences.size() > 0) {
            return allUtilityModuleReferences.toArray(new IVirtualReference[allUtilityModuleReferences.size()]);
        }
        return NO_REFERENCES;
    }

    public String getModuleURI(IVirtualComponent moduleComp) {
        IVirtualReference[] refs = this.getComponent().getReferences();
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getReferencedComponent().equals(moduleComp)) {
                return refs[i].getArchiveName();
            }
            ++i;
        }
        return null;
    }

    public IVirtualComponent getModuleByManifestURI(String uri) {
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)this.getProject());
        IVirtualReference[] refs = earComponent.getReferences();
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getArchiveName().equals(uri)) {
                return refs[i].getReferencedComponent();
            }
            ++i;
        }
        return null;
    }

    public IVirtualComponent getModule(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        if (moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar")) {
            moduleName = moduleName.substring(0, moduleName.length() - ".jar".length());
        }
        IVirtualReference[] references = this.getComponentReferences();
        int i = 0;
        while (i < references.length) {
            IVirtualComponent component = references[i].getReferencedComponent();
            if (component.getName().equals(moduleName)) {
                return component;
            }
            ++i;
        }
        return null;
    }

    public IVirtualReference[] getJ2EEModuleReferences() {
        return EarUtilities.getJ2EEModuleReferences(this.getComponent());
    }

    public IVirtualReference[] getComponentReferences() {
        return EarUtilities.getComponentReferences(this.getComponent());
    }

    public IVirtualReference getComponentReference(String componentName) {
        return EarUtilities.getComponentReference(this.getComponent(), componentName);
    }

    private List getComponentReferencesAsList(List componentTypes) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = this.getComponent();
        if (earComponent != null && JavaEEProjectUtilities.isEARProject(earComponent.getProject())) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(JavaEEProjectUtilities.getJ2EEComponentType(module))) {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    public ArtifactEdit createArtifactEditForRead(IVirtualComponent aComponent) {
        return EARArtifactEdit.getEARArtifactEditForRead(aComponent);
    }

    public ArtifactEdit createArtifactEditForWrite(IVirtualComponent aComponent) {
        return EARArtifactEdit.getEARArtifactEditForWrite(aComponent);
    }

    public Archive asArchive(boolean includeSource) throws OpenFailureException {
        this.verifyOperationSupported();
        return this.asArchive(includeSource, true);
    }

    public Archive asArchive(boolean includeSource, boolean includeClasspathComponents) throws OpenFailureException {
        this.verifyOperationSupported();
        EARComponentLoadStrategyImpl loader = new EARComponentLoadStrategyImpl(this.getComponent(), includeClasspathComponents);
        loader.setExportSource(includeSource);
        String uri = ModuleURIUtil.getHandleString((IVirtualComponent)this.getComponent());
        return CommonarchiveFactory.eINSTANCE.openEARFile((LoadStrategy)loader, uri);
    }

    public static void createDeploymentDescriptor(IProject project, int version) {
        EARArtifactEdit earEdit = new EARArtifactEdit(project, false, true);
        try {
            ((EnterpriseArtifactEdit)earEdit).createModelRoot(version);
            earEdit.save(null);
        }
        finally {
            Resource newRes = ((EnterpriseArtifactEdit)earEdit).getDeploymentDescriptorResource();
            WorkbenchResourceHelperBase.getResourceSet((IProject)project).getResources().remove((Object)newRes);
            newRes.unload();
            earEdit.dispose();
        }
    }

    public String getWebContextRoot(IProject webProject) {
        WebModule webModule;
        this.verifyOperationSupported();
        if (webProject == null || !JavaEEProjectUtilities.isDynamicWebProject(webProject)) {
            return null;
        }
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        String webModuleURI = this.getModuleURI(webComp);
        if (webModuleURI != null && (webModule = (WebModule)this.getApplication().getModule(webModuleURI, null)) != null) {
            return webModule.getContextRoot();
        }
        return null;
    }

    public void setWebContextRoot(IProject webProject, String aContextRoot) {
        WebModule webModule;
        this.verifyOperationSupported();
        if (webProject == null || !JavaEEProjectUtilities.isDynamicWebProject(webProject)) {
            return;
        }
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        String webModuleURI = this.getModuleURI(webComp);
        if (webModuleURI != null && (webModule = (WebModule)this.getApplication().getModule(webModuleURI, null)) != null) {
            webModule.setContextRoot(aContextRoot);
        }
    }

    public IModelProvider create(IProject project) {
        return EARArtifactEdit.getEARArtifactEditForRead(project);
    }

    public IModelProvider create(IVirtualComponent component) {
        return EARArtifactEdit.getEARArtifactEditForRead(component);
    }

    public void modify(Runnable runnable, IPath modelPath) {
        this.setWritableEdit(EARArtifactEdit.getEARArtifactEditForWrite(this.getProject()));
        try {
            runnable.run();
            if (this.getWritableEdit() != null) {
                this.getWritableEdit().saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            this.getWritableEdit().dispose();
            this.setWritableEdit(null);
        }
    }

    protected String getContentTypeDescriber() {
        return EAR_CONTENT_TYPE;
    }
}

