/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.AppClientArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactExportOperation;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EARComponentExportOperation
extends J2EEArtifactExportOperation {
    public EARComponentExportOperation(IDataModel model) {
        super(model);
    }

    protected void export() throws SaveFailureException, CoreException, InvocationTargetException, InterruptedException {
        block14: {
            SubProgressMonitor subMonitor = new SubProgressMonitor(this.progressMonitor, 1000);
            IArchive archiveFromComponent = null;
            try {
                try {
                    archiveFromComponent = JavaEEArchiveUtilities.INSTANCE.openArchive(this.getComponent());
                    JavaEEQuickPeek quickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archiveFromComponent);
                    if (quickPeek.getJavaEEVersion() == 50) {
                        this.saveArchive(archiveFromComponent, this.getDestinationPath().toOSString(), (IProgressMonitor)subMonitor);
                        break block14;
                    }
                    EnterpriseArtifactEdit artifactEdit = null;
                    try {
                        try {
                            artifactEdit = (EnterpriseArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.getComponent());
                            EARFile archive = (EARFile)artifactEdit.asArchive(this.isExportSource());
                            String destination = this.getDestinationPath().toOSString();
                            archive.setURI(destination);
                            this.setModuleFile((ModuleFile)archive);
                            ComponentLoadStrategyImpl ls = (ComponentLoadStrategyImpl)archive.getLoadStrategy();
                            ls.setProgressMonitor((IProgressMonitor)subMonitor);
                            archive.saveAsNoReopen(destination);
                        }
                        catch (SaveFailureException ex) {
                            throw ex;
                        }
                        catch (Exception e) {
                            throw new SaveFailureException(AppClientArchiveOpsResourceHandler.ARCHIVE_OPERATION_OpeningArchive, e);
                        }
                    }
                    finally {
                        if (artifactEdit != null) {
                            artifactEdit.dispose();
                        }
                    }
                }
                catch (Exception e) {
                    throw new SaveFailureException(AppClientArchiveOpsResourceHandler.ARCHIVE_OPERATION_OpeningArchive, e);
                }
            }
            finally {
                if (archiveFromComponent != null) {
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(archiveFromComponent);
                }
                subMonitor.done();
            }
        }
    }

    protected void runNecessaryBuilders(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        try {
            IVirtualReference[] refs = component.getReferences();
            int work = 200 / (refs.length + 1);
            super.runNecessaryBuilders(component, (IProgressMonitor)new SubProgressMonitor(monitor, work));
            int i = 0;
            while (i < refs.length) {
                IVirtualComponent refComp = refs[i].getReferencedComponent();
                super.runNecessaryBuilders(refComp, (IProgressMonitor)new SubProgressMonitor(monitor, work));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String archiveString() {
        return "EAR";
    }
}

