/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyManifestUtil;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.IApplicationClientModule;
import org.eclipse.jst.server.core.IConnectorModule;
import org.eclipse.jst.server.core.IEJBModule;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.web.internal.deployables.ComponentDeployable;

public class J2EEFlexProjDeployable
extends ComponentDeployable
implements IJ2EEModule,
IEnterpriseApplication,
IApplicationClientModule,
IConnectorModule,
IEJBModule,
IWebModule {
    protected static final IPath WEB_CLASSES_PATH = new Path("WEB-INF/classes");
    protected static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    protected static IPath WEBLIB = new Path("WEB-INF/lib").makeAbsolute();
    protected IPackageFragmentRoot[] cachedSourceContainers;
    protected IContainer[] cachedOutputContainers;
    protected HashMap cachedOutputMappings;
    protected HashMap cachedSourceOutputPairs;
    protected List classpathComponentDependencyURIs = new ArrayList();

    public J2EEFlexProjDeployable(IProject project, IVirtualComponent aComponent) {
        super(project, aComponent);
    }

    public J2EEFlexProjDeployable(IProject project) {
        super(project);
    }

    public IContainer[] getResourceFolders() {
        IVirtualFolder vFolder;
        ArrayList result = new ArrayList();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            IContainer[] underlyingFolders = vFolder.getUnderlyingFolders();
            result.addAll(Arrays.asList(underlyingFolders));
        }
        return result.toArray(new IContainer[result.size()]);
    }

    public IContainer[] getJavaOutputFolders() {
        if (this.cachedOutputContainers == null) {
            this.cachedOutputContainers = this.getJavaOutputFolders(this.getProject());
        }
        return this.cachedOutputContainers;
    }

    public IContainer[] getJavaOutputFolders(IProject project) {
        if (project == null) {
            return new IContainer[0];
        }
        return J2EEProjectUtilities.getOutputContainers(project);
    }

    protected boolean shouldIncludeUtilityComponent(IVirtualComponent virtualComp, IVirtualReference[] references, ArtifactEdit edit) {
        if (J2EEProjectUtilities.isEARProject(this.component.getProject())) {
            return virtualComp != null && virtualComp.isBinary() && !this.isNestedJ2EEModule(virtualComp, references, (EARArtifactEdit)edit);
        }
        return super.shouldIncludeUtilityComponent(virtualComp, references, edit);
    }

    protected void addUtilMember(IVirtualComponent parent, IVirtualReference reference, IPath runtimePath) {
        if (!runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) && !ClasspathDependencyUtil.isClassFolderReference(reference)) {
            super.addUtilMember(parent, reference, runtimePath);
        }
    }

    protected IModuleResource[] getBinaryModuleMembers() {
        IPath archivePath = ((J2EEModuleVirtualArchiveComponent)this.component).getWorkspaceRelativePath();
        ModuleFile mf = null;
        if (archivePath != null) {
            IFile utilFile = ResourcesPlugin.getWorkspace().getRoot().getFile(archivePath);
            mf = new ModuleFile(utilFile, utilFile.getName(), ((J2EEModuleVirtualArchiveComponent)this.component).getRuntimePath().makeRelative());
        } else {
            File extFile = ((J2EEModuleVirtualArchiveComponent)this.component).getUnderlyingDiskFile();
            mf = new ModuleFile(extFile, extFile.getName(), ((J2EEModuleVirtualArchiveComponent)this.component).getRuntimePath().makeRelative());
        }
        return new IModuleResource[]{mf};
    }

    public IModuleResource[] members() throws CoreException {
        this.members.clear();
        this.classpathComponentDependencyURIs.clear();
        if (this.component instanceof J2EEModuleVirtualArchiveComponent) {
            return this.getBinaryModuleMembers();
        }
        if (J2EEProjectUtilities.isEARProject(this.component.getProject())) {
            this.addReferencedComponentClasspathDependencies(this.component, false);
        } else {
            if (J2EEProjectUtilities.isDynamicWebProject(this.component.getProject())) {
                this.addReferencedComponentClasspathDependencies(this.component, true);
            }
            if (this.canExportClasspathComponentDependencies(this.component)) {
                this.saveClasspathDependencyURIs(this.component);
            }
            this.addClassFolderDependencies(this.component);
        }
        if (this.isSingleRootStructure()) {
            int i;
            IModuleResource[] resources = this.getOptimizedMembers();
            if (!this.classpathComponentDependencyURIs.isEmpty()) {
                i = 0;
                while (i < resources.length) {
                    IModuleFolder folder;
                    if (resources[i] instanceof IModuleFolder && (folder = (IModuleFolder)resources[i]).getName().equals("META-INF")) {
                        IModuleResource[] files = folder.members();
                        int j = 0;
                        while (j < files.length) {
                            files[j] = this.replaceManifestFile((IModuleFile)files[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < resources.length) {
                this.members.add(resources[i]);
                ++i;
            }
            return this.members.toArray(new IModuleResource[this.members.size()]);
        }
        this.cachedSourceContainers = J2EEProjectUtilities.getSourceContainers(this.getProject());
        try {
            Path javaPath = Path.EMPTY;
            if (J2EEProjectUtilities.isDynamicWebProject(this.component.getProject())) {
                javaPath = WEB_CLASSES_PATH;
            }
            if (this.component != null) {
                IVirtualFolder vFolder = this.component.getRootFolder();
                IModuleResource[] mr = this.getMembers((IVirtualContainer)vFolder, (IPath)Path.EMPTY);
                int size = mr.length;
                int j = 0;
                while (j < size) {
                    this.members.add(mr[j]);
                    ++j;
                }
            }
            IContainer[] javaCont = this.getJavaOutputFolders();
            int size = javaCont.length;
            int i = 0;
            while (i < size) {
                if (ComponentCore.createResources((IResource)javaCont[i]).length <= 0) {
                    IModuleResource[] mr = this.getMembers(javaCont[i], (IPath)javaPath, (IPath)javaPath, javaCont);
                    int size2 = mr.length;
                    int j = 0;
                    while (j < size2) {
                        this.members.add(mr[j]);
                        ++j;
                    }
                }
                ++i;
            }
            if (this.component != null) {
                this.addUtilMembers(this.component);
                List consumableMembers = this.getConsumableReferencedMembers(this.component);
                if (!consumableMembers.isEmpty()) {
                    this.members.addAll(consumableMembers);
                }
            }
            IModuleResource[] mr = new IModuleResource[this.members.size()];
            this.members.toArray(mr);
            IModuleResource[] iModuleResourceArray = mr;
            return iModuleResourceArray;
        }
        finally {
            this.cachedSourceContainers = null;
            this.cachedOutputContainers = null;
            this.cachedOutputMappings = null;
            this.cachedSourceOutputPairs = null;
        }
    }

    protected IModuleFile createModuleFile(IFile file, IPath path) {
        return this.replaceManifestFile(super.createModuleFile(file, path));
    }

    protected IModuleFile replaceManifestFile(IModuleFile moduleFile) {
        IFile file = (IFile)moduleFile.getAdapter(IFile.class);
        IPath path = moduleFile.getModuleRelativePath();
        if (path.append(file.getName()).equals((Object)MANIFEST_PATH) && !this.classpathComponentDependencyURIs.isEmpty()) {
            File parent;
            IProject project = file.getProject();
            IPath workingLocation = project.getWorkingLocation("org.eclipse.jst.j2ee");
            IPath tempManifestPath = workingLocation.append(MANIFEST_PATH);
            File fsFile = tempManifestPath.toFile();
            if (!(fsFile.exists() || (parent = fsFile.getParentFile()).exists() || parent.mkdirs())) {
                return moduleFile;
            }
            try {
                ClasspathDependencyManifestUtil.updateManifestClasspath(file, this.classpathComponentDependencyURIs, new FileOutputStream(fsFile));
                return new ModuleFile(fsFile, file.getName(), path);
            }
            catch (IOException iOException) {
                return moduleFile;
            }
        }
        return moduleFile;
    }

    protected IModuleResource[] handleJavaPath(IPath path, IPath javaPath, IPath curPath, IContainer[] javaCont, IModuleResource[] mr, IContainer cc) throws CoreException {
        if (curPath.equals((Object)javaPath)) {
            int size = javaCont.length;
            int i = 0;
            while (i < size) {
                IModuleResource[] mr2 = this.getMembers(javaCont[i], path.append(cc.getName()), null, null);
                IModuleResource[] mr3 = new IModuleResource[mr.length + mr2.length];
                System.arraycopy(mr, 0, mr3, 0, mr.length);
                System.arraycopy(mr2, 0, mr3, mr.length, mr2.length);
                mr = mr3;
                ++i;
            }
        } else {
            boolean containsFolder = false;
            String name = javaPath.segment(curPath.segmentCount());
            int size = mr.length;
            int i = 0;
            while (i < size && !containsFolder) {
                IModuleFolder mf2;
                if (mr[i] instanceof IModuleFolder && name.equals((mf2 = (IModuleFolder)mr[i]).getName())) {
                    containsFolder = true;
                }
                ++i;
            }
            if (!containsFolder && javaCont.length > 0) {
                ModuleFolder mf2 = new ModuleFolder(javaCont[0], name, curPath);
                IModuleResource[] mrf = new IModuleResource[]{};
                size = javaCont.length;
                int i2 = 0;
                while (i2 < size) {
                    IModuleResource[] mrf2 = this.getMembers(javaCont[i2], javaPath, null, null);
                    IModuleResource[] mrf3 = new IModuleResource[mrf.length + mrf2.length];
                    System.arraycopy(mrf, 0, mrf3, 0, mrf.length);
                    System.arraycopy(mrf2, 0, mrf3, mrf.length, mrf2.length);
                    mrf = mrf3;
                    ++i2;
                }
                mf2.setMembers(mrf);
                IModuleResource[] mr3 = new IModuleResource[mr.length + 1];
                System.arraycopy(mr, 0, mr3, 0, mr.length);
                mr3[mr.length] = mf2;
                mr = mr3;
            }
        }
        return mr;
    }

    public IPath[] getClasspath() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IJavaProject proj = JemProjectUtilities.getJavaProject((IProject)this.getProject());
        URL[] urls = JemProjectUtilities.getClasspathAsURLArray((IJavaProject)proj);
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            paths.add(Path.fromOSString((String)url.getPath()));
            ++i;
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    public String getJNDIName(String ejbName) {
        if (!J2EEProjectUtilities.isEJBProject(this.component.getProject())) {
            return null;
        }
        EjbModuleExtensionHelper modHelper = null;
        EJBJar jar = null;
        ArtifactEdit ejbEdit = null;
        try {
            ejbEdit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.component);
            if (ejbEdit != null) {
                jar = (EJBJar)ejbEdit.getContentModelRoot();
                modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
                String string = modHelper == null ? null : modHelper.getJNDIName(jar, jar.getEnterpriseBeanNamed(ejbName));
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
        return null;
    }

    public String getURI(IModule module) {
        String aURI;
        block25: {
            IProject[] earProjects;
            if (this.component != null && module != null && J2EEProjectUtilities.isEARProject(this.component.getProject())) {
                return this.getContainedURI(module);
            }
            IVirtualComponent ear = null;
            aURI = null;
            if (module != null && J2EEProjectUtilities.isEARProject(module.getProject())) {
                ear = ComponentCore.createComponent((IProject)module.getProject());
            } else if (module == null && this.component != null && (earProjects = J2EEProjectUtilities.getReferencingEARProjects(this.component.getProject())).length > 0) {
                ear = ComponentCore.createComponent((IProject)earProjects[0]);
            }
            if (ear != null && this.component != null) {
                EARArtifactEdit earEdit = null;
                try {
                    try {
                        earEdit = EARArtifactEdit.getEARArtifactEditForRead(ear);
                        if (earEdit != null) {
                            aURI = earEdit.getModuleURI(this.component);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (earEdit != null) {
                            earEdit.dispose();
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (earEdit != null) {
                        earEdit.dispose();
                    }
                    throw throwable;
                }
                if (earEdit != null) {
                    earEdit.dispose();
                }
            } else if (this.component != null && J2EEProjectUtilities.isEARProject(this.component.getProject())) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".ear";
            } else if (this.component != null && J2EEProjectUtilities.isDynamicWebProject(this.component.getProject())) {
                if (module != null && J2EEProjectUtilities.isUtilityProject(module.getProject())) {
                    IVirtualComponent webComp = ComponentCore.createComponent((IProject)this.component.getProject());
                    IVirtualReference reference = webComp.getReference(module.getProject().getName());
                    aURI = ComponentUtilities.getDeployUriOfUtilComponent((IVirtualReference)reference);
                } else {
                    aURI = String.valueOf(this.component.getDeployedName()) + ".war";
                }
            } else if (this.component != null && (J2EEProjectUtilities.isEJBProject(this.component.getProject()) || J2EEProjectUtilities.isApplicationClientProject(this.component.getProject()))) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".jar";
            } else if (this.component != null && J2EEProjectUtilities.isJCAProject(this.component.getProject())) {
                aURI = String.valueOf(this.component.getDeployedName()) + ".rar";
            }
        }
        if (aURI != null && aURI.length() > 1 && aURI.startsWith("/")) {
            aURI = aURI.substring(1);
        }
        return aURI;
    }

    protected boolean isBinaryModuleArchive(IModule module) {
        return (module != null && module.getName().endsWith(".jar") || module.getName().endsWith(".war") || module.getName().endsWith(".rar")) && this.component != null && J2EEProjectUtilities.isEARProject(this.component.getProject());
    }

    private String getContainedURI(IModule module) {
        String aURI;
        block12: {
            if (this.component instanceof J2EEModuleVirtualArchiveComponent || this.isBinaryModuleArchive(module)) {
                return new Path(module.getName()).lastSegment();
            }
            IVirtualComponent comp = ComponentCore.createComponent((IProject)module.getProject());
            aURI = null;
            if (comp != null && this.component != null && J2EEProjectUtilities.isEARProject(this.component.getProject())) {
                EARArtifactEdit earEdit = null;
                try {
                    try {
                        earEdit = EARArtifactEdit.getEARArtifactEditForRead(this.component);
                        if (earEdit != null) {
                            aURI = earEdit.getModuleURI(comp);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (earEdit != null) {
                            earEdit.dispose();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (earEdit != null) {
                        earEdit.dispose();
                    }
                    throw throwable;
                }
                if (earEdit != null) {
                    earEdit.dispose();
                }
            }
        }
        if (aURI != null && aURI.length() > 1 && aURI.startsWith("/")) {
            aURI = aURI.substring(1);
        }
        return aURI;
    }

    public String getContextRoot() {
        Properties props = this.component.getMetaProperties();
        if (props.containsKey("context-root")) {
            return props.getProperty("context-root");
        }
        return this.component.getName();
    }

    public String getContextRoot(IModule earModule) {
        IProject deployProject = this.component.getProject();
        String contextRoot = null;
        if (earModule == null) {
            return this.getContextRoot();
        }
        if (J2EEProjectUtilities.isEARProject(earModule.getProject()) && J2EEProjectUtilities.isDynamicWebProject(deployProject)) {
            EARArtifactEdit edit = null;
            try {
                edit = EARArtifactEdit.getEARArtifactEditForRead(earModule.getProject());
                contextRoot = edit.getWebContextRoot(deployProject);
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return contextRoot;
    }

    protected IPackageFragmentRoot getSourceContainer(IFile file) {
        if (file == null) {
            return null;
        }
        IPackageFragmentRoot[] srcContainers = this.getSourceContainers();
        int i = 0;
        while (i < srcContainers.length) {
            IPath srcPath = srcContainers[i].getPath();
            if (srcPath.isPrefixOf(file.getFullPath())) {
                return srcContainers[i];
            }
            ++i;
        }
        return null;
    }

    protected IContainer getOutputContainer(IPackageFragmentRoot sourceContainer) {
        if (sourceContainer == null) {
            return null;
        }
        HashMap pairs = this.getCachedSourceOutputPairs();
        IContainer output = (IContainer)pairs.get(sourceContainer);
        if (output == null) {
            output = J2EEProjectUtilities.getOutputContainer(this.getProject(), sourceContainer);
            pairs.put(sourceContainer, output);
        }
        return output;
    }

    private IPackageFragmentRoot[] getSourceContainers() {
        if (this.cachedSourceContainers != null) {
            return this.cachedSourceContainers;
        }
        return J2EEProjectUtilities.getSourceContainers(this.getProject());
    }

    protected List getConsumableReferencedMembers(IVirtualComponent vc) throws CoreException {
        ArrayList consumableMembers = new ArrayList();
        IVirtualReference[] refComponents = vc.getReferences();
        int i = 0;
        while (i < refComponents.length) {
            IVirtualComponent consumedComponent;
            IVirtualReference reference = refComponents[i];
            if (reference != null && reference.getDependencyType() == 1 && (consumedComponent = reference.getReferencedComponent()) != null && J2EEFlexProjDeployable.isProjectOfType((IProject)consumedComponent.getProject(), (String)"jst.utility")) {
                if (consumedComponent != null && consumedComponent.getRootFolder() != null) {
                    IVirtualFolder vFolder = consumedComponent.getRootFolder();
                    IModuleResource[] mr = this.getMembers((IVirtualContainer)vFolder, reference.getRuntimePath().makeRelative());
                    int size = mr.length;
                    int j = 0;
                    while (j < size) {
                        if (!this.members.contains(mr[j])) {
                            this.members.add(mr[j]);
                        }
                        ++j;
                    }
                    this.addUtilMembers(consumedComponent);
                    List childConsumableMembers = this.getConsumableReferencedMembers(consumedComponent);
                    if (!childConsumableMembers.isEmpty()) {
                        this.members.addAll(childConsumableMembers);
                    }
                }
                IContainer[] javaCont = this.getJavaOutputFolders(consumedComponent.getProject());
                int size = javaCont.length;
                int j = 0;
                while (j < size) {
                    IModuleResource[] mr = this.getMembers(javaCont[j], reference.getRuntimePath(), reference.getRuntimePath(), javaCont);
                    int size2 = mr.length;
                    int k = 0;
                    while (k < size2) {
                        if (!this.members.contains(mr[k])) {
                            this.members.add(mr[k]);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return consumableMembers;
    }

    protected IModule gatherModuleReference(IVirtualComponent component, IVirtualComponent targetComponent) {
        IModule module = super.gatherModuleReference(component, targetComponent);
        if (targetComponent instanceof J2EEModuleVirtualArchiveComponent && (J2EEProjectUtilities.isEARProject(component.getProject()) || targetComponent.getProject() != component.getProject())) {
            module = ServerUtil.getModule((String)("org.eclipse.jst.j2ee.server:" + targetComponent.getName()));
        }
        return module;
    }

    private boolean isNestedJ2EEModule(IVirtualComponent aComponent, IVirtualReference[] references, EARArtifactEdit edit) {
        IVirtualReference reference;
        if (edit == null) {
            return false;
        }
        Application app = edit.getApplication();
        return app.getFirstModule((reference = this.getReferenceNamed(references, aComponent.getName())).getArchiveName()) != null;
    }

    protected IVirtualReference getReferenceNamed(IVirtualReference[] references, String name) {
        int i = 0;
        while (i < references.length) {
            if (references[i].getReferencedComponent().getName().equals(name)) {
                return references[i];
            }
            ++i;
        }
        return null;
    }

    protected ArtifactEdit getComponentArtifactEditForRead() {
        return EARArtifactEdit.getEARArtifactEditForRead(this.component.getProject());
    }

    protected IVirtualReference[] getReferences(IVirtualComponent aComponent) {
        if (aComponent == null || aComponent.isBinary()) {
            return new IVirtualReference[0];
        }
        if (J2EEProjectUtilities.isDynamicWebProject(aComponent.getProject())) {
            return this.getWebLibModules((J2EEModuleVirtualComponent)aComponent);
        }
        if (J2EEProjectUtilities.isEARProject(aComponent.getProject())) {
            return super.getReferences(aComponent);
        }
        return new IVirtualReference[0];
    }

    private IVirtualReference[] getWebLibModules(J2EEModuleVirtualComponent comp) {
        ArrayList<IVirtualReference> result = new ArrayList<IVirtualReference>();
        IVirtualReference[] refComponents = comp.getNonManifestReferences();
        int i = 0;
        while (i < refComponents.length) {
            if (refComponents[i].getRuntimePath().equals((Object)WEBLIB)) {
                result.add(refComponents[i]);
            }
            ++i;
        }
        return result.toArray(new IVirtualReference[result.size()]);
    }

    private void addReferencedComponentClasspathDependencies(IVirtualComponent component, boolean web) {
        IVirtualReference[] refs = component.getReferences();
        HashSet<IPath> absolutePaths = new HashSet<IPath>();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            IPath runtimePath = reference.getRuntimePath();
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            if ((!web || runtimePath.equals((Object)WEBLIB)) && this.canExportClasspathComponentDependencies(referencedComponent) && !referencedComponent.isBinary() && referencedComponent instanceof J2EEModuleVirtualComponent) {
                IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)referencedComponent).getJavaClasspathReferences();
                int j = 0;
                while (j < cpRefs.length) {
                    ClasspathDependencyVirtualComponent cpComp;
                    IVirtualReference cpRef = cpRefs[j];
                    IPath cpRefRuntimePath = cpRef.getRuntimePath();
                    if (cpRef.getReferencedComponent() instanceof ClasspathDependencyVirtualComponent && !(cpComp = (ClasspathDependencyVirtualComponent)cpRef.getReferencedComponent()).isClassFolder()) {
                        IPath absolutePath;
                        if (cpRefRuntimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                            cpRefRuntimePath = runtimePath;
                        }
                        if (!absolutePaths.contains(absolutePath = ClasspathDependencyUtil.getClasspathVirtualReferenceLocation(cpRef))) {
                            this.addUtilMember(component, cpRef, cpRefRuntimePath);
                            absolutePaths.add(absolutePath);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean canExportClasspathComponentDependencies(IVirtualComponent component) {
        IProject project = component.getProject();
        return J2EEProjectUtilities.isEJBProject(project) || J2EEProjectUtilities.isDynamicWebProject(project) || J2EEProjectUtilities.isJCAProject(project) || J2EEProjectUtilities.isUtilityProject(project);
    }

    private void saveClasspathDependencyURIs(IVirtualComponent component) {
        if (!component.isBinary() && component instanceof J2EEModuleVirtualComponent) {
            IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)component).getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                IVirtualReference cpRef = cpRefs[j];
                if (cpRef.getRuntimePath().equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) && cpRef.getReferencedComponent() instanceof VirtualArchiveComponent) {
                    this.classpathComponentDependencyURIs.add(cpRef.getArchiveName());
                }
                ++j;
            }
        }
    }

    private void addClassFolderDependencies(IVirtualComponent component) throws CoreException {
        block4: {
            if (component.isBinary() || !(component instanceof J2EEModuleVirtualComponent)) break block4;
            IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)component).getJavaClasspathReferences();
            int i = 0;
            while (i < cpRefs.length) {
                block5: {
                    Path targetPath;
                    ClasspathDependencyVirtualComponent cpComp;
                    block7: {
                        IPath runtimePath;
                        block6: {
                            IVirtualReference cpRef = cpRefs[i];
                            runtimePath = cpRef.getRuntimePath();
                            IVirtualComponent comp = cpRef.getReferencedComponent();
                            if (!(comp instanceof ClasspathDependencyVirtualComponent) || !(cpComp = (ClasspathDependencyVirtualComponent)comp).isClassFolder()) break block5;
                            targetPath = null;
                            if (!runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_COMPONENT_PATH)) break block6;
                            targetPath = Path.EMPTY;
                            break block7;
                        }
                        if (!runtimePath.equals((Object)IClasspathDependencyConstants.WEB_INF_CLASSES_PATH)) break block5;
                        targetPath = WEB_CLASSES_PATH;
                    }
                    IContainer container = cpComp.getClassFolder();
                    IModuleResource[] mr = this.getMembers(container, (IPath)targetPath, (IPath)targetPath, new IContainer[]{container});
                    int j = 0;
                    while (j < mr.length) {
                        this.members.add(mr[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isSingleRootStructure() {
        edit = null;
        try {
            block11: {
                edit = StructureEdit.getStructureEditForRead((IProject)this.getProject());
                if (edit == null || edit.getComponent() == null) lbl-1000:
                // 7 sources

                {
                    return false;
                }
                wbComp = edit.getComponent();
                resourceMaps = wbComp.getResources();
                if (J2EEProjectUtilities.isEARProject(this.getProject())) ** GOTO lbl-1000
                if (!J2EEProjectUtilities.isDynamicWebProject(this.getProject())) break block11;
                references = ((J2EEModuleVirtualComponent)this.component).getNonManifestReferences();
                i = 0;
                while (i < references.length) {
                    if (references[i].getReferencedComponent().isBinary()) ** GOTO lbl-1000
                    ++i;
                }
                if (!this.hasDefaultWebResourceMappings((List)resourceMaps) || this.getJavaOutputFolders().length != 1) ** GOTO lbl-1000
                javaOutputPath = this.getJavaOutputFolders()[0].getProjectRelativePath();
                compRootPath = this.component.getRootFolder().getUnderlyingFolder().getProjectRelativePath();
                if (!compRootPath.append("WEB-INF/classes").equals((Object)javaOutputPath)) ** GOTO lbl-1000
lbl21:
                // 4 sources

                return true;
            }
            if (!J2EEProjectUtilities.isEJBProject(this.getProject()) && !J2EEProjectUtilities.isJCAProject(this.getProject()) && !J2EEProjectUtilities.isApplicationClientProject(this.getProject()) && !J2EEProjectUtilities.isUtilityProject(this.getProject())) ** GOTO lbl21
            if (!this.isRootResourceMapping((List)resourceMaps, false) || this.getJavaOutputFolders().length != 1) ** GOTO lbl-1000
            if (J2EEProjectUtilities.isUtilityProject(this.getProject())) ** GOTO lbl21
            javaOutputPath = this.getJavaOutputFolders()[0].getProjectRelativePath();
            rootFolders = this.component.getRootFolder().getUnderlyingFolders();
            i = 0;
            while (true) {
                if (i < rootFolders.length) ** break;
                ** continue;
                compRootPath = rootFolders[i].getProjectRelativePath();
                if (!javaOutputPath.equals((Object)compRootPath)) ** break;
                ** continue;
                ++i;
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private boolean isRootResourceMapping(List resourceMaps, boolean isForEAR) {
        if (resourceMaps.size() < 1) {
            return false;
        }
        int i = 0;
        while (i < resourceMaps.size()) {
            IPath sourcePath;
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            if (!resourceMap.getRuntimePath().equals((Object)Path.ROOT)) {
                return false;
            }
            if (!isForEAR && !this.isSourceContainer(sourcePath = this.getProject().getFullPath().append(resourceMap.getSourcePath()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSourceContainer(IPath path) {
        IPackageFragmentRoot[] srcContainers = this.getSourceContainers();
        int i = 0;
        while (i < srcContainers.length) {
            if (srcContainers[i].getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasDefaultWebResourceMappings(List resourceMaps) {
        int rootValidMaps = 0;
        int javaValidRoots = 0;
        if (resourceMaps.size() < 2) {
            return false;
        }
        IPath webInfClasses = new Path("WEB-INF/classes").makeAbsolute();
        int i = 0;
        while (i < resourceMaps.size()) {
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            IPath sourcePath = this.getProject().getFullPath().append(resourceMap.getSourcePath());
            if (resourceMap.getRuntimePath().equals((Object)Path.ROOT)) {
                ++rootValidMaps;
            } else if (resourceMap.getRuntimePath().equals((Object)webInfClasses) && this.isSourceContainer(sourcePath)) {
                ++javaValidRoots;
            } else {
                return false;
            }
            ++i;
        }
        return rootValidMaps == 1 && javaValidRoots > 0;
    }

    private IModuleResource[] getOptimizedMembers() throws CoreException {
        if (this.component != null) {
            if (J2EEProjectUtilities.isUtilityProject(this.getProject())) {
                return this.getModuleResources((IPath)Path.EMPTY, this.getJavaOutputFolders()[0]);
            }
            IVirtualFolder vFolder = this.component.getRootFolder();
            return this.getModuleResources((IPath)Path.EMPTY, vFolder.getUnderlyingFolder());
        }
        return new IModuleResource[0];
    }

    private boolean isOutputContainerMapped(IContainer outputContainer) {
        if (outputContainer == null) {
            return false;
        }
        HashMap outputMaps = this.getCachedOutputMappings();
        Boolean result = (Boolean)outputMaps.get(outputContainer);
        if (result == null) {
            result = ComponentCore.createResources((IResource)outputContainer).length > 0 ? Boolean.TRUE : Boolean.FALSE;
            outputMaps.put(outputContainer, result);
        }
        return result;
    }

    private HashMap getCachedOutputMappings() {
        if (this.cachedOutputMappings == null) {
            this.cachedOutputMappings = new HashMap();
        }
        return this.cachedOutputMappings;
    }

    private HashMap getCachedSourceOutputPairs() {
        if (this.cachedSourceOutputPairs == null) {
            this.cachedSourceOutputPairs = new HashMap();
        }
        return this.cachedSourceOutputPairs;
    }

    protected boolean shouldAddComponentFile(IFile file) {
        IPackageFragmentRoot sourceContainer = this.getSourceContainer(file);
        if (sourceContainer == null) {
            return true;
        }
        IContainer outputContainer = this.getOutputContainer(sourceContainer);
        return outputContainer != null && this.isOutputContainerMapped(outputContainer);
    }
}

