/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class WebUtilities
extends JavaEEProjectUtilities {
    public static IPath WEBLIB = new Path("/WEB-INF/lib");

    public static int getServletVersion(IProject webProject) {
        int retVal = 0;
        Object webAppResource = ModelProviderManager.getModelProvider(webProject).getModelObject();
        if (webAppResource instanceof XMLResource) {
            retVal = ((XMLResource)webAppResource).getModuleVersionID();
        } else if (webAppResource instanceof WebApp) {
            switch (((WebApp)webAppResource).getVersion().getValue()) {
                case 0: {
                    retVal = 25;
                }
            }
        }
        return retVal;
    }

    public static int getJSPVersion(IProject webProject) {
        int servletVersion = WebUtilities.getServletVersion(webProject);
        if (servletVersion == 22) {
            return 11;
        }
        if (servletVersion == 23) {
            return 12;
        }
        return 20;
    }

    public static IVirtualReference[] getLibModules(IProject webProject) {
        ArrayList<IVirtualReference> result = new ArrayList<IVirtualReference>();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)webProject);
        IVirtualReference[] refComponents = null;
        refComponents = !comp.isBinary() ? ((J2EEModuleVirtualComponent)comp).getNonManifestReferences() : comp.getReferences();
        int i = 0;
        while (i < refComponents.length) {
            if (refComponents[i].getRuntimePath().equals((Object)WEBLIB)) {
                result.add(refComponents[i]);
            }
            ++i;
        }
        return result.toArray(new IVirtualReference[result.size()]);
    }
}

