/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class RenameJavaElementDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private static final String ATTRIBUTE_MATCH_STRATEGY = "matchStrategy";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_SUFFIX = 3;
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private boolean fHierarchical = false;
    private IJavaElement fJavaElement = null;
    private int fMatchStrategy = 1;
    private String fName = null;
    private String fPatterns = null;
    private boolean fQualified = false;
    private boolean fReferences = false;
    private boolean fRenameGetter = false;
    private boolean fRenameSetter = false;
    private boolean fSimilarDeclarations = false;
    private boolean fTextual = false;

    public RenameJavaElementDescriptor(String id) {
        super(id);
        Assert.isLegal((boolean)this.checkId(id), (String)"Refactoring id is not a rename refactoring id");
    }

    private boolean checkId(String id) {
        Assert.isNotNull((Object)id);
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.compilationunit")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.enum.constant")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.field")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.java.project")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.local.variable")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.method")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.package")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.resource")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.source.folder")) {
            return true;
        }
        if (id.equals("org.eclipse.wst.jsdt.ui.rename.type")) {
            return true;
        }
        return id.equals("org.eclipse.wst.jsdt.ui.rename.type.parameter");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("name", this.fName);
        if (this.getID().equals("org.eclipse.wst.jsdt.ui.rename.type.parameter")) {
            ITypeParameter parameter = (ITypeParameter)this.fJavaElement;
            this.fArguments.put("input", RenameJavaElementDescriptor.elementToHandle(this.getProject(), (IJavaElement)parameter.getDeclaringMember()));
            this.fArguments.put(ATTRIBUTE_PARAMETER, parameter.getElementName());
        } else {
            this.fArguments.put("input", RenameJavaElementDescriptor.elementToHandle(this.getProject(), this.fJavaElement));
        }
        int type = this.fJavaElement.getElementType();
        if (type != 3) {
            this.fArguments.put("references", Boolean.toString(this.fReferences));
        }
        if (type == 8) {
            this.fArguments.put(ATTRIBUTE_RENAME_GETTER, Boolean.toString(this.fRenameGetter));
            this.fArguments.put(ATTRIBUTE_RENAME_SETTER, Boolean.toString(this.fRenameSetter));
        }
        switch (type) {
            case 4: 
            case 7: 
            case 8: {
                this.fArguments.put(ATTRIBUTE_TEXTUAL_MATCHES, Boolean.toString(this.fTextual));
                break;
            }
        }
        switch (type) {
            case 8: 
            case 9: {
                this.fArguments.put(ATTRIBUTE_DEPRECATE, Boolean.toString(this.fDeprecate));
                this.fArguments.put(ATTRIBUTE_DELEGATE, Boolean.toString(this.fDelegate));
                break;
            }
        }
        switch (type) {
            case 4: 
            case 7: {
                this.fArguments.put(ATTRIBUTE_QUALIFIED, Boolean.toString(this.fQualified));
                if (this.fPatterns == null || "".equals(this.fPatterns)) break;
                this.fArguments.put(ATTRIBUTE_PATTERNS, this.fPatterns);
                break;
            }
        }
        switch (type) {
            case 7: {
                this.fArguments.put(ATTRIBUTE_SIMILAR_DECLARATIONS, Boolean.toString(this.fSimilarDeclarations));
                this.fArguments.put(ATTRIBUTE_MATCH_STRATEGY, Integer.toString(this.fMatchStrategy));
                break;
            }
        }
        switch (type) {
            case 4: {
                this.fArguments.put(ATTRIBUTE_HIERARCHICAL, Boolean.toString(this.fHierarchical));
                break;
            }
        }
    }

    public void setDeprecateDelegate(boolean deprecate) {
        this.fDeprecate = deprecate;
    }

    public void setFileNamePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        Assert.isLegal((!"".equals(patterns) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = patterns;
    }

    public void setJavaElement(IJavaElement element) {
        Assert.isNotNull((Object)element);
        this.fJavaElement = element;
    }

    public void setKeepOriginal(boolean delegate) {
        this.fDelegate = delegate;
    }

    public void setMatchStrategy(int strategy) {
        Assert.isLegal((strategy == 1 || strategy == 2 || strategy == 3 ? 1 : 0) != 0, (String)"Wrong match strategy argument");
        this.fMatchStrategy = strategy;
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public void setRenameGetters(boolean rename) {
        this.fRenameGetter = rename;
    }

    public void setRenameSetters(boolean rename) {
        this.fRenameSetter = rename;
    }

    public void setUpdateHierarchy(boolean update) {
        this.fHierarchical = update;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fQualified = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        this.fSimilarDeclarations = update;
    }

    public void setUpdateTextualOccurrences(boolean update) {
        this.fTextual = update;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fName == null || "".equals(this.fName)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fJavaElement == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_no_java_element));
        } else {
            int type = this.fJavaElement.getElementType();
            if (type == 2 && this.getProject() != null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_project_constraint));
            }
            if (type == 3 && this.fReferences) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_reference_constraint));
            }
            if (this.fTextual) {
                switch (type) {
                    case 4: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_textual_constraint));
                    }
                }
            }
            if (this.fDeprecate) {
                switch (type) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_deprecation_constraint));
                    }
                }
            }
            if (this.fDelegate) {
                switch (type) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_delegate_constraint));
                    }
                }
            }
            if ((this.fRenameGetter || this.fRenameSetter) && type != 8) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_accessor_constraint));
            }
            if (this.fQualified) {
                switch (type) {
                    case 4: 
                    case 7: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_qualified_constraint));
                    }
                }
            }
            if (this.fSimilarDeclarations) {
                switch (type) {
                    case 7: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_similar_constraint));
                    }
                }
            }
            if (this.fHierarchical) {
                switch (type) {
                    case 4: {
                        break;
                    }
                    default: {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_hierarchical_constraint));
                    }
                }
            }
        }
        return status;
    }
}

