/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class RenameLocalVariableDescriptor
extends JavaRefactoringDescriptor {
    private String fName = null;
    private boolean fReferences = false;
    private ISourceRange fSelection = null;
    private ICompilationUnit fUnit = null;

    public RenameLocalVariableDescriptor() {
        super("org.eclipse.wst.jsdt.ui.rename.local.variable");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("name", this.fName);
        this.fArguments.put("input", RenameLocalVariableDescriptor.elementToHandle(this.getProject(), (IJavaElement)this.fUnit));
        this.fArguments.put("selection", String.valueOf(new Integer(this.fSelection.getOffset()).toString()) + " " + new Integer(this.fSelection.getLength()).toString());
        this.fArguments.put("references", Boolean.toString(this.fReferences));
    }

    public void setCompilationUnit(ICompilationUnit unit) {
        Assert.isNotNull((Object)unit);
        this.fUnit = unit;
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    public void setSelection(ISourceRange selection) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fName == null || "".equals(this.fName)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fUnit == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameLocalVariableDescriptor_no_compilation_unit));
        }
        if (this.fSelection == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameLocalVariableDescriptor_no_selection));
        }
        return status;
    }
}

