/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AddDocumentationCommand
extends BaseCommand {
    XSDAnnotation xsdAnnotation;
    XSDConcreteComponent input;
    String newValue;
    String oldValue;
    boolean documentationExists;
    Element documentationElement;

    public AddDocumentationCommand(String label, XSDAnnotation xsdAnnotation, XSDConcreteComponent input, String newValue, String oldValue) {
        super(label);
        this.xsdAnnotation = xsdAnnotation;
        this.input = input;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (this.input instanceof XSDSchema) {
            AddDocumentationCommand.ensureSchemaElement((XSDSchema)this.input);
        }
        try {
            block13: {
                try {
                    this.beginRecording(this.input.getElement());
                    this.xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.input, true);
                    Element element = this.xsdAnnotation.getElement();
                    EList documentationList = this.xsdAnnotation.getUserInformation();
                    this.documentationElement = null;
                    this.documentationExists = false;
                    if (documentationList.size() > 0) {
                        this.documentationExists = true;
                        this.documentationElement = (Element)documentationList.get(0);
                    }
                    if (this.documentationElement == null) {
                        this.documentationElement = this.xsdAnnotation.createUserInformation(null);
                        element.appendChild(this.documentationElement);
                        this.formatChild(this.documentationElement);
                        this.xsdAnnotation.updateElement();
                        this.xsdAnnotation.setElement(element);
                    }
                    if (this.documentationElement.hasChildNodes()) {
                        if (!(this.documentationElement instanceof IDOMElement)) break block13;
                        IDOMElement domElement = (IDOMElement)this.documentationElement;
                        Node firstChild = this.documentationElement.getFirstChild();
                        Node lastChild = this.documentationElement.getLastChild();
                        int start = 0;
                        int end = 0;
                        IDOMNode first = null;
                        if (firstChild instanceof IDOMNode) {
                            first = (IDOMNode)firstChild;
                            start = first.getStartOffset();
                        }
                        if (lastChild instanceof IDOMNode) {
                            IDOMNode last = (IDOMNode)lastChild;
                            end = last.getEndOffset();
                        }
                        if (domElement != null) {
                            this.oldValue = domElement.getModel().getStructuredDocument().get(start, end - start);
                            domElement.getModel().getStructuredDocument().replaceText((Object)this.documentationElement, start, end - start, this.newValue);
                        }
                        break block13;
                    }
                    if (this.newValue.length() > 0) {
                        this.oldValue = "";
                        Text childNode = this.documentationElement.getOwnerDocument().createTextNode(this.newValue);
                        this.documentationElement.appendChild(childNode);
                    }
                }
                catch (Exception exception) {}
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endRecording();
            throw throwable;
        }
        this.endRecording();
    }

    public void undo() {
        super.undo();
    }
}

