/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.apache.xerces.util.XMLChar;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.RefactoringSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewTypeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class XSDAttributeDeclarationSection
extends RefactoringSection {
    protected Text nameText;
    protected Text defaultOrFixedText;
    protected CCombo componentNameCombo;
    protected CCombo typeCombo;
    protected CCombo usageCombo;
    protected CCombo formCombo;
    protected Button defaultButton;
    protected Button fixedButton;
    protected String typeName = "";
    protected String refName = "";
    boolean isAttributeReference;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        String typeLabel = org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_LABEL_TYPE;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_NAME);
        nameLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        this.nameText.setLayoutData((Object)data);
        this.nameText.setEnabled(!this.isAttributeReference);
        this.applyAllListeners((Control)this.nameText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, "org.eclipse.wst.xsd.ui.xsdup0320");
        this.createRenameHyperlink(this.composite);
        this.setRenameHyperlinkEnabled(!this.isAttributeReference);
        if (this.isAttributeReference) {
            data = new GridData();
            data.horizontalAlignment = 32;
            data.grabExcessHorizontalSpace = false;
            CLabel refLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_LABEL_REFERENCE);
            refLabel.setLayoutData((Object)data);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            this.componentNameCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
            this.componentNameCombo.addSelectionListener((SelectionListener)this);
            this.componentNameCombo.setLayoutData((Object)data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.componentNameCombo, "org.eclipse.wst.xsd.ui.xsdup0320");
            this.getWidgetFactory().createCLabel(this.composite, "");
        }
        this.getWidgetFactory().createCLabel(this.composite, typeLabel);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.typeCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.typeCombo, "org.eclipse.wst.xsd.ui.xsdup0330");
        this.getWidgetFactory().createCLabel(this.composite, "");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel useLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_USAGE"));
        useLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.usageCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.usageCombo.setLayoutData((Object)data);
        this.usageCombo.addSelectionListener((SelectionListener)this);
        this.usageCombo.add("");
        this.usageCombo.add("required");
        this.usageCombo.add("optional");
        this.usageCombo.add("prohibited");
        this.usageCombo.addSelectionListener((SelectionListener)this);
        this.getWidgetFactory().createCLabel(this.composite, "");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel defaultLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_VALUE_COLON);
        defaultLabel.setLayoutData((Object)data);
        Composite radio = this.getWidgetFactory().createComposite(this.composite);
        radio.setLayout((Layout)new RowLayout());
        this.defaultButton = new Button(radio, 16);
        this.defaultButton.setText(Messages._UI_DEFAULT);
        this.defaultButton.setBackground(parent.getBackground());
        this.defaultButton.addSelectionListener((SelectionListener)this);
        this.fixedButton = new Button(radio, 16);
        this.fixedButton.setText(Messages._UI_FIXED);
        this.fixedButton.setBackground(parent.getBackground());
        this.fixedButton.addSelectionListener((SelectionListener)this);
        this.getWidgetFactory().createCLabel(this.composite, "");
        this.getWidgetFactory().createCLabel(this.composite, "");
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.defaultOrFixedText = this.getWidgetFactory().createText(this.composite, "");
        this.defaultOrFixedText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.defaultOrFixedText);
        this.getWidgetFactory().createCLabel(this.composite, "");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel formLabel = this.getWidgetFactory().createCLabel(this.composite, Messages._UI_FORM);
        formLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.formCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.formCombo.setLayoutData((Object)data);
        this.formCombo.addSelectionListener((SelectionListener)this);
        this.formCombo.add("");
        this.formCombo.add("qualified");
        this.formCombo.add("unqualified");
        this.formCombo.addSelectionListener((SelectionListener)this);
        this.getWidgetFactory().createCLabel(this.composite, "");
    }

    private void fillTypesCombo() {
        XSDTypeReferenceEditManager manager;
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (XSDTypeReferenceEditManager)editor.getAdapter((Class)clazz)) != null) {
            String currentTypeName;
            ComponentSpecification ret;
            ComponentSpecification[] items = manager.getQuickPicks();
            this.typeCombo.removeAll();
            this.typeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
            this.typeCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
            int i = 0;
            while (i < items.length) {
                this.typeCombo.add(items[i].getName());
                ++i;
            }
            XSDAttributeDeclaration namedComponent = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration();
            XSDTypeDefinition namedComponentType = namedComponent.getType();
            if (namedComponentType != null && (ret = this.getComponentSpecFromQuickPickForValue(currentTypeName = namedComponentType.getQName((XSDConcreteComponent)this.xsdSchema), manager)) == null) {
                this.typeCombo.add(currentTypeName);
            }
        }
    }

    private ComponentSpecification getComponentSpecFromQuickPickForValue(String value, ComponentReferenceEditManager editManager) {
        ComponentSpecification[] quickPicks;
        if (editManager != null && (quickPicks = editManager.getQuickPicks()) != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                if (value.equals(componentSpecification.getName())) {
                    return componentSpecification;
                }
                ++i;
            }
        }
        return null;
    }

    public void refresh() {
        XSDAttributeDeclaration namedComponent;
        String name;
        super.refresh();
        this.setListenerEnabled(false);
        this.nameText.setText("");
        if (this.input instanceof XSDAttributeDeclaration && (name = (namedComponent = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration()).getName()) != null) {
            this.nameText.setText(name);
        }
        if (this.isAttributeReference) {
            this.refreshRefCombo();
        }
        this.typeCombo.setText("");
        if (this.input != null && this.input instanceof XSDAttributeDeclaration) {
            boolean isAnonymous;
            XSDAttributeDeclaration xsdAttribute = (XSDAttributeDeclaration)this.input;
            this.isAttributeReference = ((XSDAttributeDeclaration)this.input).isAttributeDeclarationReference();
            XSDSimpleTypeDefinition typeDef = xsdAttribute.getResolvedAttributeDeclaration().getTypeDefinition();
            boolean bl = isAnonymous = xsdAttribute.getAnonymousTypeDefinition() != null;
            if (isAnonymous) {
                this.typeCombo.setText("**anonymous**");
            } else {
                this.fillTypesCombo();
                if (typeDef != null) {
                    this.typeName = typeDef.getQName((XSDConcreteComponent)this.xsdSchema);
                    if (this.typeName == null) {
                        this.typeName = "";
                    }
                    this.typeCombo.setText(this.typeName);
                } else {
                    this.typeCombo.setText(org.eclipse.wst.xsd.ui.internal.editor.Messages.UI_NO_TYPE);
                }
            }
            this.usageCombo.setText("");
            this.usageCombo.setEnabled(!xsdAttribute.isGlobal());
            Element element = xsdAttribute.getElement();
            boolean hasUseAttribute = false;
            if (element != null && (hasUseAttribute = element.hasAttribute("use"))) {
                String usage = element.getAttribute("use");
                this.usageCombo.setText(usage);
            }
            this.defaultOrFixedText.setText("");
            boolean hasDefaultAttribute = false;
            boolean hasFixedAttribute = false;
            if (element != null) {
                hasDefaultAttribute = element.hasAttribute("default");
                hasFixedAttribute = element.hasAttribute("fixed");
                if (!hasDefaultAttribute && !hasFixedAttribute) {
                    if (!this.defaultButton.getSelection() && !this.fixedButton.getSelection()) {
                        this.fixedButton.setSelection(true);
                    }
                } else {
                    this.defaultButton.setSelection(!hasFixedAttribute && hasDefaultAttribute);
                    this.fixedButton.setSelection(hasFixedAttribute);
                    if (hasDefaultAttribute) {
                        String theDefault = element.getAttribute("default");
                        this.defaultOrFixedText.setText(theDefault);
                    }
                    if (hasFixedAttribute) {
                        String fixed = element.getAttribute("fixed");
                        this.defaultOrFixedText.setText(fixed);
                    }
                }
            }
            this.formCombo.setText("");
            this.formCombo.setEnabled(!xsdAttribute.isGlobal() && !this.isAttributeReference);
            boolean hasFormAttribute = false;
            if (element != null && (hasFormAttribute = element.hasAttribute("form"))) {
                String form = element.getAttribute("form");
                this.formCombo.setText(form);
            }
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.typeCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDTypeReferenceEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.typeCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
                ((XSDSearchListDialogDelegate)dialog).showComplexTypes(false);
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
                ((NewTypeDialog)dialog).allowComplexType(false);
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    XSDAttributeDeclaration xsdAttribute = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration();
                    manager.modifyComponentReference(xsdAttribute, newValue);
                } else {
                    this.typeCombo.setText(this.typeName);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        } else if (e.widget == this.componentNameCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDAttributeReferenceEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.componentNameCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
            } else if (selection.equals(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                } else {
                    this.componentNameCombo.setText(this.refName);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        } else {
            XSDAttributeDeclaration xsdAttribute = (XSDAttributeDeclaration)this.input;
            Element element = xsdAttribute.getElement();
            if (e.widget == this.usageCombo) {
                String newValue = this.usageCombo.getText();
                if (element != null) {
                    if (newValue.length() == 0) {
                        element.removeAttribute("use");
                    } else {
                        element.setAttribute("use", newValue);
                    }
                }
            } else if (e.widget == this.formCombo) {
                String newValue = this.formCombo.getText();
                if (element != null) {
                    if (newValue.length() == 0) {
                        element.removeAttribute("form");
                    } else {
                        element.setAttribute("form", newValue);
                    }
                }
            } else if (e.widget == this.defaultButton) {
                boolean newValue = this.defaultButton.getSelection();
                if (element != null && newValue && element.hasAttribute("fixed")) {
                    String value = element.getAttribute("fixed");
                    element.removeAttribute("fixed");
                    element.setAttribute("default", value);
                }
            } else if (e.widget == this.fixedButton) {
                boolean newValue = this.fixedButton.getSelection();
                if (element != null && newValue && element.hasAttribute("default")) {
                    String value = element.getAttribute("default");
                    element.removeAttribute("default");
                    element.setAttribute("fixed", value);
                }
            }
        }
        super.doWidgetSelected(e);
    }

    protected void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.nameText) {
            if (!this.nameText.getEditable()) {
                return;
            }
            String newValue = this.nameText.getText().trim();
            if (this.input instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration namedComponent = ((XSDAttributeDeclaration)this.input).getResolvedAttributeDeclaration();
                if (!this.validateSection()) {
                    return;
                }
                UpdateNameCommand command = null;
                String oldName = namedComponent.getName();
                if (!newValue.equals(oldName)) {
                    command = new UpdateNameCommand(Messages._UI_ACTION_RENAME, (XSDNamedComponent)namedComponent, newValue);
                }
                if (command != null && this.getCommandStack() != null) {
                    this.getCommandStack().execute((Command)command);
                }
                if (this.isAttributeReference) {
                    XSDAttributeDeclaration attrRef = (XSDAttributeDeclaration)this.input;
                    String qname = attrRef.getResolvedAttributeDeclaration().getQName();
                    attrRef.getElement().setAttribute("ref", qname);
                }
            }
        } else if (event.widget == this.defaultOrFixedText) {
            XSDAttributeDeclaration xsdAttribute = (XSDAttributeDeclaration)this.input;
            String newValue = this.defaultOrFixedText.getText();
            Element element = xsdAttribute.getElement();
            if (element != null) {
                if (newValue.length() == 0) {
                    element.removeAttribute("default");
                    element.removeAttribute("fixed");
                } else {
                    element.removeAttribute(this.fixedButton.getSelection() ? "default" : "fixed");
                    element.setAttribute(this.fixedButton.getSelection() ? "fixed" : "default", newValue);
                }
            }
        }
    }

    protected boolean validateSection() {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return true;
        }
        this.setErrorMessage(null);
        String name = this.nameText.getText().trim();
        if (name.length() < 1 || !XMLChar.isValidNCName((String)name)) {
            this.setErrorMessage(Messages._UI_ERROR_INVALID_NAME);
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.componentNameCombo != null && !this.componentNameCombo.isDisposed()) {
            this.componentNameCombo.removeSelectionListener((SelectionListener)this);
        }
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.removeListeners((Control)this.nameText);
        }
        if (this.typeCombo != null && !this.typeCombo.isDisposed()) {
            this.typeCombo.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.setListenerEnabled(false);
        this.init();
        this.relayout();
        this.setListenerEnabled(true);
    }

    protected void init() {
        if (this.input instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration xsdAttribute = (XSDAttributeDeclaration)this.input;
            this.isAttributeReference = xsdAttribute.isAttributeDeclarationReference();
        }
    }

    protected void relayout() {
        Composite parentComposite = this.composite.getParent();
        parentComposite.getParent().setRedraw(false);
        if (parentComposite != null && !parentComposite.isDisposed()) {
            Control[] children = parentComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createContents(parentComposite);
        parentComposite.getParent().layout(true, true);
        parentComposite.getParent().setRedraw(true);
        this.refresh();
    }

    protected void refreshRefCombo() {
        this.componentNameCombo.setText("");
        this.fillComponentNameCombo();
    }

    private void fillComponentNameCombo() {
        XSDAttributeDeclaration namedComponent;
        Element element;
        ComponentSpecification[] history;
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDAttributeReferenceEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
        this.componentNameCombo.removeAll();
        this.componentNameCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_BROWSE);
        this.componentNameCombo.add(org.eclipse.wst.xsd.ui.internal.editor.Messages._UI_ACTION_NEW);
        ComponentSpecification[] quickPicks = manager.getQuickPicks();
        if (quickPicks != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                this.componentNameCombo.add(componentSpecification.getName());
                ++i;
            }
        }
        if ((history = manager.getHistory()) != null) {
            int i = 0;
            while (i < history.length) {
                ComponentSpecification componentSpecification = history[i];
                this.componentNameCombo.add(componentSpecification.getName());
                ++i;
            }
        }
        if ((element = (namedComponent = (XSDAttributeDeclaration)this.input).getElement()) != null) {
            ComponentSpecification ret;
            String attrValue = element.getAttribute("ref");
            if (attrValue == null) {
                attrValue = "";
            }
            if ((ret = this.getComponentSpecFromQuickPickForValue(attrValue, manager)) == null) {
                this.componentNameCombo.add(attrValue);
            }
            this.componentNameCombo.setText(attrValue);
            this.refName = attrValue;
        }
    }
}

