/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class XSDElementDeclarationAdvancedSection
extends AbstractSection {
    private static final String EMPTY = "";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected CCombo blockCombo;
    protected CCombo finalCombo;
    protected CCombo abstractCombo;
    protected CCombo substGroupCombo;
    private String[] blockValues = new String[]{"", "#all", "extension", "restriction", "substitution"};
    private String[] finalValues = new String[]{"", "#all", "extension", "restriction"};
    private String[] abstractValues = new String[]{"", "true", "false"};
    static /* synthetic */ Class class$0;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel abstractLabel = this.getWidgetFactory().createCLabel(this.composite, "abstract:");
        abstractLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.abstractCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.abstractCombo.setLayoutData((Object)data);
        this.abstractCombo.setEditable(false);
        this.abstractCombo.setItems(this.abstractValues);
        this.abstractCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel blockLabel = this.getWidgetFactory().createCLabel(this.composite, "block:");
        blockLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.blockCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.blockCombo.setLayoutData((Object)data);
        this.blockCombo.setEditable(false);
        this.blockCombo.setItems(this.blockValues);
        this.blockCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel finalLabel = this.getWidgetFactory().createCLabel(this.composite, "final:");
        finalLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.finalCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.finalCombo.setLayoutData((Object)data);
        this.finalCombo.setEditable(false);
        this.finalCombo.setItems(this.finalValues);
        this.finalCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel subGroupLabel = this.getWidgetFactory().createCLabel(this.composite, "substitutionGroup:");
        subGroupLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.substGroupCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.substGroupCombo.setLayoutData((Object)data);
        this.substGroupCombo.setEditable(true);
        this.substGroupCombo.addSelectionListener((SelectionListener)this);
        this.applyAllListeners((Control)this.substGroupCombo);
    }

    public void doHandleEvent(Event e) {
        if (e.widget == this.substGroupCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.substGroupCombo.getText();
            String oldValue = eleDec.getElement().getAttribute("substitutionGroup");
            if (oldValue == null) {
                oldValue = EMPTY;
            }
            if (value.equals(oldValue)) {
                return;
            }
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "substitutionGroup", value);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.blockCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.blockCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "block", value);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.finalCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.finalCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(eleDec.getElement(), "final", value);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.abstractCombo) {
            XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
            String value = this.abstractCombo.getText();
            if (value.equals(EMPTY)) {
                eleDec.getElement().removeAttribute("abstract");
            } else if (value.equals(TRUE)) {
                eleDec.setAbstract(true);
            } else if (value.equals(FALSE)) {
                eleDec.setAbstract(false);
            }
        } else if (e.widget == this.substGroupCombo) {
            IEditorPart editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDSubstitutionGroupEditManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ComponentReferenceEditManager manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz);
            String selection = this.substGroupCombo.getText();
            IComponentDialog dialog = null;
            if (selection.equals(Messages._UI_ACTION_BROWSE)) {
                dialog = manager.getBrowseDialog();
            } else if (selection.equals(Messages._UI_ACTION_NEW)) {
                dialog = manager.getNewDialog();
            }
            if (dialog != null) {
                if (dialog.createAndOpen() == 0) {
                    ComponentSpecification newValue = dialog.getSelectedComponent();
                    manager.modifyComponentReference(this.input, newValue);
                } else {
                    this.substGroupCombo.setText(EMPTY);
                }
            } else {
                ComponentSpecification newValue = this.getComponentSpecFromQuickPickForValue(selection, manager);
                if (newValue != null) {
                    manager.modifyComponentReference(this.input, newValue);
                }
            }
        }
    }

    public void refresh() {
        super.refresh();
        this.fillSubstitutionGroupCombo();
        this.setListenerEnabled(false);
        try {
            if (this.input instanceof XSDElementDeclaration) {
                XSDElementDeclaration eleDec = (XSDElementDeclaration)this.input;
                this.composite.setEnabled(!this.isReadOnly);
                if (eleDec.getContainer() instanceof XSDSchema) {
                    this.abstractCombo.setEnabled(true);
                    this.finalCombo.setEnabled(true);
                    this.substGroupCombo.setEnabled(true);
                } else {
                    this.abstractCombo.setEnabled(false);
                    this.finalCombo.setEnabled(false);
                    this.substGroupCombo.setEnabled(false);
                }
                Element element = eleDec.getElement();
                String blockAttValue = element.getAttribute("block");
                if (blockAttValue != null) {
                    this.blockCombo.setText(blockAttValue);
                } else {
                    this.blockCombo.setText(EMPTY);
                }
                String finalAttValue = element.getAttribute("final");
                if (finalAttValue != null) {
                    this.finalCombo.setText(finalAttValue);
                } else {
                    this.finalCombo.setText(EMPTY);
                }
                if (element.hasAttribute("abstract")) {
                    boolean absAttValue = eleDec.isAbstract();
                    if (absAttValue) {
                        this.abstractCombo.setText(TRUE);
                    } else {
                        this.abstractCombo.setText(FALSE);
                    }
                } else {
                    this.abstractCombo.setText(EMPTY);
                }
                if (element.hasAttribute("substitutionGroup")) {
                    this.substGroupCombo.setText(element.getAttribute("substitutionGroup"));
                } else {
                    this.substGroupCombo.setText(EMPTY);
                }
            }
        }
        catch (Exception exception) {}
        this.setListenerEnabled(true);
    }

    private void fillSubstitutionGroupCombo() {
        ComponentReferenceEditManager manager;
        IEditorPart editor = this.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDSubstitutionGroupEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (ComponentReferenceEditManager)editor.getAdapter((Class)clazz)) != null) {
            ComponentSpecification ret;
            ComponentSpecification[] items = manager.getQuickPicks();
            this.substGroupCombo.removeAll();
            this.substGroupCombo.add(Messages._UI_ACTION_BROWSE);
            this.substGroupCombo.add(Messages._UI_ACTION_NEW);
            int i = 0;
            while (i < items.length) {
                this.substGroupCombo.add(items[i].getName());
                ++i;
            }
            XSDElementDeclaration namedComponent = ((XSDElementDeclaration)this.input).getSubstitutionGroupAffiliation();
            if (namedComponent != null && (ret = this.getComponentSpecFromQuickPickForValue(namedComponent.getName(), manager)) == null) {
                this.substGroupCombo.add(namedComponent.getQName((XSDConcreteComponent)this.xsdSchema));
            }
        }
    }

    private ComponentSpecification getComponentSpecFromQuickPickForValue(String value, ComponentReferenceEditManager editManager) {
        ComponentSpecification[] quickPicks;
        if (editManager != null && (quickPicks = editManager.getQuickPicks()) != null) {
            int i = 0;
            while (i < quickPicks.length) {
                ComponentSpecification componentSpecification = quickPicks[i];
                if (value != null && value.equals(componentSpecification.getName())) {
                    return componentSpecification;
                }
                ++i;
            }
        }
        return null;
    }
}

