/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.core.search.SearchEngine;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.core.search.scope.SelectionSearchScope;
import org.eclipse.wst.common.core.search.scope.WorkspaceSearchScope;
import org.eclipse.wst.common.core.search.util.CollectingSearchRequestor;
import org.eclipse.wst.xml.core.internal.search.XMLComponentDeclarationPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentReferencePattern;
import org.eclipse.wst.xsd.ui.internal.refactor.Checks;
import org.eclipse.wst.xsd.ui.internal.refactor.INameUpdating;
import org.eclipse.wst.xsd.ui.internal.refactor.IReferenceUpdating;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.TextChangeManager;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.ComponentRenameArguments;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.SortingSearchRequestor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.XMLComponentRenameParticipant;
import org.eclipse.wst.xsd.ui.internal.refactor.util.TextChangeCompatibility;

public class RenameComponentProcessor
extends RenameProcessor
implements INameUpdating,
IReferenceUpdating {
    public static final String IDENTIFIER = "org.eclipse.wst.xml.refactor.renameComponentProcessor";
    private boolean singleFileOnly = false;
    private TextChangeManager changeManager;
    private String newName;
    private RefactoringComponent selectedComponent;
    private boolean updateReferences = true;
    private Map references = new HashMap();

    public static String quoteString(String value) {
        value = value == null ? "" : value;
        StringBuffer sb = new StringBuffer();
        if (!value.startsWith("\"")) {
            sb.append("\"");
        }
        sb.append(value);
        if (!value.endsWith("\"")) {
            sb.append("\"");
        }
        return sb.toString();
    }

    public RenameComponentProcessor(RefactoringComponent selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    public RenameComponentProcessor(RefactoringComponent selectedComponent, String newName) {
        this(selectedComponent, newName, false);
    }

    public RenameComponentProcessor(RefactoringComponent selectedComponent, String newName, boolean singleFileOnly) {
        this.newName = newName;
        this.selectedComponent = selectedComponent;
        this.singleFileOnly = singleFileOnly;
    }

    private void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String fileStr = this.selectedComponent.getElement().getModel().getBaseLocation();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileStr));
        this.addDeclarationUpdate(manager, file);
    }

    final void addDeclarationUpdate(TextChangeManager manager, IFile file) throws CoreException {
        String componentName = this.selectedComponent.getName();
        String componentNamespace = this.selectedComponent.getNamespaceURI();
        QualifiedName elementQName = new QualifiedName(componentNamespace, componentName);
        QualifiedName typeQName = this.selectedComponent.getTypeQName();
        WorkspaceSearchScope scope = new WorkspaceSearchScope();
        if (file != null) {
            scope = new SelectionSearchScope(new IResource[]{file});
        }
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        XMLComponentDeclarationPattern pattern = new XMLComponentDeclarationPattern(file, elementQName, typeQName);
        SearchEngine searchEngine = new SearchEngine();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (this.singleFileOnly) {
            map.put("searchDirtyContent", Boolean.TRUE);
        }
        searchEngine.search((SearchPattern)pattern, (SearchRequestor)requestor, (SearchScope)scope, map, (IProgressMonitor)new NullProgressMonitor());
        List results = requestor.getResults();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            SearchMatch match = (SearchMatch)iter.next();
            if (match == null) continue;
            TextChange textChange = manager.get(match.getFile());
            String newName = this.getNewElementName();
            newName = RenameComponentProcessor.quoteString(newName);
            ReplaceEdit replaceEdit = new ReplaceEdit(match.getOffset(), match.getLength(), newName);
            String editName = RefactoringMessages.getString("RenameComponentProcessor.Component_Refactoring_update_declatation");
            TextChangeCompatibility.addTextEdit(textChange, editName, (TextEdit)replaceEdit);
        }
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        String fileStr = this.selectedComponent.getElement().getModel().getBaseLocation();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileStr));
        String componentName = this.selectedComponent.getName();
        String componentNamespace = this.selectedComponent.getNamespaceURI();
        QualifiedName elementQName = new QualifiedName(componentNamespace, componentName);
        QualifiedName typeQName = this.selectedComponent.getTypeQName();
        SearchEngine searchEngine = new SearchEngine();
        WorkspaceSearchScope scope = null;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (this.singleFileOnly) {
            map.put("searchDirtyContent", Boolean.TRUE);
            scope = new SelectionSearchScope(new IResource[]{file});
        } else {
            scope = new WorkspaceSearchScope();
        }
        SortingSearchRequestor requestor = new SortingSearchRequestor();
        XMLComponentReferencePattern pattern = new XMLComponentReferencePattern(file, elementQName, typeQName);
        searchEngine.search((SearchPattern)pattern, (SearchRequestor)requestor, (SearchScope)scope, map, (IProgressMonitor)new NullProgressMonitor());
        this.references = requestor.getResults();
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)context);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 2);
            monitor.setTaskName("RefactoringMessages.RenameComponentRefactoring_checking");
            status.merge(this.checkNewElementName(this.getNewElementName()));
            monitor.worked(1);
            monitor.setTaskName("RefactoringMessages.RenameComponentRefactoring_searching");
            status.merge(this.createRenameChanges((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        Assert.isNotNull((Object)pm);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public final RefactoringStatus checkNewElementName(String name) {
        Assert.isNotNull((Object)name);
        RefactoringStatus result = Checks.checkName(name);
        result.merge(Checks.checkComponentName(name));
        if (Checks.isAlreadyNamed(this.selectedComponent, name)) {
            result.addFatalError("RefactoringMessages.RenameComponentRefactoring_another_name");
        }
        return result;
    }

    private Object[] computeDerivedElements() {
        Object[] elements = this.getElements();
        return elements;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private TextChangeManager updateChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager manager = this.getChangeManager();
        this.addDeclarationUpdate(manager);
        if (this.getUpdateReferences()) {
            this.addOccurrences(manager, pm, status);
        }
        return manager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus createRenameChanges(IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("RefactoringMessages.RenameComponentRefactoring_searching", 1);
            this.updateChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return status;
    }

    public TextChangeManager getChangeManager() {
        if (this.changeManager == null) {
            this.changeManager = new TextChangeManager(false);
        }
        return this.changeManager;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[]{"org.eclipse.jdt.core.javanature"};
    }

    public String getCurrentElementName() {
        return this.selectedComponent.getName();
    }

    public Object[] getElements() {
        Object model = this.selectedComponent.getModelObject();
        if (model != null) {
            return new Object[]{model};
        }
        return new Object[0];
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getNewElementName() {
        return this.newName;
    }

    public String getProcessorName() {
        return RefactoringMessages.getFormattedString("RenameComponentRefactoring.name", new String[]{String.valueOf(this.selectedComponent.getNamespaceURI()) + ":" + this.selectedComponent.getName(), this.newName});
    }

    public boolean getUpdateReferences() {
        return this.updateReferences;
    }

    public boolean isApplicable() throws CoreException {
        return this.selectedComponent != null;
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, Object[] derivedElements, ComponentRenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        if (derivedElements != null) {
            int i = 0;
            while (i < derivedElements.length) {
                RenameParticipant[] participants = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)derivedElements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(participants));
                ++i;
            }
        }
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        ComponentRenameArguments arguments = new ComponentRenameArguments(this.getNewElementName(), this.getUpdateReferences());
        arguments.setMatches(this.references);
        arguments.setQualifier(this.selectedComponent.getNamespaceURI());
        arguments.setChangeManager(this.getChangeManager());
        this.loadDerivedParticipants(status, result, this.computeDerivedElements(), arguments, natures, shared);
    }

    protected void loadElementParticipants(RefactoringStatus status, List result, RenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        Object[] elements = new Object[]{};
        int i = 0;
        while (i < elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        String[] natures = this.getAffectedProjectNatures();
        ArrayList result = new ArrayList();
        this.loadElementParticipants(status, result, arguments, natures, sharedParticipants);
        this.loadDerivedParticipants(status, result, natures, sharedParticipants);
        Iterator i = result.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof XMLComponentRenameParticipant)) continue;
            XMLComponentRenameParticipant p = (XMLComponentRenameParticipant)((Object)o);
            p.setChangeManager(this.getChangeManager());
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newName = newName;
    }

    public void setUpdateReferences(boolean update) {
        this.updateReferences = update;
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        block3: {
            CompositeChange compositeChange;
            Assert.isNotNull((Object)pm);
            try {
                String changeName = RefactoringMessages.getString("RenameComponentProcessor.Component_Refactoring_updates");
                TextChange[] changes = this.changeManager.getAllChanges();
                if (changes.length <= 0) break block3;
                CompositeChange compositeChange2 = new CompositeChange("!" + changeName, (Change[])changes);
                compositeChange2.markAsSynthetic();
                compositeChange = compositeChange2;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return compositeChange;
        }
        Object var6_8 = null;
        pm.done();
        return null;
    }
}

