/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseFigureDecorator;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IBaseFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class LinkFigure
extends PolylineConnection
implements IBaseFigure {
    private static final Color defaultLineColor = ColorConstants.black;
    private static final int defaultLineWidth = 1;
    private static final boolean defaultLabelVisible = false;
    private static final Color defaultLabelForeground = ColorConstants.black;
    private static final Color defaultLabelBackground = ColorConstants.white;
    private static final Font defaultFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
    private LinkLabel label;

    public LinkFigure() {
        this.setLineWidth(1);
        this.setForegroundColor(defaultLineColor);
    }

    public void setToolTipText(String text) {
        Label toolTip_ = null;
        if (text != null && text.length() > 0) {
            toolTip_ = new Label(text);
            toolTip_.setBorder((Border)new MarginBorder(3));
        }
        super.setToolTip(toolTip_);
    }

    public String getToolTipText() {
        if (this.getToolTip() != null) {
            return ((Label)this.getToolTip()).getText();
        }
        return null;
    }

    public void setHighlight(boolean flag) {
        if (flag) {
            this.setForegroundColor(ColorConstants.titleBackground);
        } else {
            this.setForegroundColor(defaultLineColor);
        }
    }

    public void setText(String text) {
        if (text == null && text.length() == 0) {
            if (this.label != null) {
                this.remove((IFigure)this.label);
                this.label = null;
            }
        } else {
            this.getLabel().setText(text);
        }
    }

    public String getText() {
        if (this.label == null) {
            return null;
        }
        return this.label.getText();
    }

    public Rectangle getTextBounds() {
        return this.label.getTextBounds();
    }

    public void setIcon(Image image) {
        this.getLabel().setIcon(image);
    }

    public Image getIcon() {
        return this.getLabel().getIcon();
    }

    public void addDecorator(BaseFigureDecorator decorator) {
        int pos = decorator.getPosition();
        if (pos == BaseFigureDecorator.DEFAULT_DECORATOR_POSITION || pos == 8 || pos == 1) {
            this.setTargetDecoration(decorator);
        } else if (pos == 16 || pos == 4) {
            this.setSourceDecoration(decorator);
        }
    }

    public void removeDecorator() {
        this.removeDecorator(BaseFigureDecorator.DEFAULT_DECORATOR_POSITION);
    }

    public void removeDecorator(int position) {
        if (position == BaseFigureDecorator.DEFAULT_DECORATOR_POSITION) {
            this.setTargetDecoration(null);
        } else {
            this.setSourceDecoration(null);
        }
    }

    public List getDecorators() {
        ArrayList<RotatableDecoration> list = new ArrayList<RotatableDecoration>(2);
        RotatableDecoration d = this.getSourceDecoration();
        if (d != null) {
            list.add(d);
        }
        if ((d = this.getTargetDecoration()) != null) {
            list.add(d);
        }
        return list;
    }

    private LinkLabel getLabel() {
        if (this.label == null) {
            this.label = new LinkLabel();
            this.add((IFigure)this.label, new MidpointLocator((Connection)this, 0));
        }
        return this.label;
    }

    public void setFont(Font f) {
        this.getLabel().setFont(f);
    }

    public void setLineWidth(int w) {
        this.getLabel().setBorderWidth(w);
        super.setLineWidth(w);
    }

    public void setForegroundColor(Color c) {
        this.getLabel().setBorderColor(c);
        super.setForegroundColor(c);
    }

    public void setPoints(PointList points) {
        super.setPoints(points);
        if (this.label != null) {
            int i = this.getPoints().size() / 2 - 1;
            if (i < 0) {
                i = 0;
            }
            if (this.getLayoutManager() != null) {
                this.getLayoutManager().setConstraint((IFigure)this.label, (Object)new MidpointLocator((Connection)this, i));
            }
        }
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            if (this.bounds == null) {
                this.bounds = this.getPoints().getBounds().getExpanded(this.lineWidth / 2, this.lineWidth / 2);
            }
            if (this.getLabel().isVisible()) {
                int i = 0;
                while (i < this.getChildren().size()) {
                    IFigure child = (IFigure)this.getChildren().get(i);
                    this.bounds.union(child.getBounds());
                    ++i;
                }
            }
        }
        return this.bounds;
    }

    private static class LinkLabel
    extends Label {
        LinkLabel() {
            this.setBorder((Border)new LineBorder());
            this.setOpaque(true);
            this.setForegroundColor(defaultLabelForeground);
            this.setBackgroundColor(defaultLabelBackground);
            this.setFont(defaultFont);
            LineBorder border_ = new LineBorder(1);
            this.setBorder((Border)border_);
            border_.setColor(defaultLineColor);
            this.setVisible(false);
        }

        void setBorderWidth(int w) {
            ((LineBorder)this.getBorder()).setWidth(w);
        }

        void setBorderColor(Color c) {
            ((LineBorder)this.getBorder()).setColor(c);
        }

        protected boolean useLocalCoordinates() {
            return false;
        }
    }
}

