/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FrameBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jst.jsf.facesconfig.ui.preference.TabbedTitleBarBorder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

final class TabbedWindowBorder
extends FrameBorder {
    private boolean isVisible = true;
    private static MySchemeBorder normalBorder = new MySchemeBorder(new MySchemeBorder.MyScheme(new Color[]{ColorConstants.button, ColorConstants.buttonLightest, ColorConstants.button}, new Color[]{ColorConstants.buttonDarkest, ColorConstants.buttonDarker, ColorConstants.button}));
    private static MySchemeBorder highlightBorder = new MySchemeBorder(new MySchemeBorder.MyScheme(new Color[]{FigureUtilities.lighter((Color)ColorConstants.titleBackground), ColorConstants.titleBackground, FigureUtilities.darker((Color)ColorConstants.titleBackground)}, new Color[]{FigureUtilities.darker((Color)ColorConstants.titleGradient), ColorConstants.titleGradient, FigureUtilities.lighter((Color)ColorConstants.titleGradient)}));
    private Composite comp;

    public TabbedWindowBorder(IFigure parent) {
        this.inner = new TabbedTitleBarBorder(parent);
        this.outer = normalBorder;
    }

    public void setVisible(boolean flag) {
        if (this.isVisible != flag) {
            this.isVisible = flag;
            ((TabbedTitleBarBorder)this.inner).setVisible(flag);
            if (flag) {
                ((TabbedTitleBarBorder)this.inner).getParent().repaint();
            }
        }
    }

    public void setHighlight(boolean flag) {
        this.outer = flag ? highlightBorder : normalBorder;
        ((TabbedTitleBarBorder)this.inner).getParent().repaint();
    }

    protected void createBorders() {
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        if (this.isVisible) {
            if (this.comp != null) {
                GC gc = new GC((Drawable)this.comp);
                this.paint(this.comp, gc, insets);
                gc.dispose();
            } else {
                super.paint(figure, g, insets);
            }
        }
    }

    public void paint(Composite comp_, GC gc, Insets insets) {
        this.comp = comp_;
        if (this.isVisible) {
            ((MySchemeBorder)this.outer).paint(comp_, gc, insets);
        }
    }

    private static class MySchemeBorder
    extends SchemeBorder {
        MySchemeBorder(MyScheme scheme) {
            super((SchemeBorder.Scheme)scheme);
        }

        public MyScheme getMyScheme() {
            return (MyScheme)super.getScheme();
        }

        public void paint(Composite comp, GC gc, Insets insets) {
            Color[] tl = this.getMyScheme().getHighlight();
            Color[] br = this.getMyScheme().getShadow();
            this.paint(comp, gc, insets, tl, br);
        }

        protected void paint(Composite comp, GC gc, Insets insets, Color[] tl, Color[] br) {
            Rectangle rect = comp.getBounds();
            gc.setLineWidth(1);
            gc.setLineStyle(1);
            gc.setXORMode(false);
            int top = rect.y - insets.top;
            int left = rect.x - insets.left;
            int bottom = rect.y + rect.height + insets.bottom;
            int right = rect.x + rect.width + insets.right;
            gc.setClipping(new Rectangle(left, top, right - left, bottom - top));
            Color color = ColorConstants.red;
            gc.setForeground(color);
            gc.drawLine(left, top, right, bottom);
            int i = 0;
            while (i < br.length) {
                gc.setForeground(color);
                gc.drawLine(right - i, bottom - i, right - i, top + i);
                gc.drawLine(right - i, bottom - i, left + i, bottom - i);
                ++i;
            }
            --right;
            --bottom;
            i = 0;
            while (i < tl.length) {
                gc.setForeground(color);
                gc.drawLine(left + i, top + i, right - i, top + i);
                gc.drawLine(left + i, top + i, left + i, bottom - i);
                ++i;
            }
            color.dispose();
        }

        private static class MyScheme
        extends SchemeBorder.Scheme {
            public MyScheme(Color[] highlight, Color[] shadow) {
                super(highlight, shadow);
            }

            public Color[] getHighlight() {
                return super.getHighlight();
            }

            public Color[] getShadow() {
                return super.getHighlight();
            }
        }
    }
}

