/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewSessionBeanClassOperation;
import org.eclipse.jst.j2ee.internal.common.operations.INewJavaClassDataModelProperties;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddSessionBeanOperation
extends AbstractDataModelOperation
implements INewJavaClassDataModelProperties {
    private IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getTargetProject());

    public AddSessionBeanOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createBeanClass();
        return OK_STATUS;
    }

    public IStatus execute(final IProgressMonitor monitor, final IAdaptable info) throws ExecutionException {
        Display display;
        Runnable runnable = null;
        Shell ctx = null;
        if (UIContextDetermination.getCurrentContext() == 101 && (display = Display.getCurrent()) != null) {
            ctx = display.getActiveShell();
        }
        if (this.provider.validateEdit(null, ctx).isOK()) {
            runnable = new Runnable(){

                public void run() {
                    try {
                        AddSessionBeanOperation.this.doExecute(monitor, info);
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.provider.modify(runnable, null);
        }
        return Status.CANCEL_STATUS;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    protected String createBeanClass() {
        NewSessionBeanClassOperation op = new NewSessionBeanClassOperation(this.model);
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            Logger.getLogger().log((Throwable)e);
        }
        return this.getQualifiedClassName();
    }

    public final String getQualifiedClassName() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String className = this.model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + "." + className;
        }
        return className;
    }
}

