/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateEnterpriseBeanTemplateModel;
import org.eclipse.jst.j2ee.ejb.internal.operations.INewSessionBeanClassDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSessionBeanTemplateModel
extends CreateEnterpriseBeanTemplateModel
implements INewSessionBeanClassDataModelProperties {
    private static final String ATT_MAPPED_NAME = "mappedName";
    private static final String ATT_NAME = "name";
    public static final String QUALIFIED_STATELESS = "javax.ejb.Stateless";
    public static final String QUALIFIED_STATEFUL = "javax.ejb.Stateful";
    public static final String QUALIFIED_LOCAL = "javax.ejb.Local";
    public static final String QUALIFIED_REMOTE = "javax.ejb.Remote";
    public static final String QUALIFIED_REMOTE_HOME = "javax.ejb.RemoteHome";
    public static final String QUALIFIED_LOCAL_HOME = "javax.ejb.LocalHome";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT = "javax.ejb.TransactionManagement";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT_TYPE = "javax.ejb.TransactionManagementType";
    public static final String STATELESS_ANNOTATION = "@Stateless";
    public static final String STATEFUL_ANNOTATION = "@Stateful";

    public CreateSessionBeanTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    @Override
    public Collection<String> getImports() {
        Collection<String> collection = super.getImports();
        int stateType = this.dataModel.getIntProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        if (stateType == 0) {
            collection.add(QUALIFIED_STATELESS);
        } else if (stateType == 1) {
            collection.add(QUALIFIED_STATEFUL);
        } else {
            throw new IllegalStateException("illegal state type: " + stateType);
        }
        if (!this.isContainerType()) {
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT);
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT_TYPE);
        }
        if (this.isRemoteHomeChecked()) {
            collection.add(QUALIFIED_REMOTE_HOME);
        }
        if (this.isLocalHomeChecked()) {
            collection.add(QUALIFIED_LOCAL_HOME);
        }
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (iface.isLocal() && iface.exists()) {
                collection.add(QUALIFIED_LOCAL);
                continue;
            }
            if (!iface.isRemote() || !iface.exists()) continue;
            collection.add(QUALIFIED_REMOTE);
        }
        return collection;
    }

    @Override
    public List<String> getQualifiedInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            result.add(iface.getFullyQualifiedName());
        }
        return result;
    }

    public String getClassAnnotation() {
        String beanType;
        int stateType = this.dataModel.getIntProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        if (stateType == 0) {
            beanType = STATELESS_ANNOTATION;
        } else if (stateType == 1) {
            beanType = STATEFUL_ANNOTATION;
        } else {
            throw new IllegalStateException("illegal state type: " + stateType);
        }
        return beanType;
    }

    public Map<String, String> getClassAnnotationParams() {
        String mappedName;
        Hashtable<String, String> result = new Hashtable<String, String>();
        String dispName = this.getProperty("INewSessionBeanClassDataModelProperties.EJB_NAME");
        if (!dispName.equals(this.getClassName())) {
            result.put(ATT_NAME, dispName);
        }
        if ((mappedName = this.getProperty("INewSessionBeanClassDataModelProperties.MAPPED_NAME").trim()) != null && mappedName.length() > 0) {
            result.put(ATT_MAPPED_NAME, mappedName);
        }
        return result;
    }

    public List<BusinessInterface> getBusinessInterfaces() {
        return (List)this.dataModel.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
    }

    public List<BusinessInterface> getExistingLocalBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isLocal() || !iface.exists()) continue;
            result.add(iface);
        }
        return result;
    }

    public List<BusinessInterface> getExistingRemoteBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isRemote() || !iface.exists()) continue;
            result.add(iface);
        }
        return result;
    }

    public boolean isLocalHomeChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
    }

    public boolean isRemoteHomeChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
    }

    public boolean isContainerType() {
        int transactionType = this.dataModel.getIntProperty("INewSessionBeanClassDataModelProperties.TRANSACTION_TYPE");
        return transactionType == 0;
    }
}

