/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.AddSessionBeanOperation;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.INewSessionBeanClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSessionBeanClassDataModelProvider
extends NewJavaClassDataModelProvider
implements INewSessionBeanClassDataModelProperties {
    public static final int STATE_TYPE_STATELESS_INDEX = 0;
    public static final int STATE_TYPE_STATEFUL_INDEX = 1;
    public static final int TRANSACTION_TYPE_CONTAINER_INDEX = 0;
    public static final int TRANSACTION_TYPE_BEAN_INDEX = 1;
    private static final String LOCAL_SUFFIX = "Local";
    private static final String REMOTE_SUFFIX = "Remote";

    public IDataModelOperation getDefaultOperation() {
        return new AddSessionBeanOperation(this.getDataModel());
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        propertyNames.add("INewSessionBeanClassDataModelProperties.EJB_NAME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL");
        propertyNames.add("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.MAPPED_NAME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.TRANSACTION_TYPE");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.EJB_NAME")) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            int index = className.lastIndexOf(".");
            className = className.substring(index + 1);
            return className;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE_HOME")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL_HOME")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.STATE_TYPE")) {
            return 0;
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return "";
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.TRANSACTION_TYPE")) {
            return 0;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES")) {
            ArrayList<BusinessInterface> listResult = new ArrayList<BusinessInterface>();
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            if (((Boolean)this.getProperty("INewSessionBeanClassDataModelProperties.REMOTE")).booleanValue() && className.length() > 0) {
                BusinessInterface remoteInterface = new BusinessInterface(String.valueOf(className) + REMOTE_SUFFIX, BusinessInterface.BusinessInterfaceType.REMOTE);
                listResult.add(remoteInterface);
            }
            if (((Boolean)this.getProperty("INewSessionBeanClassDataModelProperties.LOCAL")).booleanValue() && className.length() > 0) {
                BusinessInterface localInterface = new BusinessInterface(String.valueOf(className) + LOCAL_SUFFIX, BusinessInterface.BusinessInterfaceType.LOCAL);
                listResult.add(localInterface);
            }
            return listResult;
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        String value;
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            String value2 = this.getStringProperty(propertyName);
            if (value2 == null || value2.trim().length() == 0) {
                return WTPCommonPlugin.OK_STATUS;
            }
        } else if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE") && ((value = this.getStringProperty(propertyName)) == null || value.trim().length() == 0)) {
            String msg = EJBCreationResourceHandler.Bean_Class_Cannot_Be_In_UI_;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return super.validate(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && !this.getDataModel().isPropertySet("INewSessionBeanClassDataModelProperties.EJB_NAME")) {
            this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.EJB_NAME", 2);
            this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE", 2);
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            if (!this.getDataModel().isPropertySet("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES")) {
                this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES", 2);
            } else {
                this.updateBusinessInterfaces("INewSessionBeanClassDataModelProperties.REMOTE");
            }
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL") && !this.getDataModel().isPropertySet("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES")) {
            this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES", 2);
        }
        propertyName.equals("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        return result;
    }

    private void updateBusinessInterfaces(String propertyName) {
        List list = (List)this.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            if (this.getBooleanProperty(propertyName)) {
                String className = Signature.getSimpleName((String)this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
                list.add(new BusinessInterface(String.valueOf(className) + REMOTE_SUFFIX, BusinessInterface.BusinessInterfaceType.REMOTE));
            } else {
                BusinessInterface remoteInterface = this.getRemoteProperty();
                int indexOf = list.indexOf(remoteInterface);
                list.remove(indexOf);
            }
        } else if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL")) {
            if (this.getBooleanProperty(propertyName)) {
                String className = Signature.getSimpleName((String)this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
                list.add(new BusinessInterface(String.valueOf(className) + LOCAL_SUFFIX, BusinessInterface.BusinessInterfaceType.LOCAL));
            } else {
                BusinessInterface localInterface = this.getLocalProperty();
                int indexOf = list.indexOf(localInterface);
                list.remove(indexOf);
            }
        }
    }

    private BusinessInterface getRemoteProperty() {
        List businessInterfaces = (List)this.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        for (BusinessInterface iface : businessInterfaces) {
            if (iface.getJavaType() != null || !iface.isRemote()) continue;
            return iface;
        }
        return null;
    }

    private BusinessInterface getLocalProperty() {
        List businessInterfaces = (List)this.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        for (BusinessInterface iface : businessInterfaces) {
            if (iface.getJavaType() != null || !iface.isLocal()) continue;
            return iface;
        }
        return null;
    }
}

