/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateSessionBeanTemplateModel;
import org.eclipse.jst.j2ee.ejb.internal.operations.INewSessionBeanClassDataModelProperties;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.osgi.framework.Bundle;

public class NewSessionBeanClassOperation
extends AbstractDataModelOperation
implements INewSessionBeanClassDataModelProperties {
    private static final String LOCAL_HOME_SUFFIX = "LocalHome";
    private static final String LOCAL_COMPONENT_SUFFIX = "LocalComponent";
    private static final String REMOTE_COMPONENT_SUFFIX = "RemoteComponent";
    private static final String REMOTE_HOME_SUFFIX = "Home";
    private static final String DOT_JAVA = ".java";
    protected static final String EJB_PLUGIN = "EJB_PLUGIN";
    protected static final String TEMPLATE_FILE = "/templates/sessionBean.javajet";
    protected static final String TEMPLATE_LOCAL_FILE = "/templates/localBusinessInterface.javajet";
    protected static final String TEMPLATE_REMOTE_FILE = "/templates/remoteBusinessInterface.javajet";
    protected static final String TEMPLATE_LOCALHOME_FILE = "/templates/localHomeInterface.javajet";
    protected static final String TEMPLATE_REMOTEHOME_FILE = "/templates/remoteHomeInterface.javajet";
    protected static final String TEMPLATE_LOCALCOMPONENT_FILE = "/templates/localComponentInterface.javajet";
    protected static final String TEMPLATE_REMOTECOMPONENT_FILE = "/templates/remoteComponentInterface.javajet";
    protected static final String BUILDER_ID = "builderId";

    public NewSessionBeanClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createJavaSourceFolder();
        IPackageFragment pack = this.createJavaPackage();
        try {
            this.generateUsingTemplates(monitor, pack);
        }
        catch (Exception e) {
            return WTPCommonPlugin.createErrorStatus((String)e.toString());
        }
        return OK_STATUS;
    }

    protected final IPackageFragment createJavaPackage() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return pack;
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        CreateSessionBeanTemplateModel tempModel = this.createTemplateModel();
        this.getTargetProject();
        try {
            if (fragment != null) {
                String fileName;
                String src;
                List<BusinessInterface> interfaces = tempModel.getBusinessInterfaces();
                for (BusinessInterface iface : interfaces) {
                    String fileName2;
                    String src2;
                    if (iface.exists()) continue;
                    if (iface.isLocal()) {
                        src2 = this.generateTemplateSource(tempModel, monitor, TEMPLATE_LOCAL_FILE);
                        fileName2 = String.valueOf(iface.getSimpleName()) + DOT_JAVA;
                        this.createJavaFile(monitor, fragment, src2, fileName2);
                        continue;
                    }
                    if (!iface.isRemote()) continue;
                    src2 = this.generateTemplateSource(tempModel, monitor, TEMPLATE_REMOTE_FILE);
                    fileName2 = String.valueOf(iface.getSimpleName()) + DOT_JAVA;
                    this.createJavaFile(monitor, fragment, src2, fileName2);
                }
                if (this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME")) {
                    src = this.generateTemplateSource(tempModel, monitor, TEMPLATE_REMOTEHOME_FILE);
                    fileName = String.valueOf(tempModel.getClassName()) + REMOTE_HOME_SUFFIX + DOT_JAVA;
                    this.createJavaFile(monitor, fragment, src, fileName);
                    src = this.generateTemplateSource(tempModel, monitor, TEMPLATE_REMOTECOMPONENT_FILE);
                    fileName = String.valueOf(tempModel.getClassName()) + REMOTE_COMPONENT_SUFFIX + DOT_JAVA;
                    this.createJavaFile(monitor, fragment, src, fileName);
                }
                if (this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME")) {
                    src = this.generateTemplateSource(tempModel, monitor, TEMPLATE_LOCALHOME_FILE);
                    fileName = String.valueOf(tempModel.getClassName()) + LOCAL_HOME_SUFFIX + DOT_JAVA;
                    this.createJavaFile(monitor, fragment, src, fileName);
                    src = this.generateTemplateSource(tempModel, monitor, TEMPLATE_LOCALCOMPONENT_FILE);
                    fileName = String.valueOf(tempModel.getClassName()) + LOCAL_COMPONENT_SUFFIX + DOT_JAVA;
                    this.createJavaFile(monitor, fragment, src, fileName);
                }
                String source = this.generateTemplateSource(tempModel, monitor, TEMPLATE_FILE);
                String javaFileName = String.valueOf(tempModel.getClassName()) + DOT_JAVA;
                this.createJavaFile(monitor, fragment, source, javaFileName);
            }
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
    }

    private IFile createJavaFile(IProgressMonitor monitor, IPackageFragment fragment, String source1, String localBeanName) throws JavaModelException {
        if (fragment != null) {
            ICompilationUnit cu1 = fragment.getCompilationUnit(localBeanName);
            if (cu1 == null || !cu1.exists()) {
                cu1 = fragment.createCompilationUnit(localBeanName, source1, true, monitor);
            }
            return (IFile)cu1.getResource();
        }
        return null;
    }

    protected void createInheritedMethods(IType type) throws CoreException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            int flags;
            IMethod method = iMethodArray[n2];
            boolean resolved = method.isResolved();
            if (!resolved && (Flags.isAbstract((int)(flags = method.getFlags())) || Flags.isInterface((int)flags))) {
                System.out.println("method(s) to implement:" + method.getElementName());
                System.out.println("Retrun String should be: " + method.getReturnType());
                method.getParameterTypes();
            }
            System.out.println(resolved);
            ++n2;
        }
    }

    private CreateSessionBeanTemplateModel createTemplateModel() {
        CreateSessionBeanTemplateModel templateModel = new CreateSessionBeanTemplateModel(this.model);
        return templateModel;
    }

    private String generateTemplateSource(CreateSessionBeanTemplateModel tempModel, IProgressMonitor monitor, String template_file) throws JETException {
        URL templateURL = FileLocator.find((Bundle)EjbPlugin.getDefault().getBundle(), (IPath)new Path(template_file), null);
        this.cleanUpOldEmitterProject();
        WTPJETEmitter emitter = new WTPJETEmitter(templateURL.toString(), this.getClass().getClassLoader());
        emitter.setIntelligentLinkingEnabled(true);
        emitter.addVariable(EJB_PLUGIN, "org.eclipse.jst.j2ee.ejb");
        return emitter.generate(monitor, new Object[]{tempModel});
    }

    private void cleanUpOldEmitterProject() {
        IProject project = ProjectUtilities.getProject((String)".JETEmitters");
        if (project == null || !project.exists()) {
            return;
        }
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int i = 0;
            int l = markers.length;
            while (i < l) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final IFolder createJavaSourceFolder() {
        String folderFullPath = this.model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder folder = root.getFolder((IPath)new Path(folderFullPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return folder;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecute(monitor, info);
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }
}

