/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.core.internal;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.IStaticWeb;
import org.eclipse.wst.server.http.core.internal.HttpRuntime;
import org.eclipse.wst.server.http.core.internal.Messages;
import org.eclipse.wst.server.http.core.internal.Trace;

public class HttpServer
extends ServerDelegate
implements IURLProvider {
    public static final String PROPERTY_URL_PREFIX = "urlPrefix";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_IS_PUBLISHING = "isPublishing";
    public static final String ID = "org.eclipse.wst.server.http.server";

    protected void initialize() {
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setPort(80);
        this.setURLPrefix("");
        this.setPublishing(true);
    }

    public HttpRuntime getHttpRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (HttpRuntime)((Object)this.getServer().getRuntime().loadAdapter(HttpRuntime.class, null));
    }

    public boolean dontPublish() {
        return this.getAttribute("auto-publish-setting", "2").equals("1");
    }

    protected static String getURLHost(String host) {
        return host != null && host.indexOf(":") >= 0 ? "[" + host + "]" : host;
    }

    public URL getModuleRootURL(IModule module) {
        try {
            String base = "http://" + HttpServer.getURLHost(this.getServer().getHost());
            if (base.equals("")) {
                base = "http://" + HttpServer.getURLHost(this.getServer().getHost());
            }
            int port = this.getPort();
            URL url = null;
            url = port == 80 ? new URL(String.valueOf(base) + "/") : new URL(String.valueOf(base) + ":" + port + "/");
            String prefix = this.getURLPrefix();
            if (prefix != null && prefix.length() > 0) {
                url = new URL(url, String.valueOf(prefix) + "/");
            }
            IStaticWeb staticWeb = (IStaticWeb)module.loadAdapter(IStaticWeb.class, null);
            return new URL(url, staticWeb.getContextRoot());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get root URL", e);
            return null;
        }
    }

    public IModule[] getChildModules(IModule[] module) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        return new IModule[]{module};
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return new Status(0, "org.eclipse.wst.server.http.core", 0, Messages.canModifyModules, null);
    }

    public ServerPort[] getServerPorts() {
        int port = this.getPort();
        ServerPort[] ports = new ServerPort[]{new ServerPort("http", Messages.httpPort, port, "http")};
        return ports;
    }

    public int getPort() {
        return this.getAttribute(PROPERTY_PORT, 80);
    }

    public void setPort(int port) {
        this.setAttribute(PROPERTY_PORT, port);
    }

    public void setURLPrefix(String prefix) {
        this.setAttribute(PROPERTY_URL_PREFIX, prefix);
    }

    public String getURLPrefix() {
        return this.getAttribute(PROPERTY_URL_PREFIX, "");
    }

    public boolean isPublishing() {
        return this.getAttribute(PROPERTY_IS_PUBLISHING, false);
    }

    public void setPublishing(boolean shouldPublish) {
        this.setAttribute(PROPERTY_IS_PUBLISHING, shouldPublish);
    }

    public static IServer createHttpServer(String host, String serverName, IProgressMonitor monitor) {
        try {
            IRuntimeType runtimeType = ServerCore.findRuntimeType((String)"org.eclipse.wst.server.http.runtime");
            IRuntimeWorkingCopy runtimeCopy = runtimeType.createRuntime("org.eclipse.wst.server.http.runtime", monitor);
            IRuntime runtime = runtimeCopy.save(true, monitor);
            IServerType serverType = ServerCore.findServerType((String)ID);
            IServerWorkingCopy workingCopy = serverType.createServer(ID, null, runtime, monitor);
            workingCopy.setName(serverName);
            workingCopy.setHost(host);
            return workingCopy.save(true, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error creating server", e);
            return null;
        }
    }

    public static IServer findHttpServer(String id) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getId().equals(id)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public String toString() {
        return "HttpServer";
    }
}

