/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.InsertSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.RemoveSubNodeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFHtmlSelectChoicesSection
extends BaseCustomSection {
    private static final String[] CHOICETYPES = new String[]{"selectItem", "selectItems"};
    private Table _choiceTable;
    private TableViewer _choiceViewer;
    private CCombo _choiceTypeCombo;
    private Button _choiceAddButton;
    private Button _choiceRemoveButton;
    private Button _choiceMoveUpButton;
    private Button _choiceMoveDownButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        this.createChoicePart(factory, top);
    }

    private void createChoicePart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        this._choiceTable = factory.createTable(other, 65538);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 5;
        data.heightHint = 50;
        this._choiceTable.setHeaderVisible(true);
        this._choiceTable.setLayoutData((Object)data);
        this._choiceTable.setLinesVisible(true);
        TableColumn choiceColumn = new TableColumn(this._choiceTable, 0);
        choiceColumn.setText(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.Choices"));
        choiceColumn.setWidth(100);
        TableColumn labelColumn = new TableColumn(this._choiceTable, 0);
        labelColumn.setText("itemLabel");
        labelColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(this._choiceTable, 0);
        valueColumn.setText("itemValue");
        valueColumn.setWidth(100);
        TableColumn idColumn = new TableColumn(this._choiceTable, 0);
        idColumn.setText("id");
        idColumn.setWidth(100);
        this._choiceViewer = new TableViewer(this._choiceTable);
        this._choiceViewer.setContentProvider((IContentProvider)new ChoiceCotentLabelProvider());
        this._choiceViewer.setLabelProvider((IBaseLabelProvider)new ChoiceCotentLabelProvider());
        this._choiceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlSelectChoicesSection.this.gotoNode((Node)node);
                }
            }
        });
        this._choiceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFHtmlSelectChoicesSection.this.updateChoiceButtonStatus();
            }
        });
        this._choiceTypeCombo = factory.createCCombo(other, 8);
        this._choiceTypeCombo.setItems(CHOICETYPES);
        this._choiceTypeCombo.select(0);
        data = new GridData(256);
        this._choiceTypeCombo.setLayoutData((Object)data);
        this._choiceAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlSelectManyCheckboxSection.Add"), 0);
        data = new GridData(256);
        this._choiceAddButton.setLayoutData((Object)data);
        this._choiceAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap attributes = new HashMap();
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.CommandLabel.AddSubTag"), JSFHtmlSelectChoicesSection.this._element, JSFHtmlSelectChoicesSection.this._choiceTypeCombo.getText(), "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlSelectChoicesSection.this._choiceViewer.refresh();
                JSFHtmlSelectChoicesSection.this.updateChoiceButtonStatus();
            }
        });
        this._choiceRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlSelectManyCheckboxSection.Remove"), 0);
        data = new GridData(256);
        this._choiceRemoveButton.setLayoutData((Object)data);
        this._choiceRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlSelectChoicesSection.this._choiceViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.CommandLabel.RemoveSubTag"), JSFHtmlSelectChoicesSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlSelectChoicesSection.this._choiceViewer.refresh();
                    JSFHtmlSelectChoicesSection.this.updateChoiceButtonStatus();
                }
            }
        });
        this._choiceMoveUpButton = factory.createButton(other, SectionResources.getString("JSFHtmlSelectManyCheckboxSection.MoveUp"), 0);
        data = new GridData(256);
        this._choiceMoveUpButton.setLayoutData((Object)data);
        this._choiceMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = JSFHtmlSelectChoicesSection.this._choiceTable.getSelectionIndex();
                IDOMElement child = (IDOMElement)JSFHtmlSelectChoicesSection.this._choiceTable.getItem(index).getData();
                IDOMElement refchild = (IDOMElement)JSFHtmlSelectChoicesSection.this._choiceTable.getItem(index - 1).getData();
                RemoveSubNodeCommand remove = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.CommandLabel.RemoveSubTag"), JSFHtmlSelectChoicesSection.this._element, child);
                remove.execute();
                InsertSubNodeCommand insert = new InsertSubNodeCommand(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.CommandLabel.InsertSubTag"), JSFHtmlSelectChoicesSection.this._element, child, refchild);
                insert.execute();
                JSFHtmlSelectChoicesSection.this._choiceViewer.refresh();
                JSFHtmlSelectChoicesSection.this._choiceViewer.getTable().select(index - 1);
                JSFHtmlSelectChoicesSection.this.updateChoiceButtonStatus();
            }
        });
        this._choiceMoveDownButton = factory.createButton(other, SectionResources.getString("JSFHtmlSelectManyCheckboxSection.MoveDown"), 0);
        data = new GridData(256);
        this._choiceMoveDownButton.setLayoutData((Object)data);
        this._choiceMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = JSFHtmlSelectChoicesSection.this._choiceTable.getSelectionIndex();
                IDOMElement child = (IDOMElement)JSFHtmlSelectChoicesSection.this._choiceTable.getItem(index).getData();
                IDOMElement refchild = (IDOMElement)JSFHtmlSelectChoicesSection.this._choiceTable.getItem(index + 1).getData();
                RemoveSubNodeCommand remove = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.CommandLabel.RemoveSubTag"), JSFHtmlSelectChoicesSection.this._element, refchild);
                remove.execute();
                InsertSubNodeCommand insert = new InsertSubNodeCommand(SectionResources.getString("JSFHtmlSelectManyCheckboxSection.CommandLabel.InsertSubTag"), JSFHtmlSelectChoicesSection.this._element, refchild, child);
                insert.execute();
                JSFHtmlSelectChoicesSection.this._choiceViewer.refresh();
                JSFHtmlSelectChoicesSection.this._choiceViewer.getTable().select(index + 1);
                JSFHtmlSelectChoicesSection.this.updateChoiceButtonStatus();
            }
        });
    }

    private void updateChoiceButtonStatus() {
        this._choiceRemoveButton.setEnabled(true);
        this._choiceMoveUpButton.setEnabled(true);
        this._choiceMoveDownButton.setEnabled(true);
        ISelection selection = this._choiceViewer.getSelection();
        if (selection.isEmpty()) {
            this._choiceRemoveButton.setEnabled(false);
            this._choiceMoveUpButton.setEnabled(false);
            this._choiceMoveDownButton.setEnabled(false);
        }
        if (this._choiceTable.getItemCount() == 0) {
            this._choiceRemoveButton.setEnabled(false);
            this._choiceMoveUpButton.setEnabled(false);
            this._choiceMoveDownButton.setEnabled(false);
        }
        if (this._choiceTable.getSelectionCount() > 1) {
            this._choiceMoveUpButton.setEnabled(false);
            this._choiceMoveDownButton.setEnabled(false);
        }
        if (this._choiceTable.getSelectionIndex() == 0) {
            this._choiceMoveUpButton.setEnabled(false);
        }
        if (this._choiceTable.getSelectionIndex() == this._choiceTable.getItemCount() - 1) {
            this._choiceMoveDownButton.setEnabled(false);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._choiceViewer.setInput((Object)this._element);
        this.updateChoiceButtonStatus();
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._choiceViewer != null && !this._choiceViewer.getControl().isDisposed()) {
            this._choiceViewer.refresh();
        }
    }

    private class ChoiceCotentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ChoiceCotentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlSelectChoicesSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("select") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof Node) {
                Node node = (Node)element;
                Node attrNode = null;
                String attrName = null;
                if (columnIndex == 1) {
                    attrName = "itemLabel";
                } else if (columnIndex == 2) {
                    attrName = "itemValue";
                } else if (columnIndex == 3) {
                    attrName = "id";
                }
                switch (columnIndex) {
                    case 0: {
                        result = node.getNodeName();
                        break;
                    }
                    default: {
                        attrNode = node.getAttributes().getNamedItem(attrName);
                        result = attrNode != null ? (attrNode.getNodeValue() != null ? attrNode.getNodeValue() : " - ") : " - ";
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

