/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;

public class JSPPathIndexer {
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public IPath[] getVisibleJspPaths(SearchPattern pattern, IJavaSearchScope scope) {
        JSPFileVisitor jspFileVisitor = new JSPFileVisitor(pattern, scope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)jspFileVisitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return jspFileVisitor.getPaths();
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private HashMap fPaths = new HashMap();
        IJavaSearchScope fScope = null;
        SearchPattern fPattern = null;

        public JSPFileVisitor(SearchPattern pattern, IJavaSearchScope scope) {
            this.fPattern = pattern;
            this.fScope = scope;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (JSPSearchSupport.getInstance().isCanceled()) {
                return false;
            }
            if (proxy.getType() == 1) {
                IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
                if (contentTypeJSP.isAssociatedWith(proxy.getName())) {
                    IFile file = (IFile)proxy.requestResource();
                    IContentDescription contentDescription = file.getContentDescription();
                    String ctId = null;
                    if (contentDescription != null) {
                        ctId = contentDescription.getContentType().getId();
                    }
                    if (ContentTypeIdForJSP.ContentTypeID_JSP.equals(ctId) && this.fScope.encloses(proxy.requestFullPath().toString())) {
                        if (DEBUG) {
                            System.out.println("adding selected index path:" + file.getParent().getFullPath());
                        }
                        this.fPaths.put(file.getParent().getFullPath(), JSPSearchSupport.getInstance().computeIndexLocation(file.getParent().getFullPath()));
                    }
                }
                return false;
            }
            return true;
        }

        public IPath[] getPaths() {
            return this.fPaths.values().toArray(new IPath[this.fPaths.size()]);
        }
    }
}

