/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class BorderItemRectilinearRouter
extends RectilinearRouter {
    private static int OFFSET = 15;

    protected PointList calculateBendPoints(Connection conn) {
        BorderItemConnectionAnchor anchor;
        Rectangle targetParentRect;
        IFigure source = conn.getSourceAnchor().getOwner();
        IFigure target = conn.getTargetAnchor().getOwner();
        if (source == null || target == null || this.isAvoidingObstructions(conn) || this.isClosestDistance(conn)) {
            return super.calculateBendPoints(conn);
        }
        int sourcePosition = this.getBorderFigurePosition(source);
        int targetPosition = this.getBorderFigurePosition(target);
        PolylineConnectionEx fakeConnection = new PolylineConnectionEx(){

            public void validate() {
            }

            public void paintFigure(Graphics graphics) {
            }
        };
        Rectangle sourceParentRect = this.getObstacle(source, conn, sourcePosition != 0);
        if (sourceParentRect.contains(targetParentRect = this.getObstacle(target, conn, targetPosition != 0))) {
            sourcePosition = this.reversePosition(sourcePosition);
        } else if (targetParentRect.contains(sourceParentRect)) {
            targetPosition = this.reversePosition(targetPosition);
        }
        fakeConnection.setSourceAnchor(new BorderItemConnectionAnchor(conn.getSourceAnchor(), sourcePosition, OFFSET));
        fakeConnection.setTargetAnchor(new BorderItemConnectionAnchor(conn.getTargetAnchor(), targetPosition, OFFSET));
        fakeConnection.setConnectionRouter(conn.getConnectionRouter());
        ArrayList originalbendpoints = (ArrayList)conn.getConnectionRouter().getConstraint(conn);
        if (originalbendpoints == null || originalbendpoints.size() == 0) {
            return super.calculateBendPoints(conn);
        }
        fakeConnection.setParent(conn.getParent());
        if (conn instanceof PolylineConnectionEx) {
            PolylineConnectionEx connection = (PolylineConnectionEx)conn;
            fakeConnection.setRoutingStyles(connection.isClosestDistanceRouting(), connection.isAvoidObstacleRouting());
        }
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        for (Bendpoint bp : originalbendpoints) {
            constraint.add(new AbsoluteBendpoint(bp.getLocation()));
        }
        AbsoluteBendpoint startPoint = (AbsoluteBendpoint)constraint.get(0);
        if (sourcePosition != 0) {
            BorderItemConnectionAnchor anchor2 = (BorderItemConnectionAnchor)fakeConnection.getSourceAnchor();
            Point startBendpoint = anchor2.getReferencePoint();
            conn.translateToRelative((Translatable)startBendpoint);
            constraint.remove(0);
            startPoint = new AbsoluteBendpoint(startBendpoint);
            constraint.add(0, startPoint);
        }
        AbsoluteBendpoint endPoint = (AbsoluteBendpoint)constraint.get(constraint.size() - 1);
        if (targetPosition != 0) {
            BorderItemConnectionAnchor anchor3 = (BorderItemConnectionAnchor)fakeConnection.getTargetAnchor();
            Point endBendpoint = anchor3.getReferencePoint();
            conn.translateToRelative((Translatable)endBendpoint);
            constraint.remove(constraint.size() - 1);
            endPoint = new AbsoluteBendpoint(endBendpoint);
            constraint.add(endPoint);
        }
        this.avoidOverlappingWithParent(startPoint, endPoint, sourceParentRect, targetParentRect, constraint, conn);
        fakeConnection.setRoutingConstraint(constraint);
        PointList points = super.calculateBendPoints((Connection)fakeConnection);
        if (sourcePosition != 0) {
            anchor = (BorderItemConnectionAnchor)fakeConnection.getSourceAnchor();
            Point startPoint1 = anchor.getAnchorPoint();
            conn.translateToRelative((Translatable)startPoint1);
            points.insertPoint(startPoint1, 0);
        }
        if (targetPosition != 0) {
            anchor = (BorderItemConnectionAnchor)fakeConnection.getTargetAnchor();
            Point endPoint1 = anchor.getAnchorPoint();
            conn.translateToRelative((Translatable)endPoint1);
            points.addPoint(endPoint1);
        }
        fakeConnection.setParent(null);
        return points;
    }

    private int reversePosition(int position) {
        int newPosition = position;
        if (position == 4) {
            newPosition = 1;
        } else if (position == 1) {
            newPosition = 4;
        } else if (position == 8) {
            newPosition = 16;
        } else if (position == 16) {
            newPosition = 8;
        }
        return newPosition;
    }

    protected int getBorderFigurePosition(IFigure borderFigure) {
        LayoutManager layoutManager;
        Object layoutConstraint;
        IFigure child = borderFigure;
        IFigure parent = borderFigure.getParent();
        if (parent != null && parent.getLayoutManager() != null && (layoutConstraint = (layoutManager = parent.getLayoutManager()).getConstraint(child)) instanceof IBorderItemLocator) {
            return ((IBorderItemLocator)layoutConstraint).getCurrentSideOfParent();
        }
        return 0;
    }

    private void avoidOverlappingWithParent(AbsoluteBendpoint startPoint, AbsoluteBendpoint endPoint, Rectangle sourceParentRect, Rectangle targetParentRect, List constraint, Connection conn) {
        if (sourceParentRect.intersects(targetParentRect)) {
            return;
        }
        IMapMode mapMode = MapModeUtil.getMapMode((IFigure)conn);
        int logicalOffset = mapMode.DPtoLP(OFFSET);
        ShortestPathRouter router = new ShortestPathRouter();
        Path path = new Path((Point)startPoint, (Point)endPoint);
        router.addPath(path);
        router.addObstacle(sourceParentRect);
        router.addObstacle(targetParentRect);
        router.setSpacing(logicalOffset);
        router.solve();
        PointList points = path.getPoints();
        points.removePoint(0);
        points.removePoint(points.size() - 1);
        if (points.size() > 0) {
            Point refrencePoint = points.getFirstPoint();
            AbsoluteBendpoint startPointGuidePoint = new AbsoluteBendpoint((Point)startPoint);
            this.adjustPointUsingReferencePointAndObstacle(startPointGuidePoint, refrencePoint, sourceParentRect, logicalOffset);
            constraint.add(1, startPointGuidePoint);
            points.removePoint(0);
            if (points.size() == 0) {
                AbsoluteBendpoint endPointGuidePoint = new AbsoluteBendpoint((Point)endPoint);
                this.adjustPointUsingReferencePointAndObstacle(endPointGuidePoint, refrencePoint, targetParentRect, logicalOffset);
                if (endPointGuidePoint.y == endPoint.y) {
                    endPointGuidePoint.x = startPointGuidePoint.x;
                } else {
                    endPointGuidePoint.y = startPointGuidePoint.y;
                }
                constraint.add(2, endPointGuidePoint);
            }
        }
        if (points.size() > 0) {
            Point referencePoint = points.getLastPoint();
            AbsoluteBendpoint endPointGuidePoint = new AbsoluteBendpoint((Point)endPoint);
            this.adjustPointUsingReferencePointAndObstacle(endPointGuidePoint, referencePoint, targetParentRect, logicalOffset);
            constraint.add(constraint.size() - 1, endPointGuidePoint);
        }
    }

    private void adjustPointUsingReferencePointAndObstacle(AbsoluteBendpoint guidePoint, Point referencePoint, Rectangle obstacle, int offSet) {
        boolean changeY;
        boolean bl = changeY = guidePoint.y >= obstacle.y && guidePoint.y <= obstacle.y + obstacle.height;
        if (changeY) {
            guidePoint.y = referencePoint.y < guidePoint.y ? obstacle.y - offSet : obstacle.y + obstacle.height + offSet;
        } else {
            guidePoint.x = referencePoint.x < guidePoint.x ? obstacle.x - offSet : obstacle.x + obstacle.width + offSet;
        }
    }

    protected Rectangle getObstacle(IFigure figure, Connection conn, boolean isBorderItem) {
        IFigure parent = null;
        parent = isBorderItem ? this.getBorderItemParent(figure) : figure;
        Rectangle rect = parent.getBounds().getCopy();
        parent.translateToAbsolute((Translatable)rect);
        conn.translateToRelative((Translatable)rect);
        return rect;
    }

    protected IFigure getBorderItemParent(IFigure figure) {
        return figure.getParent().getParent();
    }

    private class BorderItemConnectionAnchor
    implements ConnectionAnchor {
        private ConnectionAnchor anchor;
        private int position;
        private int offset;

        public BorderItemConnectionAnchor(ConnectionAnchor anchor, int position, int offset) {
            this.anchor = anchor;
            this.position = position;
            this.offset = offset;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public Point getReferencePoint() {
            Point referencePoint = this.getAnchorPoint();
            if (this.position == 4) {
                referencePoint.y += this.offset;
            } else if (this.position == 1) {
                referencePoint.y -= this.offset;
            } else if (this.position == 8) {
                referencePoint.x -= this.offset;
            } else if (this.position == 16) {
                referencePoint.x += this.offset;
            }
            return referencePoint;
        }

        public Point getAnchorPoint() {
            Rectangle ownerBounds = this.getOwner().getBounds().getCopy();
            this.getOwner().translateToAbsolute((Translatable)ownerBounds);
            if (this.position == 4) {
                return ownerBounds.getBottom();
            }
            if (this.position == 1) {
                return ownerBounds.getTop();
            }
            if (this.position == 8) {
                return ownerBounds.getLeft();
            }
            if (this.position == 16) {
                return ownerBounds.getRight();
            }
            return ownerBounds.getCenter();
        }

        public void addAnchorListener(AnchorListener listener) {
        }

        public Point getLocation(Point reference) {
            return reference;
        }

        public IFigure getOwner() {
            return this.anchor.getOwner();
        }

        public void removeAnchorListener(AnchorListener listener) {
        }

        public ConnectionAnchor getAnchor() {
            return this.anchor;
        }
    }
}

