/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;

public class EMFUpdateValueStrategy
extends UpdateValueStrategy {
    public EMFUpdateValueStrategy() {
        this(true, POLICY_UPDATE);
    }

    public EMFUpdateValueStrategy(int updatePolicy) {
        this(true, updatePolicy);
    }

    public EMFUpdateValueStrategy(boolean provideDefaults, int updatePolicy) {
        super(provideDefaults, updatePolicy);
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        if (fromType == String.class) {
            if (toType instanceof EAttribute) {
                final EAttribute eAttribute = (EAttribute)toType;
                final EDataType eDataType = eAttribute.getEAttributeType();
                final EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                return new Converter(fromType, toType){

                    public Object convert(Object fromObject) {
                        String value = fromObject.toString();
                        if (eAttribute.isMany()) {
                            ArrayList<Object> result = new ArrayList<Object>();
                            String[] stringArray = value.split(" ");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String element = stringArray[n2];
                                result.add(eFactory.createFromString(eDataType, element));
                                ++n2;
                            }
                            return result;
                        }
                        return eFactory.createFromString(eDataType, value);
                    }
                };
            }
        } else if (toType == String.class && fromType instanceof EAttribute) {
            final EAttribute eAttribute = (EAttribute)fromType;
            final EDataType eDataType = eAttribute.getEAttributeType();
            final EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            return new Converter(fromType, toType){

                public Object convert(Object fromObject) {
                    if (eAttribute.isMany()) {
                        StringBuilder result = new StringBuilder();
                        for (Object value : (List)fromObject) {
                            if (result.length() == 0) {
                                result.append(' ');
                            }
                            result.append(eFactory.convertToString(eDataType, value));
                        }
                        return result.toString();
                    }
                    return eFactory.convertToString(eDataType, fromObject);
                }
            };
        }
        return super.createConverter(fromType, toType);
    }
}

