/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectObservableValue
extends AbstractObservableValue
implements IObserving {
    protected EObject eObject;
    protected EStructuralFeature eStructuralFeature;
    protected Adapter listener;

    public EObjectObservableValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        this(Realm.getDefault(), eObject, eStructuralFeature);
    }

    public EObjectObservableValue(Realm realm, EObject eObject, EStructuralFeature eStructuralFeature) {
        super(realm);
        this.eObject = eObject;
        this.eStructuralFeature = eStructuralFeature;
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            this.eObject.eAdapters().remove((Object)this.listener);
            this.listener = null;
        }
        this.eObject = null;
        this.eStructuralFeature = null;
        super.dispose();
    }

    public Object getObserved() {
        return this.eObject;
    }

    protected void firstListenerAdded() {
        this.listener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (!msg.isTouch() && EObjectObservableValue.this.eStructuralFeature.equals(msg.getFeature())) {
                    final ValueDiff diff = Diffs.createValueDiff((Object)msg.getOldValue(), (Object)msg.getNewValue());
                    EObjectObservableValue.this.getRealm().exec(new Runnable(){

                        public void run() {
                            EObjectObservableValue.this.fireValueChange(diff);
                        }
                    });
                }
            }
        };
        this.eObject.eAdapters().add((Object)this.listener);
    }

    protected void lastListenerRemoved() {
        this.eObject.eAdapters().remove((Object)this.listener);
        this.listener = null;
    }

    protected Object doGetValue() {
        return this.eObject.eGet(this.eStructuralFeature);
    }

    protected void doSetValue(Object value) {
        this.eObject.eSet(this.eStructuralFeature, value);
    }

    public Object getValueType() {
        return this.eStructuralFeature;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(((Object)((Object)this)).getClass().getName());
        result.append('@');
        result.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        result.append(" (eObject:");
        result.append(this.eObject);
        result.append(")");
        result.append(" (eStructuralFeature: ");
        result.append(this.eStructuralFeature);
        result.append(")");
        try {
            Object value = this.eObject.eGet(this.eStructuralFeature, false);
            result.append(" (value: ");
            result.append(value);
            result.append(")");
        }
        catch (Exception exception) {}
        return result.toString();
    }
}

