/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class SnapCommand
extends AbstractTransactionalCommand {
    protected List editparts;

    public SnapCommand(TransactionalEditingDomain editingDomain, List editparts) {
        super(editingDomain, DiagramUIMessages.SnapToGrid_textLabel, null);
        this.editparts = editparts;
    }

    public List getAffectedFiles() {
        if (this.editparts != null) {
            IGraphicalEditPart parent = (IGraphicalEditPart)this.editparts.get(0);
            View view = (View)parent.getParent().getModel();
            return SnapCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CompoundCommand snapCommand = new CompoundCommand();
        for (GraphicalEditPart newEditPart : this.editparts) {
            LayoutConstraint constraint;
            IMapMode mapMode = ((DiagramRootEditPart)newEditPart.getRoot()).getMapMode();
            if (!(newEditPart.getModel() instanceof Node) || !((constraint = ((Node)newEditPart.getModel()).getLayoutConstraint()) instanceof Bounds)) continue;
            Bounds bounds = (Bounds)constraint;
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            request.setEditParts((EditPart)newEditPart);
            int xDiff = mapMode.LPtoDP(bounds.getX()) - mapMode.LPtoDP(newEditPart.getFigure().getBounds().x);
            int yDiff = mapMode.LPtoDP(bounds.getY()) - mapMode.LPtoDP(newEditPart.getFigure().getBounds().y);
            Point moveDelta = new Point(xDiff, yDiff);
            request.getExtendedData().clear();
            request.setMoveDelta(moveDelta);
            PrecisionRectangle figureBounds = null;
            IFigure figure = newEditPart.getFigure();
            figureBounds = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)figureBounds);
            SnapToHelper snapToHelper = (SnapToHelper)newEditPart.getAdapter(SnapToHelper.class);
            PrecisionRectangle baseRect = new PrecisionRectangle((Rectangle)figureBounds);
            baseRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            if (snapToHelper != null) {
                snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
                request.setMoveDelta((Point)preciseDelta);
            }
            snapCommand.add(newEditPart.getCommand((Request)request));
        }
        if (snapCommand != null && snapCommand.canExecute()) {
            snapCommand.execute();
        }
        return CommandResult.newOKCommandResult();
    }
}

