/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Bundle;

public class J2EEProjectDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static ImageDescriptor EAR;
    private static ImageDescriptor APPCLIENT;
    private static ImageDescriptor DYNAMICWEB;
    private static ImageDescriptor EJB;
    private static ImageDescriptor CONNECTOR;
    private static final String EAR_FACET = "jst.ear";
    private static final String APPCLIENT_FACET = "jst.appclient";
    private static final String WEB_FACET = "jst.web";
    private static final String EJB_FACET = "jst.ejb";
    private static final String UTILITY_FACET = "jst.utility";
    private static final String CONNECTOR_FACET = "jst.connector";
    private static final String STATIC_WEB_FACET = "wst.web";
    private static final String ICON_DIR = "icons/full/ovr16";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IJavaProject) {
            element = ((IJavaProject)element).getProject();
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            ImageDescriptor overlay = null;
            if (this.hasFacet(project, EAR_FACET)) {
                overlay = J2EEProjectDecorator.getEAR();
            } else if (this.hasFacet(project, APPCLIENT_FACET)) {
                overlay = J2EEProjectDecorator.getAPPCLIENT();
            } else if (this.hasFacet(project, WEB_FACET)) {
                overlay = J2EEProjectDecorator.getDYNAMICWEB();
            } else if (this.hasFacet(project, EJB_FACET)) {
                overlay = J2EEProjectDecorator.getEJB();
            } else if (this.hasFacet(project, CONNECTOR_FACET)) {
                overlay = J2EEProjectDecorator.getCONNECTOR();
            } else if (this.hasFacet(project, STATIC_WEB_FACET)) {
                overlay = J2EEProjectDecorator.getDYNAMICWEB();
            } else if (this.hasFacet(project, UTILITY_FACET)) {
                overlay = null;
            }
            if (overlay != null) {
                decoration.addOverlay(overlay);
            }
        }
    }

    private boolean hasFacet(IProject project, String facet) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facet);
        }
        catch (CoreException e) {
            J2EENavigatorPlugin.logError(0, e.getMessage(), e);
            return false;
        }
    }

    private static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        if (key != null) {
            String gif = "/" + key + ".gif";
            IPath path = new Path(ICON_DIR).append(gif);
            URL gifImageURL = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.jst.j2ee.navigator.ui"), (IPath)path, null);
            if (gifImageURL != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
            }
        }
        return imageDescriptor;
    }

    private static ImageDescriptor getEAR() {
        if (EAR == null) {
            EAR = J2EEProjectDecorator.getImageDescriptor("enterprise_app_ovr");
        }
        return EAR;
    }

    private static ImageDescriptor getAPPCLIENT() {
        if (APPCLIENT == null) {
            APPCLIENT = J2EEProjectDecorator.getImageDescriptor("client_app_ovr");
        }
        return APPCLIENT;
    }

    private static ImageDescriptor getDYNAMICWEB() {
        if (DYNAMICWEB == null) {
            DYNAMICWEB = J2EEProjectDecorator.getImageDescriptor("web_module_ovr");
        }
        return DYNAMICWEB;
    }

    private static ImageDescriptor getEJB() {
        if (EJB == null) {
            EJB = J2EEProjectDecorator.getImageDescriptor("ejb_module_ovr");
        }
        return EJB;
    }

    private static ImageDescriptor getCONNECTOR() {
        if (CONNECTOR == null) {
            CONNECTOR = J2EEProjectDecorator.getImageDescriptor("connector_ovr");
        }
        return CONNECTOR;
    }
}

